/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.isolation.IsolationException;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;

public class MapValueSnapshot
implements ValueSnapshot,
Isolatable<Map> {
    private final ImmutableMap<ValueSnapshot, ValueSnapshot> entries;

    public MapValueSnapshot(ImmutableMap<ValueSnapshot, ValueSnapshot> entries) {
        this.entries = entries;
    }

    public ImmutableMap<ValueSnapshot, ValueSnapshot> getEntries() {
        return this.entries;
    }

    public void appendToHasher(Hasher hasher) {
        hasher.putString((CharSequence)"Map");
        hasher.putInt(this.entries.size());
        for (Map.Entry entry : this.entries.entrySet()) {
            ((ValueSnapshot)entry.getKey()).appendToHasher(hasher);
            ((ValueSnapshot)entry.getValue()).appendToHasher(hasher);
        }
    }

    @Override
    public ValueSnapshot snapshot(Object value, ValueSnapshotter snapshotter) {
        ValueSnapshot newSnapshot = snapshotter.snapshot(value);
        if (this.equals(newSnapshot)) {
            return this;
        }
        return newSnapshot;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MapValueSnapshot other = (MapValueSnapshot)obj;
        return this.entries.equals(other.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    @Override
    public Map isolate() {
        LinkedHashMap map = new LinkedHashMap();
        for (Map.Entry entry : this.entries.entrySet()) {
            if (entry.getKey() instanceof Isolatable) {
                if (entry.getValue() instanceof Isolatable) {
                    map.put(((Isolatable)entry.getKey()).isolate(), ((Isolatable)entry.getValue()).isolate());
                    continue;
                }
                throw new IsolationException(entry.getValue());
            }
            throw new IsolationException(entry.getKey());
        }
        return map;
    }

    @Override
    @Nullable
    public <S> Isolatable<S> coerce(Class<S> type) {
        return null;
    }
}

