/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.filter.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class TmfFilterTraceTypeNode
extends TmfFilterTreeNode {
    public static final String NODE_NAME = "TRACETYPE";
    public static final String TYPE_ATTR = "type";
    public static final String NAME_ATTR = "name";
    private String fTraceTypeId;
    private Class<? extends ITmfTrace> fTraceClass;
    private String fName;

    public TmfFilterTraceTypeNode(ITmfFilterTreeNode parent) {
        super(parent);
    }

    @Override
    public String getNodeName() {
        return NODE_NAME;
    }

    public String getTraceTypeId() {
        return this.fTraceTypeId;
    }

    public void setTraceTypeId(String traceTypeId) {
        this.fTraceTypeId = traceTypeId;
    }

    public Class<? extends ITmfTrace> getTraceClass() {
        return this.fTraceClass;
    }

    public void setTraceClass(Class<? extends ITmfTrace> traceClass) {
        this.fTraceClass = traceClass;
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    @Override
    public boolean matches(ITmfEvent event) {
        boolean match = false;
        ITmfTrace trace = event.getTrace();
        if (trace.getClass().equals(this.fTraceClass)) {
            if (this.fTraceTypeId != null) {
                if (this.fTraceTypeId.equals(trace.getTraceTypeId())) {
                    match = true;
                }
            } else {
                match = true;
            }
        }
        if (match) {
            ITmfFilterTreeNode[] iTmfFilterTreeNodeArray = this.getChildren();
            int n = iTmfFilterTreeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITmfFilterTreeNode node = iTmfFilterTreeNodeArray[n2];
                if (!node.matches(event)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    @Override
    public List<String> getValidChildren() {
        if (this.getChildrenCount() == 0) {
            return super.getValidChildren();
        }
        return new ArrayList<String>(0);
    }

    @Override
    public String toString(boolean explicit) {
        StringBuilder buf = new StringBuilder();
        buf.append("TraceType is ");
        buf.append(this.fName);
        if (explicit) {
            buf.append('[');
            buf.append(this.fTraceTypeId);
            buf.append(']');
        }
        if (this.getChildrenCount() > 0) {
            buf.append(" and ");
        }
        if (this.getChildrenCount() > 1) {
            buf.append("( ");
        }
        int i = 0;
        while (i < this.getChildrenCount()) {
            ITmfFilterTreeNode node = this.getChildren()[i];
            buf.append(node.toString(explicit));
            if (i < this.getChildrenCount() - 1) {
                buf.append(" and ");
            }
            ++i;
        }
        if (this.getChildrenCount() > 1) {
            buf.append(" )");
        }
        return buf.toString();
    }
}

