/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.erd.ERDActivator;
import org.jkiss.dbeaver.ext.erd.editor.ERDAttributeVisibility;
import org.jkiss.dbeaver.ext.erd.editor.ERDViewStyle;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDContainer;
import org.jkiss.dbeaver.ext.erd.model.ERDDecorator;
import org.jkiss.dbeaver.ext.erd.model.ERDElement;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.model.ERDNote;
import org.jkiss.dbeaver.ext.erd.model.ERDObject;
import org.jkiss.dbeaver.ext.erd.model.ERDUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.ArrayUtils;

public class EntityDiagram
extends ERDObject<DBSObject>
implements ERDContainer {
    private ERDDecorator decorator;
    private String name;
    private final List<ERDEntity> entities = new ArrayList<ERDEntity>();
    private boolean layoutManualDesired = true;
    private boolean layoutManualAllowed = false;
    private boolean needsAutoLayout;
    private final Map<DBSEntity, ERDEntity> entityMap = new IdentityHashMap<DBSEntity, ERDEntity>();
    private final Map<ERDNote, NodeVisualInfo> noteVisuals = new IdentityHashMap<ERDNote, NodeVisualInfo>();
    private final Map<DBSEntity, NodeVisualInfo> entityVisuals = new IdentityHashMap<DBSEntity, NodeVisualInfo>();
    private final List<ERDNote> notes = new ArrayList<ERDNote>();
    private ERDAttributeVisibility attributeVisibility;
    private ERDViewStyle[] attributeStyles;
    private List<String> errorMessages = new ArrayList<String>();

    public EntityDiagram(ERDDecorator decorator, DBSObject container, String name) {
        super(container);
        this.decorator = decorator;
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this.name = name;
        IPreferenceStore store = ERDActivator.getDefault().getPreferenceStore();
        this.attributeVisibility = ERDAttributeVisibility.getDefaultVisibility(store);
        this.attributeStyles = ERDViewStyle.getDefaultStyles(store);
    }

    @Override
    public ERDDecorator getDecorator() {
        return this.decorator;
    }

    public boolean hasAttributeStyle(ERDViewStyle style) {
        return ArrayUtils.contains((Object[])this.attributeStyles, (Object)((Object)style));
    }

    public void setAttributeStyle(ERDViewStyle style, boolean enable) {
        this.attributeStyles = enable ? (ERDViewStyle[])ArrayUtils.add(ERDViewStyle.class, (Object[])this.attributeStyles, (Object)((Object)style)) : (ERDViewStyle[])ArrayUtils.remove(ERDViewStyle.class, (Object[])this.attributeStyles, (Object)((Object)style));
        ERDViewStyle.setDefaultStyles(ERDActivator.getDefault().getPreferences(), this.attributeStyles);
    }

    public ERDAttributeVisibility getAttributeVisibility() {
        return this.attributeVisibility;
    }

    public void setAttributeVisibility(ERDAttributeVisibility attributeVisibility) {
        this.attributeVisibility = attributeVisibility;
        ERDAttributeVisibility.setDefaultVisibility(ERDActivator.getDefault().getPreferences(), attributeVisibility);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEntityOrder(ERDEntity entity) {
        List<ERDEntity> list = this.entities;
        synchronized (list) {
            return this.entities.indexOf(entity);
        }
    }

    public void addEntity(ERDEntity entity, boolean reflect) {
        this.addEntity(entity, -1, reflect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntity(ERDEntity entity, int i, boolean reflect) {
        List<ERDEntity> list = this.entities;
        synchronized (list) {
            if (i < 0) {
                this.entities.add(entity);
            } else {
                this.entities.add(i, entity);
            }
            this.entityMap.put((DBSEntity)entity.getObject(), entity);
        }
        if (reflect) {
            this.firePropertyChange("CHILD", null, entity);
        }
        this.resolveRelations(reflect);
        if (reflect) {
            for (ERDAssociation rel : entity.getReferences()) {
                rel.getSourceEntity().firePropertyChange("OUTPUT", null, rel);
            }
            for (ERDAssociation rel : entity.getAssociations()) {
                rel.getTargetEntity().firePropertyChange("INPUT", null, rel);
            }
        }
    }

    private void resolveRelations(boolean reflect) {
        for (ERDEntity erdEntity : this.getEntities()) {
            erdEntity.resolveRelations(this, reflect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeEntity(ERDEntity entity, boolean reflect) {
        List<ERDEntity> list = this.entities;
        synchronized (list) {
            this.entityMap.remove(entity.getObject());
            this.entities.remove(entity);
        }
        if (reflect) {
            this.firePropertyChange("CHILD", entity, null);
        }
    }

    @Override
    public List<ERDEntity> getEntities() {
        return this.entities;
    }

    public List<ERDNote> getNotes() {
        return this.notes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNote(ERDNote note, boolean reflect) {
        List<ERDNote> list = this.notes;
        synchronized (list) {
            this.notes.add(note);
        }
        if (reflect) {
            this.firePropertyChange("CHILD", null, note);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNote(ERDNote note, boolean reflect) {
        List<ERDNote> list = this.notes;
        synchronized (list) {
            this.notes.remove(note);
        }
        if (reflect) {
            this.firePropertyChange("CHILD", note, null);
        }
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLayoutManualAllowed(boolean layoutManualAllowed) {
        this.layoutManualAllowed = layoutManualAllowed;
    }

    public boolean isLayoutManualDesired() {
        return this.layoutManualDesired;
    }

    public void setLayoutManualDesired(boolean layoutManualDesired) {
        this.layoutManualDesired = layoutManualDesired;
    }

    public boolean isLayoutManualAllowed() {
        return this.layoutManualAllowed;
    }

    public int getEntityCount() {
        return this.entities.size();
    }

    public EntityDiagram copy() {
        EntityDiagram copy = new EntityDiagram(this.decorator, (DBSObject)this.getObject(), this.getName());
        copy.entities.addAll(this.entities);
        copy.entityMap.putAll(this.entityMap);
        copy.layoutManualDesired = this.layoutManualDesired;
        copy.layoutManualAllowed = this.layoutManualAllowed;
        copy.noteVisuals.putAll(this.noteVisuals);
        copy.entityVisuals.putAll(this.entityVisuals);
        return copy;
    }

    public void fillEntities(DBRProgressMonitor monitor, Collection<DBSEntity> entities, DBSObject dbObject) {
        ERDEntity erdEntity;
        monitor.beginTask("Load entities metadata", entities.size());
        ArrayList<ERDEntity> entityCache = new ArrayList<ERDEntity>();
        for (DBSEntity table : entities) {
            if (monitor.isCanceled()) break;
            monitor.subTask("Load " + table.getName());
            erdEntity = ERDUtils.makeEntityFromObject(monitor, this, entityCache, table, null);
            erdEntity.setPrimary(table == dbObject);
            this.addEntity(erdEntity, false);
            this.entityMap.put(table, erdEntity);
            entityCache.add(erdEntity);
            monitor.worked(1);
        }
        monitor.done();
        monitor.beginTask("Load entities' relations", entities.size());
        for (DBSEntity table : entities) {
            if (monitor.isCanceled()) break;
            monitor.subTask("Load " + table.getName());
            erdEntity = this.entityMap.get(table);
            if (erdEntity != null) {
                erdEntity.addModelRelations(monitor, this, true, false);
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    public boolean containsTable(DBSEntity table) {
        for (ERDEntity erdEntity : this.entities) {
            if (erdEntity.getObject() != table) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<DBSEntity, ERDEntity> getEntityMap() {
        return this.entityMap;
    }

    public ERDEntity getEntity(DBSEntity table) {
        return this.entityMap.get(table);
    }

    public List<ERDEntity> getEntities(DBSEntity table) {
        ArrayList<ERDEntity> result = new ArrayList<ERDEntity>();
        for (ERDEntity entity : this.entities) {
            if (entity.getObject() != table) continue;
            result.add(entity);
        }
        return result;
    }

    public void clear() {
        this.entities.clear();
        this.entityMap.clear();
        this.noteVisuals.clear();
        this.entityVisuals.clear();
    }

    public NodeVisualInfo getVisualInfo(ERDNote erdObject) {
        return this.getVisualInfo(erdObject, false);
    }

    public NodeVisualInfo getVisualInfo(ERDNote erdObject, boolean create) {
        NodeVisualInfo visualInfo = this.noteVisuals.get(erdObject);
        if (visualInfo == null && create) {
            visualInfo = new NodeVisualInfo();
            this.noteVisuals.put(erdObject, visualInfo);
        }
        return visualInfo;
    }

    public NodeVisualInfo getVisualInfo(DBSEntity entity) {
        return this.getVisualInfo(entity, false);
    }

    public NodeVisualInfo getVisualInfo(DBSEntity entity, boolean create) {
        NodeVisualInfo visualInfo = this.entityVisuals.get(entity);
        if (visualInfo == null && create) {
            visualInfo = new NodeVisualInfo();
            this.entityVisuals.put(entity, visualInfo);
        }
        return visualInfo;
    }

    public void addVisualInfo(ERDNote note, NodeVisualInfo visualInfo) {
        this.noteVisuals.put(note, visualInfo);
    }

    public void addVisualInfo(DBSEntity entity, NodeVisualInfo visualInfo) {
        this.entityVisuals.put(entity, visualInfo);
    }

    public boolean isNeedsAutoLayout() {
        return this.needsAutoLayout;
    }

    public void setNeedsAutoLayout(boolean needsAutoLayout) {
        this.needsAutoLayout = needsAutoLayout;
    }

    public void addInitRelationBends(ERDElement<?> sourceEntity, ERDElement<?> targetEntity, String relName, List<Point> bends) {
        for (ERDAssociation rel : sourceEntity.getReferences()) {
            if (rel.getSourceEntity() != targetEntity || !relName.equals(((DBSEntityAssociation)rel.getObject()).getName())) continue;
            rel.setInitBends(bends);
        }
    }

    public List<ERDObject> getContents() {
        ArrayList<ERDObject> children = new ArrayList<ERDObject>(this.entities.size() + this.notes.size());
        children.addAll(this.entities);
        children.addAll(this.notes);
        children.sort((o1, o2) -> {
            NodeVisualInfo vi1 = o1 instanceof ERDNote ? this.noteVisuals.get(o1) : this.entityVisuals.get(o1.getObject());
            NodeVisualInfo vi2 = o2 instanceof ERDNote ? this.noteVisuals.get(o2) : this.entityVisuals.get(o2.getObject());
            return vi1 != null && vi2 != null ? vi1.zOrder - vi2.zOrder : 0;
        });
        return children;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public void addErrorMessage(String message) {
        this.errorMessages.add(message);
    }

    public static class NodeVisualInfo {
        public Rectangle initBounds;
        public boolean transparent;
        public Color bgColor;
        public Color fgColor;
        public Font font;
        public int zOrder = 0;
        public int borderWidth = -1;
        public ERDAttributeVisibility attributeVisibility;
    }
}

