/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.data;

import java.sql.SQLException;
import java.sql.Struct;
import java.util.Collection;
import java.util.Iterator;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataTypeAttribute;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCStructImpl;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCComposite;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCompositeStatic;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCStructValueHandler;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class PostgreStructValueHandler
extends JDBCStructValueHandler {
    private static final Log log = Log.getLog(PostgreStructValueHandler.class);
    public static final PostgreStructValueHandler INSTANCE = new PostgreStructValueHandler();

    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        if (value == null) {
            statement.setNull(paramIndex, 2002);
        } else if (value instanceof DBDComposite) {
            DBDComposite struct = (DBDComposite)value;
            if (struct.isNull()) {
                statement.setNull(paramIndex, 2002);
            } else if (struct instanceof JDBCComposite) {
                Object[] values = ((JDBCComposite)struct).getValues();
                String string = PostgreUtils.generateObjectString(values);
                statement.setObject(paramIndex, (Object)string, 1111);
            }
        } else {
            throw new DBCException("Struct parameter type '" + value.getClass().getName() + "' not supported");
        }
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy) throws DBCException {
        PostgreDataType structType = PostgreUtils.findDataType((PostgreDataSource)session.getDataSource(), type);
        if (structType == null) {
            throw new DBCException("Can't resolve struct type '" + type.getTypeName() + "'");
        }
        try {
            if (object == null) {
                return new JDBCCompositeStatic(session, (DBSDataType)structType, (Struct)new JDBCStructImpl(structType.getTypeName(), null, ""));
            }
            if (object instanceof JDBCCompositeStatic) {
                return copy ? ((JDBCCompositeStatic)object).cloneValue(session.getProgressMonitor()) : object;
            }
            Object value = PostgreUtils.isPGObject(object) ? PostgreUtils.extractPGObjectValue(object) : object.toString();
            return this.convertStringToStruct(session, structType, (String)value);
        }
        catch (DBException e) {
            throw new DBCException("Error converting string to composite type", (Throwable)e, session.getDataSource());
        }
    }

    private JDBCCompositeStatic convertStringToStruct(@NotNull DBCSession session, @NotNull PostgreDataType compType, @NotNull String value) throws DBException {
        Collection<PostgreDataTypeAttribute> attributes;
        if (value.startsWith("(") && value.endsWith(")")) {
            value = value.substring(1, value.length() - 1);
        }
        if ((attributes = compType.getAttributes(session.getProgressMonitor())) == null) {
            throw new DBException("Composite type '" + compType.getTypeName() + "' has no attributes");
        }
        String[] parsedValues = PostgreUtils.parseObjectString(value);
        if (parsedValues.length != attributes.size()) {
            log.debug((Object)("Number o attributes (" + attributes.size() + ") doesn't match actual number of parsed strings (" + parsedValues.length + ")"));
        }
        Object[] attrValues = new Object[attributes.size()];
        Iterator<PostgreDataTypeAttribute> attrIter = attributes.iterator();
        int i = 0;
        while (i < parsedValues.length && attrIter.hasNext()) {
            PostgreDataTypeAttribute itemAttr = attrIter.next();
            attrValues[i] = PostgreUtils.convertStringToValue(session, (DBSTypedObject)itemAttr, parsedValues[i], true);
            ++i;
        }
        JDBCStructImpl contents = new JDBCStructImpl(compType.getTypeName(), attrValues, value);
        return new JDBCCompositeStatic(session, (DBSDataType)compType, (Struct)contents);
    }
}

