/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.finder.viewer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.finder.AdvancedList;
import org.jkiss.dbeaver.ui.controls.finder.AdvancedListItem;

public class AdvancedListViewer
extends StructuredViewer {
    private static final Log log = Log.getLog(AdvancedListViewer.class);
    private AdvancedList control;

    public AdvancedListViewer(Composite parent, int style) {
        this.control = new AdvancedList(parent, style);
        this.control.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedListViewer.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)AdvancedListViewer.this, AdvancedListViewer.this.getSelection()));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AdvancedListViewer.this.fireDoubleClick(new DoubleClickEvent((Viewer)AdvancedListViewer.this, AdvancedListViewer.this.getSelection()));
            }
        });
        this.control.getContainer().addPaintListener(e -> {
            ViewerFilter[] filters = this.getFilters();
            if (this.control.getItems().length == 0 && filters != null && filters.length > 0) {
                UIUtils.drawMessageOverControl((Control)this.control.getContainer(), e, "No items found", 0);
            }
        });
    }

    public Control getControl() {
        return this.control;
    }

    protected Widget doFindInputItem(Object element) {
        return null;
    }

    protected Widget doFindItem(Object element) {
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
    }

    protected List getSelectionFromWidget() {
        ArrayList<Object> list = new ArrayList<Object>();
        AdvancedListItem item = this.control.getSelectedItem();
        if (item != null) {
            list.add(item.getData());
        }
        return list;
    }

    protected void internalRefresh(Object element) {
        this.control.removeAll();
        IStructuredContentProvider contentProvider = (IStructuredContentProvider)this.getContentProvider();
        ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
        IToolTipProvider toolTipProvider = labelProvider instanceof IToolTipProvider ? (IToolTipProvider)labelProvider : null;
        Object[] elements = contentProvider.getElements(element);
        Object[] objectArray = this.getFilters();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = objectArray[n2];
            elements = filter.filter((Viewer)this, null, elements);
            ++n2;
        }
        objectArray = elements;
        n = elements.length;
        n2 = 0;
        while (n2 < n) {
            ViewerFilter item = objectArray[n2];
            String text = labelProvider.getText((Object)item);
            Image icon = labelProvider.getImage((Object)item);
            String toolTip = toolTipProvider == null ? null : toolTipProvider.getToolTipText((Object)item);
            AdvancedListItem listItem = new AdvancedListItem(this.control, text, icon, toolTip);
            listItem.setData(item);
            ++n2;
        }
        UIUtils.asyncExec(() -> this.control.updateSize(true));
    }

    public void reveal(Object element) {
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        this.internalRefresh(this.getInput());
    }
}

