/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.views;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.mysql.MySQLMessages;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpen;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.dialogs.net.SSLConfiguratorAbstractUI;
import org.jkiss.utils.CommonUtils;

public class MySQLSSLConfigurator
extends SSLConfiguratorAbstractUI {
    private Button requireSSQL;
    private Button veryServerCert;
    private Button allowPublicKeyRetrieval;
    private TextWithOpen clientCertText;
    private TextWithOpen clientKeyText;
    private TextWithOpen clientCAText;
    private Text cipherSuitesText;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        gd.minimumHeight = 200;
        composite.setLayoutData((Object)gd);
        Group certGroup = UIUtils.createControlGroup((Composite)composite, (String)MySQLMessages.mysql_ssl_configurator_legend_certificates, (int)2, (int)768, (int)-1);
        UIUtils.createControlLabel((Composite)certGroup, (String)MySQLMessages.mysql_ssl_configurator_label_ca_certificate);
        gd = new GridData(768);
        gd.minimumWidth = 130;
        this.clientCAText = new TextWithOpenFile((Composite)certGroup, MySQLMessages.mysql_ssl_configurator_text_with_open_file_ca_certificate, new String[]{"*.*", "*.crt", "*.cert", "*.pem", "*"});
        this.clientCAText.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)certGroup, (String)MySQLMessages.mysql_ssl_configurator_label_ssl_certificate);
        gd = new GridData(768);
        gd.minimumWidth = 130;
        this.clientCertText = new TextWithOpenFile((Composite)certGroup, MySQLMessages.mysql_ssl_configurator_text_with_open_file_ssl_certificate, new String[]{"*.*", "*.cert", "*.pem", "*"});
        this.clientCertText.setLayoutData((Object)new GridData(768));
        UIUtils.createControlLabel((Composite)certGroup, (String)MySQLMessages.mysql_ssl_configurator_label_ssl_certificate_key);
        gd = new GridData(768);
        gd.minimumWidth = 130;
        this.clientKeyText = new TextWithOpenFile((Composite)certGroup, MySQLMessages.mysql_ssl_configurator_text_with_open_file_ssl_certificate_key, new String[]{"*.*", "*.cert", "*.pem", "*"});
        this.clientKeyText.setLayoutData((Object)new GridData(768));
        this.cipherSuitesText = UIUtils.createLabelText((Composite)certGroup, (String)MySQLMessages.mysql_ssl_configurator_label_cipher_suites, (String)"");
        this.cipherSuitesText.setToolTipText(MySQLMessages.mysql_ssl_configurator_label_cipher_suites_tip);
        Group advGroup = UIUtils.createControlGroup((Composite)composite, (String)MySQLMessages.mysql_ssl_configurator_legend_advanced, (int)2, (int)768, (int)-1);
        this.requireSSQL = UIUtils.createLabelCheckbox((Composite)advGroup, (String)MySQLMessages.mysql_ssl_configurator_checkbox_require_ssl, (String)MySQLMessages.mysql_ssl_configurator_checkbox_require_ssl_tip, (boolean)false);
        this.veryServerCert = UIUtils.createLabelCheckbox((Composite)advGroup, (String)MySQLMessages.mysql_ssl_configurator_checkbox_verify_server_certificate, (String)MySQLMessages.mysql_ssl_configurator_checkbox_verify_server_certificate_tip, (boolean)true);
        this.allowPublicKeyRetrieval = UIUtils.createLabelCheckbox((Composite)advGroup, (String)MySQLMessages.mysql_ssl_configurator_checkbox_allow_public_key, (String)MySQLMessages.mysql_ssl_configurator_checkbox_allow_public_key_tip, (boolean)false);
    }

    public void loadSettings(DBWHandlerConfiguration configuration) {
        this.requireSSQL.setSelection(CommonUtils.getBoolean((String)((String)configuration.getProperties().get("ssl.require")), (boolean)false));
        this.veryServerCert.setSelection(CommonUtils.getBoolean((String)((String)configuration.getProperties().get("ssl.verify.server")), (boolean)true));
        this.allowPublicKeyRetrieval.setSelection(CommonUtils.getBoolean((String)((String)configuration.getProperties().get("ssl.public.key.retrieve")), (boolean)false));
        this.clientCertText.setText(CommonUtils.notEmpty((String)((String)configuration.getProperties().get("ssl.client.cert"))));
        this.clientKeyText.setText(CommonUtils.notEmpty((String)((String)configuration.getProperties().get("ssl.client.key"))));
        this.clientCAText.setText(CommonUtils.notEmpty((String)((String)configuration.getProperties().get("ssl.ca.cert"))));
        this.cipherSuitesText.setText(CommonUtils.notEmpty((String)((String)configuration.getProperties().get("ssl.cipher.suites"))));
    }

    public void saveSettings(DBWHandlerConfiguration configuration) {
        configuration.getProperties().put("ssl.require", String.valueOf(this.requireSSQL.getSelection()));
        configuration.getProperties().put("ssl.verify.server", String.valueOf(this.veryServerCert.getSelection()));
        configuration.getProperties().put("ssl.public.key.retrieve", String.valueOf(this.allowPublicKeyRetrieval.getSelection()));
        configuration.getProperties().put("ssl.client.cert", this.clientCertText.getText());
        configuration.getProperties().put("ssl.client.key", this.clientKeyText.getText());
        configuration.getProperties().put("ssl.ca.cert", this.clientCAText.getText());
        configuration.getProperties().put("ssl.cipher.suites", this.cipherSuitesText.getText());
    }
}

