/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model.plan;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.plan.OraclePlanNode;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlan;
import org.jkiss.dbeaver.model.impl.plan.ExecutionPlanDeserializer;
import org.jkiss.utils.IntKeyMap;

public class OraclePlanLoader
extends AbstractExecutionPlan {
    private String query;
    private List<OraclePlanNode> rootNodes;
    IntKeyMap<OraclePlanNode> allNodes = new IntKeyMap();

    public String getQueryString() {
        return this.query;
    }

    public String getPlanQueryString() throws DBException {
        return "LOADED " + this.query;
    }

    public List<? extends DBCPlanNode> getPlanNodes(Map<String, Object> options) {
        return this.rootNodes;
    }

    public Object getPlanFeature(String feature) {
        if ("plan.cost".equals(feature) || "plan.duration".equals(feature) || "plan.rows".equals(feature)) {
            return true;
        }
        return super.getPlanFeature(feature);
    }

    private Map<String, String> getNodeAttributes(JsonObject nodeObject) {
        HashMap<String, String> attributes = new HashMap<String, String>(44);
        JsonArray attrs = nodeObject.getAsJsonArray("attributes");
        for (JsonElement attr : attrs) {
            for (Map.Entry p : attr.getAsJsonObject().entrySet()) {
                attributes.put((String)p.getKey(), ((JsonElement)p.getValue()).getAsString());
            }
        }
        return attributes;
    }

    public void deserialize(OracleDataSource dataSource, Reader planData) throws InvocationTargetException {
        try {
            JsonObject jo = new JsonParser().parse(planData).getAsJsonObject();
            this.query = jo.get("sql").getAsString();
            ExecutionPlanDeserializer loader = new ExecutionPlanDeserializer();
            this.rootNodes = loader.loadRoot((DBPDataSource)dataSource, jo, (datasource, node, parent) -> {
                OraclePlanNode nodeOra = new OraclePlanNode(dataSource, this.allNodes, this.getNodeAttributes(node));
                this.allNodes.put(nodeOra.getId(), (Object)nodeOra);
                return nodeOra;
            });
        }
        catch (Throwable e) {
            throw new InvocationTargetException(e);
        }
    }
}

