/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.main;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import com.google.turbine.binder.Binder;
import com.google.turbine.binder.ClassPath;
import com.google.turbine.binder.ClassPathBinder;
import com.google.turbine.binder.CtSymClassBinder;
import com.google.turbine.binder.JimageClassBinder;
import com.google.turbine.deps.Dependencies;
import com.google.turbine.deps.Transitive;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.lower.Lower;
import com.google.turbine.main.UsageException;
import com.google.turbine.options.TurbineOptions;
import com.google.turbine.options.TurbineOptionsParser;
import com.google.turbine.parse.Parser;
import com.google.turbine.proto.DepsProto;
import com.google.turbine.tree.Tree;
import com.google.turbine.zip.Zip;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class Main {
    private static final int BUFFER_SIZE = 65536;
    static final String MANIFEST_DIR = "META-INF/";
    static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    static final Attributes.Name TARGET_LABEL = new Attributes.Name("Target-Label");
    static final Attributes.Name INJECTING_RULE_KIND = new Attributes.Name("Injecting-Rule-Kind");
    static final long DEFAULT_TIMESTAMP = LocalDateTime.of(2010, 1, 1, 0, 0, 0).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();

    public static void main(String[] args) throws IOException {
        boolean ok;
        try {
            ok = Main.compile(args);
        }
        catch (TurbineError | UsageException e) {
            System.err.println(e.getMessage());
            ok = false;
        }
        catch (Throwable turbineCrash) {
            turbineCrash.printStackTrace();
            ok = false;
        }
        System.exit(ok ? 0 : 1);
    }

    public static boolean compile(String[] args) throws IOException {
        TurbineOptions options = TurbineOptionsParser.parse(Arrays.asList(args));
        return Main.compile(options);
    }

    public static boolean compile(TurbineOptions options) throws IOException {
        Main.usage(options);
        ImmutableList<Tree.CompUnit> units = Main.parseAll(options);
        ClassPath bootclasspath = Main.bootclasspath(options);
        Collection<String> reducedClasspath = Dependencies.reduceClasspath(options.classPath(), options.directJars(), options.depsArtifacts());
        ClassPath classpath = ClassPathBinder.bindClasspath(Main.toPaths(reducedClasspath));
        Binder.BindingResult bound = Binder.bind(units, classpath, bootclasspath, Optional.empty());
        Lower.Lowered lowered = Lower.lowerAll(bound.units(), bound.modules(), bound.classPathEnv());
        ImmutableMap<String, byte[]> transitive = Transitive.collectDeps(bootclasspath, bound);
        if (options.outputDeps().isPresent()) {
            DepsProto.Dependencies deps = Dependencies.collectDeps(options.targetLabel(), bootclasspath, bound, lowered);
            try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(Paths.get(options.outputDeps().get(), new String[0]), new OpenOption[0]));){
                deps.writeTo(os);
            }
        }
        Main.writeOutput(options, lowered.bytes(), transitive);
        return true;
    }

    private static void usage(TurbineOptions options) {
        if (!options.processors().isEmpty()) {
            throw new UsageException("--processors is not supported");
        }
        if (options.sources().isEmpty() && options.sourceJars().isEmpty()) {
            throw new UsageException("no sources were provided");
        }
        if (options.help()) {
            throw new UsageException();
        }
        if (!options.output().isPresent()) {
            throw new UsageException("--output is required");
        }
    }

    private static ClassPath bootclasspath(TurbineOptions options) throws IOException {
        if (options.release().isPresent() && options.system().isPresent()) {
            throw new UsageException("expected at most one of --release and --system");
        }
        if (options.release().isPresent()) {
            String release = options.release().get();
            if (release.equals(System.getProperty("java.specification.version"))) {
                return JimageClassBinder.bindDefault();
            }
            ClassPath bootclasspath = CtSymClassBinder.bind(release);
            if (bootclasspath == null) {
                throw new UsageException("not a supported release: " + release);
            }
            return bootclasspath;
        }
        if (options.system().isPresent()) {
            return JimageClassBinder.bind(options.system().get());
        }
        return ClassPathBinder.bindClasspath(Main.toPaths(options.bootClassPath()));
    }

    private static ImmutableList<Tree.CompUnit> parseAll(TurbineOptions options) throws IOException {
        ImmutableList.Builder units = ImmutableList.builder();
        for (String source : options.sources()) {
            Path path = Paths.get(source, new String[0]);
            units.add((Object)Parser.parse(new SourceFile(source, new String(Files.readAllBytes(path), StandardCharsets.UTF_8))));
        }
        for (String sourceJar : options.sourceJars()) {
            for (Zip.Entry ze : new Zip.ZipIterable(Paths.get(sourceJar, new String[0]))) {
                if (!ze.name().endsWith(".java")) continue;
                String name = ze.name();
                String source = new String(ze.data(), StandardCharsets.UTF_8);
                units.add((Object)Parser.parse(new SourceFile(name, source)));
            }
        }
        return units.build();
    }

    private static void writeOutput(TurbineOptions options, Map<String, byte[]> lowered, Map<String, byte[]> transitive) throws IOException {
        Path path = Paths.get(options.output().get(), new String[0]);
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);
             BufferedOutputStream bos = new BufferedOutputStream(os, 65536);
             JarOutputStream jos = new JarOutputStream(bos);){
            for (Map.Entry<String, byte[]> entry : lowered.entrySet()) {
                Main.addEntry(jos, entry.getKey() + ".class", entry.getValue());
            }
            for (Map.Entry<String, byte[]> entry : transitive.entrySet()) {
                Main.addEntry(jos, "META-INF/TRANSITIVE/" + entry.getKey() + ".class", entry.getValue());
            }
            if (options.targetLabel().isPresent()) {
                Main.addEntry(jos, MANIFEST_DIR, new byte[0]);
                Main.addEntry(jos, MANIFEST_NAME, Main.manifestContent(options));
            }
        }
    }

    private static void addEntry(JarOutputStream jos, String name, byte[] bytes) throws IOException {
        JarEntry je = new JarEntry(name);
        je.setTime(DEFAULT_TIMESTAMP);
        je.setMethod(0);
        je.setSize(bytes.length);
        je.setCrc(Hashing.crc32().hashBytes(bytes).padToLong());
        jos.putNextEntry(je);
        jos.write(bytes);
    }

    private static byte[] manifestContent(TurbineOptions turbineOptions) throws IOException {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        Attributes.Name createdBy = new Attributes.Name("Created-By");
        if (attributes.getValue(createdBy) == null) {
            attributes.put(createdBy, "bazel");
        }
        if (turbineOptions.targetLabel().isPresent()) {
            attributes.put(TARGET_LABEL, turbineOptions.targetLabel().get());
        }
        if (turbineOptions.injectingRuleKind().isPresent()) {
            attributes.put(INJECTING_RULE_KIND, turbineOptions.injectingRuleKind().get());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        manifest.write(out);
        return out.toByteArray();
    }

    private static ImmutableList<Path> toPaths(Iterable<String> paths) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (String path : paths) {
            result.add((Object)Paths.get(path, new String[0]));
        }
        return result.build();
    }
}

