(function() {
  var path;

  path = require("path");

  module.exports = {
    repoForPath: function(goalPath) {
      var i, j, len, projectPath, ref;
      ref = atom.project.getPaths();
      for (i = j = 0, len = ref.length; j < len; i = ++j) {
        projectPath = ref[i];
        if (goalPath === projectPath || goalPath.indexOf(projectPath + path.sep) === 0) {
          return atom.project.getRepositories()[i];
        }
      }
      return null;
    },
    getStyleObject: function(el) {
      var camelizedAttr, property, styleObject, styleProperties, value;
      styleProperties = window.getComputedStyle(el);
      styleObject = {};
      for (property in styleProperties) {
        value = styleProperties.getPropertyValue(property);
        camelizedAttr = property.replace(/\-([a-z])/g, function(a, b) {
          return b.toUpperCase();
        });
        styleObject[camelizedAttr] = value;
      }
      return styleObject;
    },
    getFullExtension: function(filePath) {
      var basename, position;
      basename = path.basename(filePath);
      position = basename.indexOf('.');
      if (position > 0) {
        return basename.slice(position);
      } else {
        return '';
      }
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zNy4wL291dC9hcHAvbm9kZV9tb2R1bGVzL3RyZWUtdmlldy9saWIvaGVscGVycy5jb2ZmZWUiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQSxNQUFBOztFQUFBLElBQUEsR0FBTyxPQUFBLENBQVEsTUFBUjs7RUFFUCxNQUFNLENBQUMsT0FBUCxHQUNFO0lBQUEsV0FBQSxFQUFhLFNBQUMsUUFBRDtBQUNYLFVBQUE7QUFBQTtBQUFBLFdBQUEsNkNBQUE7O1FBQ0UsSUFBRyxRQUFBLEtBQVksV0FBWixJQUEyQixRQUFRLENBQUMsT0FBVCxDQUFpQixXQUFBLEdBQWMsSUFBSSxDQUFDLEdBQXBDLENBQUEsS0FBNEMsQ0FBMUU7QUFDRSxpQkFBTyxJQUFJLENBQUMsT0FBTyxDQUFDLGVBQWIsQ0FBQSxDQUErQixDQUFBLENBQUEsRUFEeEM7O0FBREY7YUFHQTtJQUpXLENBQWI7SUFNQSxjQUFBLEVBQWdCLFNBQUMsRUFBRDtBQUNkLFVBQUE7TUFBQSxlQUFBLEdBQWtCLE1BQU0sQ0FBQyxnQkFBUCxDQUF3QixFQUF4QjtNQUNsQixXQUFBLEdBQWM7QUFDZCxXQUFBLDJCQUFBO1FBQ0UsS0FBQSxHQUFRLGVBQWUsQ0FBQyxnQkFBaEIsQ0FBaUMsUUFBakM7UUFDUixhQUFBLEdBQWdCLFFBQVEsQ0FBQyxPQUFULENBQWlCLFlBQWpCLEVBQStCLFNBQUMsQ0FBRCxFQUFJLENBQUo7aUJBQVUsQ0FBQyxDQUFDLFdBQUYsQ0FBQTtRQUFWLENBQS9CO1FBQ2hCLFdBQVksQ0FBQSxhQUFBLENBQVosR0FBNkI7QUFIL0I7YUFJQTtJQVBjLENBTmhCO0lBZUEsZ0JBQUEsRUFBa0IsU0FBQyxRQUFEO0FBQ2hCLFVBQUE7TUFBQSxRQUFBLEdBQVcsSUFBSSxDQUFDLFFBQUwsQ0FBYyxRQUFkO01BQ1gsUUFBQSxHQUFXLFFBQVEsQ0FBQyxPQUFULENBQWlCLEdBQWpCO01BQ1gsSUFBRyxRQUFBLEdBQVcsQ0FBZDtlQUFxQixRQUFTLGlCQUE5QjtPQUFBLE1BQUE7ZUFBK0MsR0FBL0M7O0lBSGdCLENBZmxCOztBQUhGIiwic291cmNlc0NvbnRlbnQiOlsicGF0aCA9IHJlcXVpcmUgXCJwYXRoXCJcblxubW9kdWxlLmV4cG9ydHMgPVxuICByZXBvRm9yUGF0aDogKGdvYWxQYXRoKSAtPlxuICAgIGZvciBwcm9qZWN0UGF0aCwgaSBpbiBhdG9tLnByb2plY3QuZ2V0UGF0aHMoKVxuICAgICAgaWYgZ29hbFBhdGggaXMgcHJvamVjdFBhdGggb3IgZ29hbFBhdGguaW5kZXhPZihwcm9qZWN0UGF0aCArIHBhdGguc2VwKSBpcyAwXG4gICAgICAgIHJldHVybiBhdG9tLnByb2plY3QuZ2V0UmVwb3NpdG9yaWVzKClbaV1cbiAgICBudWxsXG5cbiAgZ2V0U3R5bGVPYmplY3Q6IChlbCkgLT5cbiAgICBzdHlsZVByb3BlcnRpZXMgPSB3aW5kb3cuZ2V0Q29tcHV0ZWRTdHlsZShlbClcbiAgICBzdHlsZU9iamVjdCA9IHt9XG4gICAgZm9yIHByb3BlcnR5IG9mIHN0eWxlUHJvcGVydGllc1xuICAgICAgdmFsdWUgPSBzdHlsZVByb3BlcnRpZXMuZ2V0UHJvcGVydHlWYWx1ZSBwcm9wZXJ0eVxuICAgICAgY2FtZWxpemVkQXR0ciA9IHByb3BlcnR5LnJlcGxhY2UgL1xcLShbYS16XSkvZywgKGEsIGIpIC0+IGIudG9VcHBlckNhc2UoKVxuICAgICAgc3R5bGVPYmplY3RbY2FtZWxpemVkQXR0cl0gPSB2YWx1ZVxuICAgIHN0eWxlT2JqZWN0XG5cbiAgZ2V0RnVsbEV4dGVuc2lvbjogKGZpbGVQYXRoKSAtPlxuICAgIGJhc2VuYW1lID0gcGF0aC5iYXNlbmFtZShmaWxlUGF0aClcbiAgICBwb3NpdGlvbiA9IGJhc2VuYW1lLmluZGV4T2YoJy4nKVxuICAgIGlmIHBvc2l0aW9uID4gMCB0aGVuIGJhc2VuYW1lW3Bvc2l0aW9uLi5dIGVsc2UgJydcbiJdfQ==
