Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

exports.activate = activate;
exports.deactivate = deactivate;
exports.consumeStatusBar = consumeStatusBar;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var _statusBarItem = require('./status-bar-item');

var _statusBarItem2 = _interopRequireDefault(_statusBarItem);

var _helpers = require('./helpers');

var _helpers2 = _interopRequireDefault(_helpers);

'use babel';

var LineEndingRegExp = /\r\n|\n/g;

// the following regular expression is executed natively via the `substring` package,
// where `\A` corresponds to the beginning of the string.
// More info: https://github.com/atom/line-ending-selector/pull/56
// eslint-disable-next-line no-useless-escape
var LFRegExp = /(\A|[^\r])\n/g;
var CRLFRegExp = /\r\n/g;

var disposables = null;
var modalPanel = null;
var lineEndingListView = null;

function activate() {
  disposables = new _atom.CompositeDisposable();

  disposables.add(atom.commands.add('atom-text-editor', {
    'line-ending-selector:show': function lineEndingSelectorShow(event) {
      if (!modalPanel) {
        lineEndingListView = new _atomSelectList2['default']({
          items: [{ name: 'LF', value: '\n' }, { name: 'CRLF', value: '\r\n' }],
          filterKeyForItem: function filterKeyForItem(lineEnding) {
            return lineEnding.name;
          },
          didConfirmSelection: function didConfirmSelection(lineEnding) {
            setLineEnding(atom.workspace.getActiveTextEditor(), lineEnding.value);
            modalPanel.hide();
          },
          didCancelSelection: function didCancelSelection() {
            modalPanel.hide();
          },
          elementForItem: function elementForItem(lineEnding) {
            var element = document.createElement('li');
            element.textContent = lineEnding.name;
            return element;
          }
        });
        modalPanel = atom.workspace.addModalPanel({
          item: lineEndingListView
        });
        disposables.add(new _atom.Disposable(function () {
          lineEndingListView.destroy();
          modalPanel.destroy();
          modalPanel = null;
        }));
      }

      lineEndingListView.reset();
      modalPanel.show();
      lineEndingListView.focus();
    },

    'line-ending-selector:convert-to-LF': function lineEndingSelectorConvertToLF(event) {
      var editorElement = event.target.closest('atom-text-editor');
      setLineEnding(editorElement.getModel(), '\n');
    },

    'line-ending-selector:convert-to-CRLF': function lineEndingSelectorConvertToCRLF(event) {
      var editorElement = event.target.closest('atom-text-editor');
      setLineEnding(editorElement.getModel(), '\r\n');
    }
  }));
}

function deactivate() {
  disposables.dispose();
}

function consumeStatusBar(statusBar) {
  var statusBarItem = new _statusBarItem2['default']();
  var currentBufferDisposable = null;
  var tooltipDisposable = null;

  var updateTile = _underscorePlus2['default'].debounce(function (buffer) {
    getLineEndings(buffer).then(function (lineEndings) {
      if (lineEndings.size === 0) {
        var defaultLineEnding = getDefaultLineEnding();
        buffer.setPreferredLineEnding(defaultLineEnding);
        lineEndings = new Set().add(defaultLineEnding);
      }
      statusBarItem.setLineEndings(lineEndings);
    });
  }, 0);

  disposables.add(atom.workspace.observeActiveTextEditor(function (editor) {
    if (currentBufferDisposable) currentBufferDisposable.dispose();

    if (editor && editor.getBuffer) {
      (function () {
        var buffer = editor.getBuffer();
        updateTile(buffer);
        currentBufferDisposable = buffer.onDidChange(function (_ref) {
          var oldText = _ref.oldText;
          var newText = _ref.newText;

          if (!statusBarItem.hasLineEnding('\n')) {
            if (newText.indexOf('\n') >= 0) {
              updateTile(buffer);
            }
          } else if (!statusBarItem.hasLineEnding('\r\n')) {
            if (newText.indexOf('\r\n') >= 0) {
              updateTile(buffer);
            }
          } else if (oldText.indexOf('\n')) {
            updateTile(buffer);
          }
        });
      })();
    } else {
      statusBarItem.setLineEndings(new Set());
      currentBufferDisposable = null;
    }

    if (tooltipDisposable) {
      disposables.remove(tooltipDisposable);
      tooltipDisposable.dispose();
    }
    tooltipDisposable = atom.tooltips.add(statusBarItem.element, {
      title: function title() {
        return 'File uses ' + statusBarItem.description() + ' line endings';
      }
    });
    disposables.add(tooltipDisposable);
  }));

  disposables.add(new _atom.Disposable(function () {
    if (currentBufferDisposable) currentBufferDisposable.dispose();
  }));

  statusBarItem.onClick(function () {
    var editor = atom.workspace.getActiveTextEditor();
    atom.commands.dispatch(atom.views.getView(editor), 'line-ending-selector:show');
  });

  var tile = statusBar.addRightTile({ item: statusBarItem, priority: 200 });
  disposables.add(new _atom.Disposable(function () {
    return tile.destroy();
  }));
}

function getDefaultLineEnding() {
  switch (atom.config.get('line-ending-selector.defaultLineEnding')) {
    case 'LF':
      return '\n';
    case 'CRLF':
      return '\r\n';
    case 'OS Default':
    default:
      return _helpers2['default'].getProcessPlatform() === 'win32' ? '\r\n' : '\n';
  }
}

function getLineEndings(buffer) {
  if (typeof buffer.find === 'function') {
    return Promise.all([buffer.find(LFRegExp), buffer.find(CRLFRegExp)]).then(function (_ref2) {
      var _ref22 = _slicedToArray(_ref2, 2);

      var hasLF = _ref22[0];
      var hasCRLF = _ref22[1];

      var result = new Set();
      if (hasLF) result.add('\n');
      if (hasCRLF) result.add('\r\n');
      return result;
    });
  } else {
    return new Promise(function (resolve) {
      var result = new Set();
      for (var i = 0; i < buffer.getLineCount() - 1; i++) {
        result.add(buffer.lineEndingForRow(i));
      }
      resolve(result);
    });
  }
}

function setLineEnding(item, lineEnding) {
  if (item && item.getBuffer) {
    var buffer = item.getBuffer();
    buffer.setPreferredLineEnding(lineEnding);
    buffer.setText(buffer.getText().replace(LineEndingRegExp, lineEnding));
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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