Object.defineProperty(exports, '__esModule', {
  value: true
});
/** @babel */

var _atom = require('atom');

var reporter = undefined;

function getReporter() {
  if (!reporter) {
    var Reporter = require('./reporter');
    reporter = new Reporter();
  }
  return reporter;
}

exports['default'] = {
  activate: function activate() {
    this.subscriptions = new _atom.CompositeDisposable();

    if (!atom.config.get('exception-reporting.userId')) {
      atom.config.set('exception-reporting.userId', require('node-uuid').v4());
    }

    this.subscriptions.add(atom.onDidThrowError(function (_ref) {
      var message = _ref.message;
      var url = _ref.url;
      var line = _ref.line;
      var column = _ref.column;
      var originalError = _ref.originalError;

      try {
        getReporter().reportUncaughtException(originalError);
      } catch (secondaryException) {
        try {
          console.error('Error reporting uncaught exception', secondaryException);
          getReporter().reportUncaughtException(secondaryException);
        } catch (error) {}
      }
    }));

    if (atom.onDidFailAssertion != null) {
      this.subscriptions.add(atom.onDidFailAssertion(function (error) {
        try {
          getReporter().reportFailedAssertion(error);
        } catch (secondaryException) {
          try {
            console.error('Error reporting assertion failure', secondaryException);
            getReporter().reportUncaughtException(secondaryException);
          } catch (error) {}
        }
      }));
    }
  }
};
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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