'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});
exports['default'] = render;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var _updateProps = require('./update-props');

var _updateProps2 = _interopRequireDefault(_updateProps);

function render(virtualNode, options) {
  var domNode = undefined;
  if (virtualNode.text != null) {
    domNode = document.createTextNode(virtualNode.text);
  } else {
    var tag = virtualNode.tag;
    var children = virtualNode.children;
    var props = virtualNode.props;

    if (typeof tag === 'function') {
      var ref = undefined;
      if (props && props.ref) {
        var _props = props;
        ref = _props.ref;
        props = _objectWithoutProperties(_props, ['ref']);
      }
      var component = new tag(props || {}, children);
      virtualNode.component = component;
      domNode = component.element;
      if (options && options.refs && ref) {
        options.refs[ref] = component;
      }
    } else {
      domNode = document.createElement(tag);
      if (children) addChildren(domNode, children, options);
      if (props) (0, _updateProps2['default'])(domNode, null, virtualNode, options);
    }
  }
  virtualNode.domNode = domNode;
  return domNode;
}

function addChildren(parent, children, options) {
  for (var i = 0; i < children.length; i++) {
    parent.appendChild(render(children[i], options));
  }
}
module.exports = exports['default'];