/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.prism;

import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageLoadListener;
import com.sun.javafx.iio.ImageLoader;
import com.sun.javafx.iio.ImageMetadata;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.iio.ImageStorageException;
import com.sun.javafx.webkit.prism.PrismImage;
import com.sun.javafx.webkit.prism.WCImageImpl;
import com.sun.webkit.graphics.WCGraphicsManager;
import com.sun.webkit.graphics.WCImage;
import com.sun.webkit.graphics.WCImageDecoder;
import com.sun.webkit.graphics.WCImageFrame;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.concurrent.Service;
import javafx.concurrent.Task;

final class WCImageDecoderImpl
extends WCImageDecoder {
    private static final Logger log = Logger.getLogger(WCImageDecoderImpl.class.getName());
    private Service<ImageFrame[]> loader;
    private int imageWidth = 0;
    private int imageHeight = 0;
    private ImageFrame[] frames;
    private int frameCount = 0;
    private boolean fullDataReceived = false;
    private boolean framesDecoded = false;
    private PrismImage[] images;
    private volatile byte[] data;
    private volatile int dataSize = 0;
    private final ImageLoadListener readerListener = new ImageLoadListener(){

        @Override
        public void imageLoadProgress(ImageLoader l, float p) {
        }

        @Override
        public void imageLoadWarning(ImageLoader l, String warning) {
        }

        @Override
        public void imageLoadMetaData(ImageLoader l, ImageMetadata metadata) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(String.format("%X Image size %dx%d", this.hashCode(), metadata.imageWidth, metadata.imageHeight));
            }
            if (WCImageDecoderImpl.this.imageWidth < metadata.imageWidth) {
                WCImageDecoderImpl.this.imageWidth = metadata.imageWidth;
            }
            if (WCImageDecoderImpl.this.imageHeight < metadata.imageHeight) {
                WCImageDecoderImpl.this.imageHeight = metadata.imageHeight;
            }
        }
    };
    private static final ThreadLocal<int[]> THREAD_LOCAL_SIZE_ARRAY = new ThreadLocal<int[]>(){

        @Override
        protected int[] initialValue() {
            return new int[2];
        }
    };

    WCImageDecoderImpl() {
    }

    @Override
    protected synchronized void destroy() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("%X Destroy image decoder", this.hashCode()));
        }
        this.destroyLoader();
        this.frames = null;
        this.images = null;
        this.framesDecoded = false;
    }

    @Override
    protected String getFilenameExtension() {
        return ".img";
    }

    private boolean imageSizeAvilable() {
        return this.imageWidth > 0 && this.imageHeight > 0;
    }

    @Override
    protected void addImageData(byte[] dataPortion) {
        if (dataPortion != null) {
            this.fullDataReceived = false;
            if (this.data == null) {
                this.data = Arrays.copyOf(dataPortion, dataPortion.length * 2);
                this.dataSize = dataPortion.length;
            } else {
                int newDataSize = this.dataSize + dataPortion.length;
                if (newDataSize > this.data.length) {
                    this.resizeDataArray(Math.max(newDataSize, this.data.length * 2));
                }
                System.arraycopy(dataPortion, 0, this.data, this.dataSize, dataPortion.length);
                this.dataSize = newDataSize;
            }
            if (!this.imageSizeAvilable()) {
                this.loadFrames();
            }
        } else if (this.data != null && !this.fullDataReceived) {
            if (this.data.length > this.dataSize) {
                this.resizeDataArray(this.dataSize);
            }
            this.fullDataReceived = true;
        }
    }

    private void destroyLoader() {
        if (this.loader != null) {
            this.loader.cancel();
            this.loader = null;
        }
    }

    private void startLoader() {
        if (this.loader == null) {
            this.loader = new Service<ImageFrame[]>(){

                @Override
                protected Task<ImageFrame[]> createTask() {
                    return new Task<ImageFrame[]>(){

                        @Override
                        protected ImageFrame[] call() throws Exception {
                            return WCImageDecoderImpl.this.loadFrames();
                        }
                    };
                }
            };
            this.loader.valueProperty().addListener((ov, old, frames) -> {
                if (frames != null && this.loader != null) {
                    this.setFrames((ImageFrame[])frames);
                }
            });
        }
        if (!this.loader.isRunning()) {
            this.loader.restart();
        }
    }

    private void resizeDataArray(int newDataSize) {
        byte[] newData = new byte[newDataSize];
        System.arraycopy(this.data, 0, newData, 0, this.dataSize);
        this.data = newData;
    }

    @Override
    protected void loadFromResource(String name) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("%X Load image from resource '%s'", this.hashCode(), name));
        }
        String resourceName = WCGraphicsManager.getResourceName(name);
        InputStream in = this.getClass().getResourceAsStream(resourceName);
        if (in == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(String.format("%X Unable to open resource '%s'", this.hashCode(), resourceName));
            }
            return;
        }
        this.setFrames(this.loadFrames(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageFrame[] loadFrames(InputStream in) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("%X Decoding frames", this.hashCode()));
        }
        try {
            ImageFrame[] imageFrameArray = ImageStorage.loadAll(in, this.readerListener, 0, 0, true, 1.0f, false);
            return imageFrameArray;
        }
        catch (ImageStorageException e) {
            ImageFrame[] imageFrameArray = null;
            return imageFrameArray;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    private ImageFrame[] loadFrames() {
        return this.loadFrames(new ByteArrayInputStream(this.data, 0, this.dataSize));
    }

    @Override
    protected int[] getImageSize() {
        int[] size = THREAD_LOCAL_SIZE_ARRAY.get();
        size[0] = this.imageWidth;
        size[1] = this.imageHeight;
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("%X image size = %dx%d", this.hashCode(), size[0], size[1]));
        }
        return size;
    }

    private synchronized void setFrames(ImageFrame[] frames) {
        this.frames = frames;
        this.images = null;
        this.frameCount = frames == null ? 0 : frames.length;
    }

    @Override
    protected int getFrameCount() {
        if (this.fullDataReceived) {
            this.getImageFrame(0);
        }
        return this.frameCount;
    }

    @Override
    protected synchronized WCImageFrame getFrame(int idx) {
        ImageFrame frame = this.getImageFrame(idx);
        if (frame != null) {
            if (log.isLoggable(Level.FINE)) {
                ImageStorage.ImageType type = frame.getImageType();
                log.fine(String.format("%X getFrame(%d): image type = %s", new Object[]{this.hashCode(), idx, type}));
            }
            PrismImage img = this.getPrismImage(idx, frame);
            return new Frame(img);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("%X FAILED getFrame(%d)", this.hashCode(), idx));
        }
        return null;
    }

    private synchronized ImageMetadata getFrameMetadata(int idx) {
        return this.frames != null && this.frames.length > idx && this.frames[idx] != null ? this.frames[idx].getMetadata() : null;
    }

    @Override
    protected int getFrameDuration(int idx) {
        int dur;
        ImageMetadata meta = this.getFrameMetadata(idx);
        int n = dur = meta == null || meta.delayTime == null ? 0 : meta.delayTime;
        if (dur < 11) {
            dur = 100;
        }
        return dur;
    }

    @Override
    protected int[] getFrameSize(int idx) {
        ImageMetadata meta = this.getFrameMetadata(idx);
        if (meta == null) {
            return null;
        }
        int[] size = THREAD_LOCAL_SIZE_ARRAY.get();
        size[0] = meta.imageWidth;
        size[1] = meta.imageHeight;
        return size;
    }

    @Override
    protected synchronized boolean getFrameCompleteStatus(int idx) {
        return this.getFrameMetadata(idx) != null && this.framesDecoded;
    }

    private synchronized ImageFrame getImageFrame(int idx) {
        if (!this.fullDataReceived) {
            this.startLoader();
        } else if (this.fullDataReceived && !this.framesDecoded) {
            this.destroyLoader();
            this.setFrames(this.loadFrames());
            this.framesDecoded = true;
        }
        return idx >= 0 && this.frames != null && this.frames.length > idx ? this.frames[idx] : null;
    }

    private synchronized PrismImage getPrismImage(int idx, ImageFrame frame) {
        if (this.images == null) {
            this.images = new PrismImage[this.frames.length];
        }
        if (this.images[idx] == null) {
            this.images[idx] = new WCImageImpl(frame);
        }
        return this.images[idx];
    }

    private static final class Frame
    extends WCImageFrame {
        private WCImage image;

        private Frame(WCImage image) {
            this.image = image;
        }

        @Override
        public WCImage getFrame() {
            return this.image;
        }

        @Override
        public int[] getSize() {
            int[] size = (int[])THREAD_LOCAL_SIZE_ARRAY.get();
            size[0] = this.image.getWidth();
            size[1] = this.image.getHeight();
            return size;
        }

        @Override
        protected void destroyDecodedData() {
            this.image = null;
        }
    }
}

