/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;

public class Rectangle {
    public int x;
    public int y;
    public int width;
    public int height;

    public Rectangle() {
        this(0, 0, 0, 0);
    }

    public Rectangle(BaseBounds b) {
        this.setBounds(b);
    }

    public Rectangle(Rectangle r) {
        this(r.x, r.y, r.width, r.height);
    }

    public Rectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rectangle(int width, int height) {
        this(0, 0, width, height);
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.reshape(x, y, width, height);
    }

    public void setBounds(BaseBounds b) {
        this.x = (int)Math.floor(b.getMinX());
        this.y = (int)Math.floor(b.getMinY());
        int x2 = (int)Math.ceil(b.getMaxX());
        int y2 = (int)Math.ceil(b.getMaxY());
        this.width = x2 - this.x;
        this.height = y2 - this.y;
    }

    public boolean contains(int cx, int cy) {
        int tw = this.width;
        int th = this.height;
        if ((tw | th) < 0) {
            return false;
        }
        int tx = this.x;
        int ty = this.y;
        if (cx < tx || cy < ty) {
            return false;
        }
        th += ty;
        return !((tw += tx) >= tx && tw <= cx || th >= ty && th <= cy);
    }

    public boolean contains(Rectangle r) {
        return this.contains(r.x, r.y, r.width, r.height);
    }

    public boolean contains(int cx, int cy, int cw, int ch) {
        int tw = this.width;
        int th = this.height;
        if ((tw | th | cw | ch) < 0) {
            return false;
        }
        int tx = this.x;
        int ty = this.y;
        if (cx < tx || cy < ty) {
            return false;
        }
        tw += tx;
        if ((cw += cx) <= cx ? tw >= tx || cw > tw : tw >= tx && cw > tw) {
            return false;
        }
        th += ty;
        return !((ch += cy) <= cy ? th >= ty || ch > th : th >= ty && ch > th);
    }

    public Rectangle intersection(Rectangle r) {
        Rectangle ret = new Rectangle(this);
        ret.intersectWith(r);
        return ret;
    }

    public void intersectWith(Rectangle r) {
        if (r == null) {
            return;
        }
        int tx1 = this.x;
        int ty1 = this.y;
        int rx1 = r.x;
        int ry1 = r.y;
        long tx2 = tx1;
        tx2 += (long)this.width;
        long ty2 = ty1;
        ty2 += (long)this.height;
        long rx2 = rx1;
        rx2 += (long)r.width;
        long ry2 = ry1;
        ry2 += (long)r.height;
        if (tx1 < rx1) {
            tx1 = rx1;
        }
        if (ty1 < ry1) {
            ty1 = ry1;
        }
        if (tx2 > rx2) {
            tx2 = rx2;
        }
        if (ty2 > ry2) {
            ty2 = ry2;
        }
        ty2 -= (long)ty1;
        if ((tx2 -= (long)tx1) < Integer.MIN_VALUE) {
            tx2 = Integer.MIN_VALUE;
        }
        if (ty2 < Integer.MIN_VALUE) {
            ty2 = Integer.MIN_VALUE;
        }
        this.setBounds(tx1, ty1, (int)tx2, (int)ty2);
    }

    public void translate(int dx, int dy) {
        int oldv = this.x;
        int newv = oldv + dx;
        if (dx < 0) {
            if (newv > oldv) {
                if (this.width >= 0) {
                    this.width += newv - Integer.MIN_VALUE;
                }
                newv = Integer.MIN_VALUE;
            }
        } else if (newv < oldv) {
            if (this.width >= 0) {
                this.width += newv - Integer.MAX_VALUE;
                if (this.width < 0) {
                    this.width = Integer.MAX_VALUE;
                }
            }
            newv = Integer.MAX_VALUE;
        }
        this.x = newv;
        oldv = this.y;
        newv = oldv + dy;
        if (dy < 0) {
            if (newv > oldv) {
                if (this.height >= 0) {
                    this.height += newv - Integer.MIN_VALUE;
                }
                newv = Integer.MIN_VALUE;
            }
        } else if (newv < oldv) {
            if (this.height >= 0) {
                this.height += newv - Integer.MAX_VALUE;
                if (this.height < 0) {
                    this.height = Integer.MAX_VALUE;
                }
            }
            newv = Integer.MAX_VALUE;
        }
        this.y = newv;
    }

    public RectBounds toRectBounds() {
        return new RectBounds(this.x, this.y, this.x + this.width, this.y + this.height);
    }

    public void add(int newx, int newy) {
        if ((this.width | this.height) < 0) {
            this.x = newx;
            this.y = newy;
            this.height = 0;
            this.width = 0;
            return;
        }
        int x1 = this.x;
        int y1 = this.y;
        long x2 = this.width;
        long y2 = this.height;
        x2 += (long)x1;
        y2 += (long)y1;
        if (x1 > newx) {
            x1 = newx;
        }
        if (y1 > newy) {
            y1 = newy;
        }
        if (x2 < (long)newx) {
            x2 = newx;
        }
        if (y2 < (long)newy) {
            y2 = newy;
        }
        y2 -= (long)y1;
        if ((x2 -= (long)x1) > Integer.MAX_VALUE) {
            x2 = Integer.MAX_VALUE;
        }
        if (y2 > Integer.MAX_VALUE) {
            y2 = Integer.MAX_VALUE;
        }
        this.reshape(x1, y1, (int)x2, (int)y2);
    }

    public void add(Rectangle r) {
        long ry2;
        long rx2;
        long tx2 = this.width;
        long ty2 = this.height;
        if ((tx2 | ty2) < 0L) {
            this.reshape(r.x, r.y, r.width, r.height);
        }
        if (((rx2 = (long)r.width) | (ry2 = (long)r.height)) < 0L) {
            return;
        }
        int tx1 = this.x;
        int ty1 = this.y;
        tx2 += (long)tx1;
        ty2 += (long)ty1;
        int rx1 = r.x;
        int ry1 = r.y;
        rx2 += (long)rx1;
        ry2 += (long)ry1;
        if (tx1 > rx1) {
            tx1 = rx1;
        }
        if (ty1 > ry1) {
            ty1 = ry1;
        }
        if (tx2 < rx2) {
            tx2 = rx2;
        }
        if (ty2 < ry2) {
            ty2 = ry2;
        }
        ty2 -= (long)ty1;
        if ((tx2 -= (long)tx1) > Integer.MAX_VALUE) {
            tx2 = Integer.MAX_VALUE;
        }
        if (ty2 > Integer.MAX_VALUE) {
            ty2 = Integer.MAX_VALUE;
        }
        this.reshape(tx1, ty1, (int)tx2, (int)ty2);
    }

    public void grow(int h, int v) {
        long x0 = this.x;
        long y0 = this.y;
        long x1 = this.width;
        long y1 = this.height;
        x1 += x0;
        y1 += y0;
        y0 -= (long)v;
        y1 += (long)v;
        if ((x1 += (long)h) < (x0 -= (long)h)) {
            if ((x1 -= x0) < Integer.MIN_VALUE) {
                x1 = Integer.MIN_VALUE;
            }
            if (x0 < Integer.MIN_VALUE) {
                x0 = Integer.MIN_VALUE;
            } else if (x0 > Integer.MAX_VALUE) {
                x0 = Integer.MAX_VALUE;
            }
        } else {
            if (x0 < Integer.MIN_VALUE) {
                x0 = Integer.MIN_VALUE;
            } else if (x0 > Integer.MAX_VALUE) {
                x0 = Integer.MAX_VALUE;
            }
            if ((x1 -= x0) < Integer.MIN_VALUE) {
                x1 = Integer.MIN_VALUE;
            } else if (x1 > Integer.MAX_VALUE) {
                x1 = Integer.MAX_VALUE;
            }
        }
        if (y1 < y0) {
            if ((y1 -= y0) < Integer.MIN_VALUE) {
                y1 = Integer.MIN_VALUE;
            }
            if (y0 < Integer.MIN_VALUE) {
                y0 = Integer.MIN_VALUE;
            } else if (y0 > Integer.MAX_VALUE) {
                y0 = Integer.MAX_VALUE;
            }
        } else {
            if (y0 < Integer.MIN_VALUE) {
                y0 = Integer.MIN_VALUE;
            } else if (y0 > Integer.MAX_VALUE) {
                y0 = Integer.MAX_VALUE;
            }
            if ((y1 -= y0) < Integer.MIN_VALUE) {
                y1 = Integer.MIN_VALUE;
            } else if (y1 > Integer.MAX_VALUE) {
                y1 = Integer.MAX_VALUE;
            }
        }
        this.reshape((int)x0, (int)y0, (int)x1, (int)y1);
    }

    private void reshape(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Rectangle) {
            Rectangle r = (Rectangle)obj;
            return this.x == r.x && this.y == r.y && this.width == r.width && this.height == r.height;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int bits = Float.floatToIntBits(this.x);
        bits += Float.floatToIntBits(this.y) * 37;
        bits += Float.floatToIntBits(this.width) * 43;
        return bits += Float.floatToIntBits(this.height) * 47;
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
    }
}

