/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.CubicIterator;
import com.sun.javafx.geom.FlatteningPathIterator;
import com.sun.javafx.geom.Line2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.QuadCurve2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import java.util.Arrays;

public class CubicCurve2D
extends Shape {
    public float x1;
    public float y1;
    public float ctrlx1;
    public float ctrly1;
    public float ctrlx2;
    public float ctrly2;
    public float x2;
    public float y2;
    private static final int BELOW = -2;
    private static final int LOWEDGE = -1;
    private static final int INSIDE = 0;
    private static final int HIGHEDGE = 1;
    private static final int ABOVE = 2;

    public CubicCurve2D() {
    }

    public CubicCurve2D(float x1, float y1, float ctrlx1, float ctrly1, float ctrlx2, float ctrly2, float x2, float y2) {
        this.setCurve(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2);
    }

    public void setCurve(float x1, float y1, float ctrlx1, float ctrly1, float ctrlx2, float ctrly2, float x2, float y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.ctrlx1 = ctrlx1;
        this.ctrly1 = ctrly1;
        this.ctrlx2 = ctrlx2;
        this.ctrly2 = ctrly2;
        this.x2 = x2;
        this.y2 = y2;
    }

    @Override
    public RectBounds getBounds() {
        float left = Math.min(Math.min(this.x1, this.x2), Math.min(this.ctrlx1, this.ctrlx2));
        float top = Math.min(Math.min(this.y1, this.y2), Math.min(this.ctrly1, this.ctrly2));
        float right = Math.max(Math.max(this.x1, this.x2), Math.max(this.ctrlx1, this.ctrlx2));
        float bottom = Math.max(Math.max(this.y1, this.y2), Math.max(this.ctrly1, this.ctrly2));
        return new RectBounds(left, top, right, bottom);
    }

    public Point2D eval(float t) {
        Point2D result = new Point2D();
        this.eval(t, result);
        return result;
    }

    public void eval(float td, Point2D result) {
        result.setLocation(this.calcX(td), this.calcY(td));
    }

    public Point2D evalDt(float t) {
        Point2D result = new Point2D();
        this.evalDt(t, result);
        return result;
    }

    public void evalDt(float td, Point2D result) {
        float t = td;
        float u = 1.0f - t;
        float x = 3.0f * ((this.ctrlx1 - this.x1) * u * u + 2.0f * (this.ctrlx2 - this.ctrlx1) * u * t + (this.x2 - this.ctrlx2) * t * t);
        float y = 3.0f * ((this.ctrly1 - this.y1) * u * u + 2.0f * (this.ctrly2 - this.ctrly1) * u * t + (this.y2 - this.ctrly2) * t * t);
        result.setLocation(x, y);
    }

    public void setCurve(float[] coords, int offset) {
        this.setCurve(coords[offset + 0], coords[offset + 1], coords[offset + 2], coords[offset + 3], coords[offset + 4], coords[offset + 5], coords[offset + 6], coords[offset + 7]);
    }

    public void setCurve(Point2D p1, Point2D cp1, Point2D cp2, Point2D p2) {
        this.setCurve(p1.x, p1.y, cp1.x, cp1.y, cp2.x, cp2.y, p2.x, p2.y);
    }

    public void setCurve(Point2D[] pts, int offset) {
        this.setCurve(pts[offset + 0].x, pts[offset + 0].y, pts[offset + 1].x, pts[offset + 1].y, pts[offset + 2].x, pts[offset + 2].y, pts[offset + 3].x, pts[offset + 3].y);
    }

    public void setCurve(CubicCurve2D c) {
        this.setCurve(c.x1, c.y1, c.ctrlx1, c.ctrly1, c.ctrlx2, c.ctrly2, c.x2, c.y2);
    }

    public static float getFlatnessSq(float x1, float y1, float ctrlx1, float ctrly1, float ctrlx2, float ctrly2, float x2, float y2) {
        return Math.max(Line2D.ptSegDistSq(x1, y1, x2, y2, ctrlx1, ctrly1), Line2D.ptSegDistSq(x1, y1, x2, y2, ctrlx2, ctrly2));
    }

    public static float getFlatness(float x1, float y1, float ctrlx1, float ctrly1, float ctrlx2, float ctrly2, float x2, float y2) {
        return (float)Math.sqrt(CubicCurve2D.getFlatnessSq(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2));
    }

    public static float getFlatnessSq(float[] coords, int offset) {
        return CubicCurve2D.getFlatnessSq(coords[offset + 0], coords[offset + 1], coords[offset + 2], coords[offset + 3], coords[offset + 4], coords[offset + 5], coords[offset + 6], coords[offset + 7]);
    }

    public static float getFlatness(float[] coords, int offset) {
        return CubicCurve2D.getFlatness(coords[offset + 0], coords[offset + 1], coords[offset + 2], coords[offset + 3], coords[offset + 4], coords[offset + 5], coords[offset + 6], coords[offset + 7]);
    }

    public float getFlatnessSq() {
        return CubicCurve2D.getFlatnessSq(this.x1, this.y1, this.ctrlx1, this.ctrly1, this.ctrlx2, this.ctrly2, this.x2, this.y2);
    }

    public float getFlatness() {
        return CubicCurve2D.getFlatness(this.x1, this.y1, this.ctrlx1, this.ctrly1, this.ctrlx2, this.ctrly2, this.x2, this.y2);
    }

    public void subdivide(float t, CubicCurve2D left, CubicCurve2D right) {
        if (left == null && right == null) {
            return;
        }
        float npx = this.calcX(t);
        float npy = this.calcY(t);
        float x1 = this.x1;
        float y1 = this.y1;
        float c1x = this.ctrlx1;
        float c1y = this.ctrly1;
        float c2x = this.ctrlx2;
        float c2y = this.ctrly2;
        float x2 = this.x2;
        float y2 = this.y2;
        float u = 1.0f - t;
        float hx = u * c1x + t * c2x;
        float hy = u * c1y + t * c2y;
        if (left != null) {
            float lx1 = x1;
            float ly1 = y1;
            float lc1x = u * x1 + t * c1x;
            float lc1y = u * y1 + t * c1y;
            float lc2x = u * lc1x + t * hx;
            float lc2y = u * lc1y + t * hy;
            float lx2 = npx;
            float ly2 = npy;
            left.setCurve(lx1, ly1, lc1x, lc1y, lc2x, lc2y, lx2, ly2);
        }
        if (right != null) {
            float rx1 = npx;
            float ry1 = npy;
            float rc2x = u * c2x + t * x2;
            float rc2y = u * c2y + t * y2;
            float rc1x = u * hx + t * rc2x;
            float rc1y = u * hy + t * rc2y;
            float rx2 = x2;
            float ry2 = y2;
            right.setCurve(rx1, ry1, rc1x, rc1y, rc2x, rc2y, rx2, ry2);
        }
    }

    public void subdivide(CubicCurve2D left, CubicCurve2D right) {
        CubicCurve2D.subdivide(this, left, right);
    }

    public static void subdivide(CubicCurve2D src, CubicCurve2D left, CubicCurve2D right) {
        float x1 = src.x1;
        float y1 = src.y1;
        float ctrlx1 = src.ctrlx1;
        float ctrly1 = src.ctrly1;
        float ctrlx2 = src.ctrlx2;
        float ctrly2 = src.ctrly2;
        float x2 = src.x2;
        float y2 = src.y2;
        float centerx = (ctrlx1 + ctrlx2) / 2.0f;
        float centery = (ctrly1 + ctrly2) / 2.0f;
        ctrlx1 = (x1 + ctrlx1) / 2.0f;
        ctrly1 = (y1 + ctrly1) / 2.0f;
        ctrlx2 = (x2 + ctrlx2) / 2.0f;
        ctrly2 = (y2 + ctrly2) / 2.0f;
        float ctrlx12 = (ctrlx1 + centerx) / 2.0f;
        float ctrly12 = (ctrly1 + centery) / 2.0f;
        float ctrlx21 = (ctrlx2 + centerx) / 2.0f;
        float ctrly21 = (ctrly2 + centery) / 2.0f;
        centerx = (ctrlx12 + ctrlx21) / 2.0f;
        centery = (ctrly12 + ctrly21) / 2.0f;
        if (left != null) {
            left.setCurve(x1, y1, ctrlx1, ctrly1, ctrlx12, ctrly12, centerx, centery);
        }
        if (right != null) {
            right.setCurve(centerx, centery, ctrlx21, ctrly21, ctrlx2, ctrly2, x2, y2);
        }
    }

    public static void subdivide(float[] src, int srcoff, float[] left, int leftoff, float[] right, int rightoff) {
        float x1 = src[srcoff + 0];
        float y1 = src[srcoff + 1];
        float ctrlx1 = src[srcoff + 2];
        float ctrly1 = src[srcoff + 3];
        float ctrlx2 = src[srcoff + 4];
        float ctrly2 = src[srcoff + 5];
        float x2 = src[srcoff + 6];
        float y2 = src[srcoff + 7];
        if (left != null) {
            left[leftoff + 0] = x1;
            left[leftoff + 1] = y1;
        }
        if (right != null) {
            right[rightoff + 6] = x2;
            right[rightoff + 7] = y2;
        }
        x1 = (x1 + ctrlx1) / 2.0f;
        y1 = (y1 + ctrly1) / 2.0f;
        x2 = (x2 + ctrlx2) / 2.0f;
        y2 = (y2 + ctrly2) / 2.0f;
        float centerx = (ctrlx1 + ctrlx2) / 2.0f;
        float centery = (ctrly1 + ctrly2) / 2.0f;
        ctrlx1 = (x1 + centerx) / 2.0f;
        ctrly1 = (y1 + centery) / 2.0f;
        ctrlx2 = (x2 + centerx) / 2.0f;
        ctrly2 = (y2 + centery) / 2.0f;
        centerx = (ctrlx1 + ctrlx2) / 2.0f;
        centery = (ctrly1 + ctrly2) / 2.0f;
        if (left != null) {
            left[leftoff + 2] = x1;
            left[leftoff + 3] = y1;
            left[leftoff + 4] = ctrlx1;
            left[leftoff + 5] = ctrly1;
            left[leftoff + 6] = centerx;
            left[leftoff + 7] = centery;
        }
        if (right != null) {
            right[rightoff + 0] = centerx;
            right[rightoff + 1] = centery;
            right[rightoff + 2] = ctrlx2;
            right[rightoff + 3] = ctrly2;
            right[rightoff + 4] = x2;
            right[rightoff + 5] = y2;
        }
    }

    public static int solveCubic(float[] eqn) {
        return CubicCurve2D.solveCubic(eqn, eqn);
    }

    public static int solveCubic(float[] eqn, float[] res) {
        float d = eqn[3];
        if (d == 0.0f) {
            return QuadCurve2D.solveQuadratic(eqn, res);
        }
        float a = eqn[2] / d;
        float b = eqn[1] / d;
        float c = eqn[0] / d;
        int roots = 0;
        float Q = (a * a - 3.0f * b) / 9.0f;
        float R = (2.0f * a * a * a - 9.0f * a * b + 27.0f * c) / 54.0f;
        float R2 = R * R;
        float Q3 = Q * Q * Q;
        a /= 3.0f;
        if (R2 < Q3) {
            float theta = (float)Math.acos((double)R / Math.sqrt(Q3));
            Q = (float)(-2.0 * Math.sqrt(Q));
            if (res == eqn) {
                eqn = new float[4];
                System.arraycopy(res, 0, eqn, 0, 4);
            }
            res[roots++] = (float)((double)Q * Math.cos(theta / 3.0f) - (double)a);
            res[roots++] = (float)((double)Q * Math.cos(((double)theta + Math.PI * 2) / 3.0) - (double)a);
            res[roots++] = (float)((double)Q * Math.cos(((double)theta - Math.PI * 2) / 3.0) - (double)a);
            CubicCurve2D.fixRoots(res, eqn);
        } else {
            boolean neg = R < 0.0f;
            float S = (float)Math.sqrt(R2 - Q3);
            if (neg) {
                R = -R;
            }
            float A = (float)Math.pow(R + S, 0.3333333432674408);
            if (!neg) {
                A = -A;
            }
            float B = A == 0.0f ? 0.0f : Q / A;
            res[roots++] = A + B - a;
        }
        return roots;
    }

    private static void fixRoots(float[] res, float[] eqn) {
        float EPSILON = 1.0E-5f;
        for (int i = 0; i < 3; ++i) {
            float t = res[i];
            if (Math.abs(t) < 1.0E-5f) {
                res[i] = CubicCurve2D.findZero(t, 0.0f, eqn);
                continue;
            }
            if (!(Math.abs(t - 1.0f) < 1.0E-5f)) continue;
            res[i] = CubicCurve2D.findZero(t, 1.0f, eqn);
        }
    }

    private static float solveEqn(float[] eqn, int order, float t) {
        float v = eqn[order];
        while (--order >= 0) {
            v = v * t + eqn[order];
        }
        return v;
    }

    private static float findZero(float t, float target, float[] eqn) {
        float[] slopeqn = new float[]{eqn[1], 2.0f * eqn[2], 3.0f * eqn[3]};
        float origdelta = 0.0f;
        float origt = t;
        float slope;
        while ((slope = CubicCurve2D.solveEqn(slopeqn, 2, t)) != 0.0f) {
            float newt;
            float y = CubicCurve2D.solveEqn(eqn, 3, t);
            if (y == 0.0f) {
                return t;
            }
            float delta = -(y / slope);
            if (origdelta == 0.0f) {
                origdelta = delta;
            }
            if (t < target) {
                if (delta < 0.0f) {
                    return t;
                }
            } else if (t > target) {
                if (delta > 0.0f) {
                    return t;
                }
            } else {
                return delta > 0.0f ? target + Float.MIN_VALUE : target - Float.MIN_VALUE;
            }
            if (t == (newt = t + delta)) {
                return t;
            }
            if (delta * origdelta < 0.0f) {
                int tag;
                int n = tag = origt < t ? CubicCurve2D.getTag(target, origt, t) : CubicCurve2D.getTag(target, t, origt);
                if (tag != 0) {
                    return (origt + t) / 2.0f;
                }
                t = target;
                continue;
            }
            t = newt;
        }
        return t;
    }

    @Override
    public boolean contains(float x, float y) {
        if (x * 0.0f + y * 0.0f != 0.0f) {
            return false;
        }
        int crossings = Shape.pointCrossingsForLine(x, y, this.x1, this.y1, this.x2, this.y2) + Shape.pointCrossingsForCubic(x, y, this.x1, this.y1, this.ctrlx1, this.ctrly1, this.ctrlx2, this.ctrly2, this.x2, this.y2, 0);
        return (crossings & 1) == 1;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.x, p.y);
    }

    private static void fillEqn(float[] eqn, float val, float c1, float cp1, float cp2, float c2) {
        eqn[0] = c1 - val;
        eqn[1] = (cp1 - c1) * 3.0f;
        eqn[2] = (cp2 - cp1 - cp1 + c1) * 3.0f;
        eqn[3] = c2 + (cp1 - cp2) * 3.0f - c1;
    }

    private static int evalCubic(float[] vals, int num, boolean include0, boolean include1, float[] inflect, float c1, float cp1, float cp2, float c2) {
        int j = 0;
        for (int i = 0; i < num; ++i) {
            float t = vals[i];
            if (!(include0 ? t >= 0.0f : t > 0.0f) || !(include1 ? t <= 1.0f : t < 1.0f) || inflect != null && inflect[1] + (2.0f * inflect[2] + 3.0f * inflect[3] * t) * t == 0.0f) continue;
            float u = 1.0f - t;
            vals[j++] = c1 * u * u * u + 3.0f * cp1 * t * u * u + 3.0f * cp2 * t * t * u + c2 * t * t * t;
        }
        return j;
    }

    private static int getTag(float coord, float low, float high) {
        if (coord <= low) {
            return coord < low ? -2 : -1;
        }
        if (coord >= high) {
            return coord > high ? 2 : 1;
        }
        return 0;
    }

    private static boolean inwards(int pttag, int opt1tag, int opt2tag) {
        switch (pttag) {
            default: {
                return false;
            }
            case -1: {
                return opt1tag >= 0 || opt2tag >= 0;
            }
            case 0: {
                return true;
            }
            case 1: 
        }
        return opt1tag <= 0 || opt2tag <= 0;
    }

    @Override
    public boolean intersects(float x, float y, float w, float h) {
        int c2tag;
        boolean yoverlap;
        if (w <= 0.0f || h <= 0.0f) {
            return false;
        }
        float x1 = this.x1;
        float y1 = this.y1;
        int x1tag = CubicCurve2D.getTag(x1, x, x + w);
        int y1tag = CubicCurve2D.getTag(y1, y, y + h);
        if (x1tag == 0 && y1tag == 0) {
            return true;
        }
        float x2 = this.x2;
        float y2 = this.y2;
        int x2tag = CubicCurve2D.getTag(x2, x, x + w);
        int y2tag = CubicCurve2D.getTag(y2, y, y + h);
        if (x2tag == 0 && y2tag == 0) {
            return true;
        }
        float ctrlx1 = this.ctrlx1;
        float ctrly1 = this.ctrly1;
        float ctrlx2 = this.ctrlx2;
        float ctrly2 = this.ctrly2;
        int ctrlx1tag = CubicCurve2D.getTag(ctrlx1, x, x + w);
        int ctrly1tag = CubicCurve2D.getTag(ctrly1, y, y + h);
        int ctrlx2tag = CubicCurve2D.getTag(ctrlx2, x, x + w);
        int ctrly2tag = CubicCurve2D.getTag(ctrly2, y, y + h);
        if (x1tag < 0 && x2tag < 0 && ctrlx1tag < 0 && ctrlx2tag < 0) {
            return false;
        }
        if (y1tag < 0 && y2tag < 0 && ctrly1tag < 0 && ctrly2tag < 0) {
            return false;
        }
        if (x1tag > 0 && x2tag > 0 && ctrlx1tag > 0 && ctrlx2tag > 0) {
            return false;
        }
        if (y1tag > 0 && y2tag > 0 && ctrly1tag > 0 && ctrly2tag > 0) {
            return false;
        }
        if (CubicCurve2D.inwards(x1tag, x2tag, ctrlx1tag) && CubicCurve2D.inwards(y1tag, y2tag, ctrly1tag)) {
            return true;
        }
        if (CubicCurve2D.inwards(x2tag, x1tag, ctrlx2tag) && CubicCurve2D.inwards(y2tag, y1tag, ctrly2tag)) {
            return true;
        }
        boolean xoverlap = x1tag * x2tag <= 0;
        boolean bl = yoverlap = y1tag * y2tag <= 0;
        if (x1tag == 0 && x2tag == 0 && yoverlap) {
            return true;
        }
        if (y1tag == 0 && y2tag == 0 && xoverlap) {
            return true;
        }
        float[] eqn = new float[4];
        float[] res = new float[4];
        if (!yoverlap) {
            CubicCurve2D.fillEqn(eqn, y1tag < 0 ? y : y + h, y1, ctrly1, ctrly2, y2);
            int num = CubicCurve2D.solveCubic(eqn, res);
            num = CubicCurve2D.evalCubic(res, num, true, true, null, x1, ctrlx1, ctrlx2, x2);
            return num == 2 && CubicCurve2D.getTag(res[0], x, x + w) * CubicCurve2D.getTag(res[1], x, x + w) <= 0;
        }
        if (!xoverlap) {
            CubicCurve2D.fillEqn(eqn, x1tag < 0 ? x : x + w, x1, ctrlx1, ctrlx2, x2);
            int num = CubicCurve2D.solveCubic(eqn, res);
            num = CubicCurve2D.evalCubic(res, num, true, true, null, y1, ctrly1, ctrly2, y2);
            return num == 2 && CubicCurve2D.getTag(res[0], y, y + h) * CubicCurve2D.getTag(res[1], y, y + h) <= 0;
        }
        float dx = x2 - x1;
        float dy = y2 - y1;
        float k = y2 * x1 - x2 * y1;
        int c1tag = y1tag == 0 ? x1tag : CubicCurve2D.getTag((k + dx * (y1tag < 0 ? y : y + h)) / dy, x, x + w);
        if (c1tag * (c2tag = y2tag == 0 ? x2tag : CubicCurve2D.getTag((k + dx * (y2tag < 0 ? y : y + h)) / dy, x, x + w)) <= 0) {
            return true;
        }
        c1tag = c1tag * x1tag <= 0 ? y1tag : y2tag;
        CubicCurve2D.fillEqn(eqn, c2tag < 0 ? x : x + w, x1, ctrlx1, ctrlx2, x2);
        int num = CubicCurve2D.solveCubic(eqn, res);
        num = CubicCurve2D.evalCubic(res, num, true, true, null, y1, ctrly1, ctrly2, y2);
        int[] tags = new int[num + 1];
        for (int i = 0; i < num; ++i) {
            tags[i] = CubicCurve2D.getTag(res[i], y, y + h);
        }
        tags[num] = c1tag;
        Arrays.sort(tags);
        return num >= 1 && tags[0] * tags[1] <= 0 || num >= 3 && tags[2] * tags[3] <= 0;
    }

    @Override
    public boolean contains(float x, float y, float w, float h) {
        if (w <= 0.0f || h <= 0.0f) {
            return false;
        }
        if (!(this.contains(x, y) && this.contains(x + w, y) && this.contains(x + w, y + h) && this.contains(x, y + h))) {
            return false;
        }
        return !Shape.intersectsLine(x, y, w, h, this.x1, this.y1, this.x2, this.y2);
    }

    @Override
    public PathIterator getPathIterator(BaseTransform tx) {
        return new CubicIterator(this, tx);
    }

    @Override
    public PathIterator getPathIterator(BaseTransform tx, float flatness) {
        return new FlatteningPathIterator(this.getPathIterator(tx), flatness);
    }

    @Override
    public CubicCurve2D copy() {
        return new CubicCurve2D(this.x1, this.y1, this.ctrlx1, this.ctrly1, this.ctrlx2, this.ctrly2, this.x2, this.y2);
    }

    public int hashCode() {
        int bits = Float.floatToIntBits(this.x1);
        bits += Float.floatToIntBits(this.y1) * 37;
        bits += Float.floatToIntBits(this.x2) * 43;
        bits += Float.floatToIntBits(this.y2) * 47;
        bits += Float.floatToIntBits(this.ctrlx1) * 53;
        bits += Float.floatToIntBits(this.ctrly1) * 59;
        bits += Float.floatToIntBits(this.ctrlx2) * 61;
        return bits += Float.floatToIntBits(this.ctrly2) * 101;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CubicCurve2D) {
            CubicCurve2D curve = (CubicCurve2D)obj;
            return this.x1 == curve.x1 && this.y1 == curve.y1 && this.x2 == curve.x2 && this.y2 == curve.y2 && this.ctrlx1 == curve.ctrlx1 && this.ctrly1 == curve.ctrly1 && this.ctrlx2 == curve.ctrlx2 && this.ctrly2 == curve.ctrly2;
        }
        return false;
    }

    private float calcX(float t) {
        float u = 1.0f - t;
        return u * u * u * this.x1 + 3.0f * (t * u * u * this.ctrlx1 + t * t * u * this.ctrlx2) + t * t * t * this.x2;
    }

    private float calcY(float t) {
        float u = 1.0f - t;
        return u * u * u * this.y1 + 3.0f * (t * u * u * this.ctrly1 + t * t * u * this.ctrly2) + t * t * t * this.y2;
    }
}

