/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.property;

import com.sun.javafx.binding.ExpressionHelper;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;

public abstract class IntegerPropertyBase
extends IntegerProperty {
    private int value;
    private ObservableNumberValue observable = null;
    private InvalidationListener listener = null;
    private boolean valid = true;
    private ExpressionHelper<Number> helper = null;

    public IntegerPropertyBase() {
    }

    public IntegerPropertyBase(int n) {
        this.value = n;
    }

    @Override
    public void addListener(InvalidationListener invalidationListener) {
        this.helper = ExpressionHelper.addListener(this.helper, this, invalidationListener);
    }

    @Override
    public void removeListener(InvalidationListener invalidationListener) {
        this.helper = ExpressionHelper.removeListener(this.helper, invalidationListener);
    }

    @Override
    public void addListener(ChangeListener<? super Number> changeListener) {
        this.helper = ExpressionHelper.addListener(this.helper, this, changeListener);
    }

    @Override
    public void removeListener(ChangeListener<? super Number> changeListener) {
        this.helper = ExpressionHelper.removeListener(this.helper, changeListener);
    }

    protected void fireValueChangedEvent() {
        ExpressionHelper.fireValueChangedEvent(this.helper);
    }

    private void markInvalid() {
        if (this.valid) {
            this.valid = false;
            this.invalidated();
            this.fireValueChangedEvent();
        }
    }

    protected void invalidated() {
    }

    @Override
    public int get() {
        this.valid = true;
        return this.observable == null ? this.value : this.observable.intValue();
    }

    @Override
    public void set(int n) {
        if (this.isBound()) {
            throw new RuntimeException("A bound value cannot be set.");
        }
        if (this.value != n) {
            this.value = n;
            this.markInvalid();
        }
    }

    @Override
    public boolean isBound() {
        return this.observable != null;
    }

    @Override
    public void bind(final ObservableValue<? extends Number> observableValue) {
        ObservableNumberValue observableNumberValue;
        if (observableValue == null) {
            throw new NullPointerException("Cannot bind to null");
        }
        ObservableNumberValue observableNumberValue2 = observableNumberValue = observableValue instanceof ObservableNumberValue ? (ObservableNumberValue)observableValue : new IntegerBinding(){
            {
                super.bind(observableValue);
            }

            @Override
            protected int computeValue() {
                return ((Number)observableValue.getValue()).intValue();
            }
        };
        if (!observableNumberValue.equals(this.observable)) {
            this.unbind();
            this.observable = observableNumberValue;
            if (this.listener == null) {
                this.listener = new Listener();
            }
            this.observable.addListener(this.listener);
            this.markInvalid();
        }
    }

    @Override
    public void unbind() {
        if (this.observable != null) {
            this.value = this.observable.intValue();
            this.observable.removeListener(this.listener);
            this.observable = null;
        }
    }

    @Override
    public String toString() {
        Object object = this.getBean();
        String string = this.getName();
        StringBuilder stringBuilder = new StringBuilder("IntegerProperty [");
        if (object != null) {
            stringBuilder.append("bean: ").append(object).append(", ");
        }
        if (string != null && !string.equals("")) {
            stringBuilder.append("name: ").append(string).append(", ");
        }
        if (this.isBound()) {
            stringBuilder.append("bound, ");
            if (this.valid) {
                stringBuilder.append("value: ").append(this.get());
            } else {
                stringBuilder.append("invalid");
            }
        } else {
            stringBuilder.append("value: ").append(this.get());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private class Listener
    implements InvalidationListener {
        private Listener() {
        }

        @Override
        public void invalidated(Observable observable) {
            IntegerPropertyBase.this.markInvalid();
        }
    }
}

