/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.bmp;

import com.sun.javafx.iio.bmp.LEInputStream;
import java.io.IOException;

final class BitmapInfoHeader {
    static final int BIH_SIZE = 40;
    static final int BIH4_SIZE = 108;
    static final int BIH5_SIZE = 124;
    final int biSize;
    final int biWidth;
    final int biHeight;
    final short biPlanes;
    final short biBitCount;
    final int biCompression;
    final int biSizeImage;
    final int biXPelsPerMeter;
    final int biYPelsPerMeter;
    final int biClrUsed;
    final int biClrImportant;

    BitmapInfoHeader(LEInputStream lEInputStream) throws IOException {
        this.biSize = lEInputStream.readInt();
        this.biWidth = lEInputStream.readInt();
        this.biHeight = lEInputStream.readInt();
        this.biPlanes = lEInputStream.readShort();
        this.biBitCount = lEInputStream.readShort();
        this.biCompression = lEInputStream.readInt();
        this.biSizeImage = lEInputStream.readInt();
        this.biXPelsPerMeter = lEInputStream.readInt();
        this.biYPelsPerMeter = lEInputStream.readInt();
        this.biClrUsed = lEInputStream.readInt();
        this.biClrImportant = lEInputStream.readInt();
        if (this.biSize > 40) {
            if (this.biSize == 108 || this.biSize == 124) {
                lEInputStream.skipBytes(this.biSize - 40);
            } else {
                throw new IOException("BitmapInfoHeader is corrupt");
            }
        }
        this.validate();
    }

    void validate() {
        if (this.biCompression != 0 || this.biPlanes != 1 || this.biBitCount != 24) {
            throw new RuntimeException("Unsupported BMP image: only 24 bit uncompressed BMP`s is supported");
        }
    }
}

