/*
 * Decompiled with CFR 0.152.
 */
package hughai.ui;

import hughai.CSAI;
import hughai.PlayerObjects;
import hughai.utils.Config;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class MainUI {
    ButtonActionHandler buttonActionHandler = new ButtonActionHandler();
    PlayerObjects playerObjects;
    JFrame frame;
    JTabbedPane tabbedPane;
    JPanel actionsPanel;
    GridLayout actionsGridLayout;
    HashMap<JButton, ButtonHandler> buttonhandlerbybutton = new HashMap();

    public MainUI(PlayerObjects playerObjects) {
        this.playerObjects = playerObjects;
        this.Init();
    }

    public void Init() {
        this.frame = new JFrame("HughAI " + this.playerObjects.getAicallback().getSkirmishAI().getTeamId());
        this.frame.setSize(200, 500);
        this.frame.setVisible(true);
        this.tabbedPane = new JTabbedPane();
        this.frame.add(this.tabbedPane);
        this.actionsGridLayout = new GridLayout(0, 1);
        this.actionsPanel = new JPanel(this.actionsGridLayout);
        this.tabbedPane.addTab("Actions", this.actionsPanel);
        this.frame.setVisible(this.playerObjects.getConfig().isGUIActivated());
        this.playerObjects.getCSAI().registerShutdown(new ShutdownHandler());
        this.playerObjects.getConfig().registerListener(new ConfigHandler());
    }

    public void addPanelToTabbedPanel(String string, JPanel jPanel) {
        this.playerObjects.getLogFile().WriteLine("MainUI: addpaneltotabbedpanel " + string);
        this.tabbedPane.addTab(string, jPanel);
        this.frame.validate();
    }

    protected void finalize() {
        System.out.println(this.getClass().getSimpleName() + ".finalize()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerButton(String string, ButtonHandler buttonHandler) {
        this.playerObjects.getLogFile().WriteLine("MainUI.registerbutton " + string);
        JButton jButton = new JButton(string);
        jButton.addActionListener(this.buttonActionHandler);
        HashMap<JButton, ButtonHandler> hashMap = this.buttonhandlerbybutton;
        synchronized (hashMap) {
            this.buttonhandlerbybutton.put(jButton, buttonHandler);
        }
        this.actionsGridLayout.setRows(this.actionsGridLayout.getRows() + 1);
        this.actionsPanel.add(jButton);
        this.frame.setSize(400, 450);
        this.actionsPanel.validate();
        this.frame.validate();
    }

    public void showInfo(String string) {
        JOptionPane.showMessageDialog(this.frame, string);
    }

    class ButtonActionHandler
    implements ActionListener {
        ButtonActionHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (JButton.class.isAssignableFrom(actionEvent.getSource().getClass())) {
                JButton jButton = (JButton)actionEvent.getSource();
                ButtonHandler buttonHandler = null;
                HashMap<JButton, ButtonHandler> hashMap = MainUI.this.buttonhandlerbybutton;
                synchronized (hashMap) {
                    buttonHandler = MainUI.this.buttonhandlerbybutton.get(jButton);
                }
                if (buttonHandler != null) {
                    buttonHandler.go();
                }
            }
        }
    }

    class ShutdownHandler
    implements CSAI.ShutdownHandler {
        ShutdownHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() {
            MainUI.this.playerObjects.getLogFile().WriteLine("MainUI.shutdown()");
            HashMap<JButton, ButtonHandler> hashMap = MainUI.this.buttonhandlerbybutton;
            synchronized (hashMap) {
                for (JButton jButton : MainUI.this.buttonhandlerbybutton.keySet()) {
                    jButton.removeActionListener(MainUI.this.buttonActionHandler);
                }
                MainUI.this.buttonhandlerbybutton.clear();
            }
            MainUI.this.actionsPanel = null;
            MainUI.this.actionsGridLayout = null;
            MainUI.this.buttonActionHandler = null;
            MainUI.this.buttonhandlerbybutton = null;
            MainUI.this.frame.dispose();
            MainUI.this.frame = null;
            MainUI.this.playerObjects = null;
        }
    }

    class ConfigHandler
    implements Config.ConfigListener {
        ConfigHandler() {
        }

        @Override
        public void configUpdated() {
            MainUI.this.playerObjects.getLogFile().WriteLine("MainUI.ConfigHandler()");
            MainUI.this.frame.setVisible(MainUI.this.playerObjects.getConfig().isGUIActivated());
        }
    }

    public static interface ButtonHandler {
        public void go();
    }
}

