/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.WaitForProgressToShow;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.dialogs.RelocateDialog;
import org.jetbrains.idea.svn.info.Info;

public class RelocateAction
extends BasicAction {
    private static final Logger LOG = Logger.getInstance(RelocateAction.class);

    @Override
    @NotNull
    protected String getActionName() {
        if ("Relocate working copy to a different URL" == null) {
            RelocateAction.$$$reportNull$$$0(0);
        }
        return "Relocate working copy to a different URL";
    }

    @Override
    protected boolean isEnabled(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        if (vcs == null) {
            RelocateAction.$$$reportNull$$$0(1);
        }
        if (file == null) {
            RelocateAction.$$$reportNull$$$0(2);
        }
        return SvnStatusUtil.isUnderControl(vcs, file);
    }

    @Override
    protected void perform(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull DataContext context) {
        String afterURL;
        Info info;
        if (vcs == null) {
            RelocateAction.$$$reportNull$$$0(3);
        }
        if (file == null) {
            RelocateAction.$$$reportNull$$$0(4);
        }
        if (context == null) {
            RelocateAction.$$$reportNull$$$0(5);
        }
        if ((info = vcs.getInfo(file)) == null) {
            LOG.info("Could not get info for " + file);
            return;
        }
        RelocateDialog dlg = new RelocateDialog(vcs.getProject(), info.getURL());
        if (!dlg.showAndGet()) {
            return;
        }
        String beforeURL = dlg.getBeforeURL();
        if (beforeURL.equals(afterURL = dlg.getAfterURL())) {
            return;
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.setIndeterminate(true);
            }
            try {
                File path = VfsUtilCore.virtualToIoFile((VirtualFile)file);
                vcs.getFactory(path).createRelocateClient().relocate(path, SvnUtil.createUrl(beforeURL, false), SvnUtil.createUrl(afterURL, false));
                VcsDirtyScopeManager.getInstance((Project)vcs.getProject()).markEverythingDirty();
            }
            catch (VcsException e) {
                WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((Project)vcs.getProject(), (String)("Error relocating working copy: " + e.getMessage()), (String)"Relocate Working Copy"), null, (Project)vcs.getProject());
            }
        }, "Relocating Working Copy", false, vcs.getProject());
    }

    @Override
    protected void batchPerform(@NotNull SvnVcs vcs, @NotNull VirtualFile[] files, @NotNull DataContext context) {
        if (vcs == null) {
            RelocateAction.$$$reportNull$$$0(6);
        }
        if (files == null) {
            RelocateAction.$$$reportNull$$$0(7);
        }
        if (context == null) {
            RelocateAction.$$$reportNull$$$0(8);
        }
    }

    @Override
    protected boolean isBatchAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/actions/RelocateAction";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/actions/RelocateAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "batchPerform";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

