/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Point;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface InlayModel {
    @Nullable
    default public <T extends EditorCustomElementRenderer> Inlay<T> addInlineElement(int offset, @NotNull T renderer) {
        if (renderer == null) {
            InlayModel.$$$reportNull$$$0(0);
        }
        return this.addInlineElement(offset, false, renderer);
    }

    @Nullable
    public <T extends EditorCustomElementRenderer> Inlay<T> addInlineElement(int var1, boolean var2, @NotNull T var3);

    @Nullable
    public <T extends EditorCustomElementRenderer> Inlay<T> addBlockElement(int var1, boolean var2, boolean var3, int var4, @NotNull T var5);

    @NotNull
    public List<Inlay> getInlineElementsInRange(int var1, int var2);

    default public <T> List<Inlay<? extends T>> getInlineElementsInRange(int startOffset, int endOffset, Class<T> type) {
        return ContainerUtil.filter(this.getInlineElementsInRange(startOffset, endOffset), inlay -> type.isInstance(inlay.getRenderer()));
    }

    @NotNull
    public List<Inlay> getBlockElementsInRange(int var1, int var2);

    default public <T> List<Inlay<? extends T>> getBlockElementsInRange(int startOffset, int endOffset, Class<T> type) {
        return ContainerUtil.filter(this.getBlockElementsInRange(startOffset, endOffset), inlay -> type.isInstance(inlay.getRenderer()));
    }

    @NotNull
    public List<Inlay> getBlockElementsForVisualLine(int var1, boolean var2);

    default public boolean hasBlockElements() {
        return !this.getBlockElementsInRange(0, Integer.MAX_VALUE).isEmpty();
    }

    default public boolean hasInlineElementsInRange(int startOffset, int endOffset) {
        return !this.getInlineElementsInRange(startOffset, endOffset).isEmpty();
    }

    default public boolean hasInlineElements() {
        return this.hasInlineElementsInRange(0, Integer.MAX_VALUE);
    }

    public boolean hasInlineElementAt(int var1);

    default public boolean hasInlineElementAt(@NotNull VisualPosition visualPosition) {
        if (visualPosition == null) {
            InlayModel.$$$reportNull$$$0(1);
        }
        return this.getInlineElementAt(visualPosition) != null;
    }

    @Nullable
    public Inlay getInlineElementAt(@NotNull VisualPosition var1);

    @Nullable
    public Inlay getElementAt(@NotNull Point var1);

    public void addListener(@NotNull Listener var1, @NotNull Disposable var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visualPosition";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/InlayModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addInlineElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasInlineElementAt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class SimpleAdapter
    implements Listener {
        @Override
        public void onAdded(@NotNull Inlay inlay) {
            if (inlay == null) {
                SimpleAdapter.$$$reportNull$$$0(0);
            }
            this.onUpdated(inlay);
        }

        @Override
        public void onUpdated(@NotNull Inlay inlay) {
            if (inlay == null) {
                SimpleAdapter.$$$reportNull$$$0(1);
            }
        }

        @Override
        public void onRemoved(@NotNull Inlay inlay) {
            if (inlay == null) {
                SimpleAdapter.$$$reportNull$$$0(2);
            }
            this.onUpdated(inlay);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "inlay";
            objectArray2[1] = "com/intellij/openapi/editor/InlayModel$SimpleAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onUpdated";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface Listener
    extends EventListener {
        public void onAdded(@NotNull Inlay var1);

        public void onUpdated(@NotNull Inlay var1);

        public void onRemoved(@NotNull Inlay var1);
    }
}

