/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.ide.util.TipUIUtil;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class TipPanel
extends JPanel
implements DialogWrapper.DoNotAskOption {
    private static final JBColor DIVIDER_COLOR = new JBColor(0xD9D9D9, 0x515151);
    private static final int DEFAULT_WIDTH = 400;
    private static final int DEFAULT_HEIGHT = 200;
    private final TipUIUtil.Browser myBrowser;
    private final JLabel myPoweredByLabel;
    private List<TipAndTrickBean> myTips = Collections.emptyList();

    public TipPanel() {
        this.setLayout(new BorderLayout());
        if (SystemInfo.isWin10OrNewer && !UIUtil.isUnderDarcula()) {
            this.setBorder(JBUI.Borders.customLine((Color)Gray.xD0, (int)1, (int)0, (int)0, (int)0));
        }
        this.myBrowser = TipUIUtil.createBrowser();
        this.myBrowser.getComponent().setBorder((Border)JBUI.Borders.empty((int)8, (int)12));
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myBrowser.getComponent(), (boolean)true);
        scrollPane.setBorder(JBUI.Borders.customLine((Color)DIVIDER_COLOR, (int)0, (int)0, (int)1, (int)0));
        this.add((Component)scrollPane, "Center");
        this.myPoweredByLabel = new JBLabel();
        this.myPoweredByLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
        this.myPoweredByLabel.setForeground(SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES.getFgColor());
        this.add((Component)this.myPoweredByLabel, "South");
    }

    public void setTips(@NotNull List<TipAndTrickBean> list2) {
        if (list2 == null) {
            TipPanel.$$$reportNull$$$0(0);
        }
        this.myTips = list2;
    }

    @Override
    public Dimension getPreferredSize() {
        return new JBDimension(400, 200);
    }

    public void prevTip() {
        TipAndTrickBean tip;
        if (this.myTips.size() == 0) {
            this.myBrowser.setText(IdeBundle.message((String)"error.tips.not.found", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}));
            return;
        }
        GeneralSettings settings = GeneralSettings.getInstance();
        int lastTip = settings.getLastTip();
        if (--lastTip <= 0) {
            tip = this.myTips.get(this.myTips.size() - 1);
            lastTip = this.myTips.size();
        } else {
            tip = this.myTips.get(lastTip - 1);
        }
        this.setTip(tip, lastTip, this.myBrowser, settings);
    }

    private void setTip(TipAndTrickBean tip, int lastTip, TipUIUtil.Browser browser2, GeneralSettings settings) {
        TipUIUtil.openTipInBrowser(tip, browser2);
        this.myPoweredByLabel.setText(TipUIUtil.getPoweredByText(tip));
        this.myPoweredByLabel.setVisible(!StringUtil.isEmpty((String)this.myPoweredByLabel.getText()));
        settings.setLastTip(lastTip);
    }

    public void nextTip() {
        TipAndTrickBean tip;
        if (this.myTips.size() == 0) {
            this.myBrowser.setText(IdeBundle.message((String)"error.tips.not.found", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}));
            return;
        }
        GeneralSettings settings = GeneralSettings.getInstance();
        int lastTip = settings.getLastTip();
        if (++lastTip - 1 >= this.myTips.size()) {
            tip = this.myTips.get(0);
            lastTip = 1;
        } else {
            tip = this.myTips.get(lastTip - 1);
        }
        this.setTip(tip, lastTip, this.myBrowser, settings);
    }

    public boolean canBeHidden() {
        return true;
    }

    public boolean shouldSaveOptionsOnCancel() {
        return true;
    }

    public boolean isToBeShown() {
        return !GeneralSettings.getInstance().isShowTipsOnStartup();
    }

    public void setToBeShown(boolean toBeShown, int exitCode) {
        GeneralSettings.getInstance().setShowTipsOnStartup(!toBeShown);
    }

    @NotNull
    public String getDoNotShowMessage() {
        String string = IdeBundle.message((String)"checkbox.show.tips.on.startup", (Object[])new Object[0]);
        if (string == null) {
            TipPanel.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/TipPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/TipPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDoNotShowMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setTips";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

