/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.accounts;

import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubServerPath;

@Tag(value="account")
public class GithubAccount {
    @Attribute(value="id")
    @NotNull
    private final String myId;
    @Attribute(value="name")
    @NotNull
    private String myName;
    @Property(style=Property.Style.ATTRIBUTE, surroundWithTag=false)
    @NotNull
    private final GithubServerPath myServer;

    private GithubAccount() {
        this.myId = "";
        this.myName = "";
        this.myServer = new GithubServerPath();
    }

    GithubAccount(@NotNull String name, @NotNull GithubServerPath server) {
        if (name == null) {
            GithubAccount.$$$reportNull$$$0(0);
        }
        if (server == null) {
            GithubAccount.$$$reportNull$$$0(1);
        }
        this.myId = UUID.randomUUID().toString();
        this.myName = name;
        this.myServer = server;
    }

    public String toString() {
        return this.myServer + "/" + this.myName;
    }

    @NotNull
    String getId() {
        String string = this.myId;
        if (string == null) {
            GithubAccount.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            GithubAccount.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Transient
    public void setName(@NotNull String name) {
        if (name == null) {
            GithubAccount.$$$reportNull$$$0(4);
        }
        this.myName = name;
    }

    @NotNull
    public GithubServerPath getServer() {
        GithubServerPath githubServerPath = this.myServer;
        if (githubServerPath == null) {
            GithubAccount.$$$reportNull$$$0(5);
        }
        return githubServerPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GithubAccount)) {
            return false;
        }
        GithubAccount account = (GithubAccount)o;
        return Objects.equals(this.myId, account.myId);
    }

    public int hashCode() {
        return Objects.hash(this.myId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/authentication/accounts/GithubAccount";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/authentication/accounts/GithubAccount";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getServer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

