/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.ui.PushLogTreeUtil;
import com.intellij.dvcs.push.ui.PushTargetEditorListener;
import com.intellij.dvcs.push.ui.PushTargetTextField;
import com.intellij.dvcs.push.ui.VcsEditableTextComponent;
import com.intellij.dvcs.push.ui.VcsLinkListener;
import com.intellij.dvcs.push.ui.VcsLinkedTextComponent;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TextIcon;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.ComponentsListFocusTraversalPolicy;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.push.GitPushSupport;
import git4idea.push.GitPushTarget;
import git4idea.remote.GitDefineRemoteDialog;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushTargetPanel
extends PushTargetPanel<GitPushTarget> {
    private static final Logger LOG = Logger.getInstance(GitPushTargetPanel.class);
    private static final Comparator<GitRemoteBranch> REMOTE_BRANCH_COMPARATOR = new MyRemoteBranchComparator();
    private static final String SEPARATOR = " : ";
    private static final Color NEW_BRANCH_LABEL_FG = new JBColor(46397, 7054941);
    private static final Color NEW_BRANCH_LABEL_SELECTION_FG = UIUtil.getTreeSelectionForeground();
    private static final Color NEW_BRANCH_LABEL_BG = new JBColor(15465713, 3226418);
    private static final Color NEW_BRANCH_LABEL_SELECTION_BG = new JBColor(ColorUtil.toAlpha((Color)NEW_BRANCH_LABEL_SELECTION_FG, (int)20), ColorUtil.toAlpha((Color)NEW_BRANCH_LABEL_SELECTION_FG, (int)30));
    private static final RelativeFont NEW_BRANCH_LABEL_FONT = RelativeFont.TINY.small();
    private static final TextIcon NEW_BRANCH_LABEL = new TextIcon("New", NEW_BRANCH_LABEL_FG, NEW_BRANCH_LABEL_BG, 0);
    @NotNull
    private final GitPushSupport myPushSupport;
    @NotNull
    private final GitRepository myRepository;
    @NotNull
    private final Git myGit;
    @NotNull
    private final VcsEditableTextComponent myTargetRenderer;
    @NotNull
    private final PushTargetTextField myTargetEditor;
    @NotNull
    private final VcsLinkedTextComponent myRemoteRenderer;
    @NotNull
    private final Project myProject;
    @Nullable
    private GitPushTarget myCurrentTarget;
    @Nullable
    private String myError;
    @Nullable
    private Runnable myFireOnChangeAction;
    private boolean myBranchWasUpdatedManually;
    private boolean myEventFromRemoteChooser;

    public GitPushTargetPanel(@NotNull GitPushSupport support, @NotNull GitRepository repository, @Nullable GitPushTarget defaultTarget) {
        if (support == null) {
            GitPushTargetPanel.$$$reportNull$$$0(0);
        }
        if (repository == null) {
            GitPushTargetPanel.$$$reportNull$$$0(1);
        }
        this.myPushSupport = support;
        this.myRepository = repository;
        this.myGit = Git.getInstance();
        this.myProject = this.myRepository.getProject();
        this.myTargetRenderer = new VcsEditableTextComponent("", null);
        this.myTargetEditor = new PushTargetTextField(repository.getProject(), GitPushTargetPanel.getTargetNames(this.myRepository), "");
        this.myRemoteRenderer = new VcsLinkedTextComponent("", new VcsLinkListener(){

            public void hyperlinkActivated(@NotNull DefaultMutableTreeNode sourceNode, @NotNull MouseEvent event) {
                if (sourceNode == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (GitPushTargetPanel.this.myRepository.getRemotes().isEmpty()) {
                    GitPushTargetPanel.this.showDefineRemoteDialog();
                } else {
                    Component eventComponent = event.getComponent();
                    if (eventComponent != null) {
                        GitPushTargetPanel.this.showRemoteSelector(eventComponent, event.getPoint());
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "sourceNode";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "git4idea/push/GitPushTargetPanel$1";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        JPanel remoteAndSeparator = new JPanel(new BorderLayout());
        remoteAndSeparator.setOpaque(false);
        remoteAndSeparator.add((Component)this.myRemoteRenderer, "Center");
        remoteAndSeparator.add((Component)new JBLabel(SEPARATOR), "East");
        this.add(remoteAndSeparator, "West");
        this.add((Component)this.myTargetEditor, "Center");
        this.updateComponents(defaultTarget);
        this.setFocusCycleRoot(true);
        this.myRemoteRenderer.setFocusable(true);
        this.myTargetEditor.setFocusable(true);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)((Object)new MyGitTargetFocusTraversalPolicy()));
        this.myRemoteRenderer.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (GitPushTargetPanel.this.myTargetEditor.isShowing()) {
                    GitPushTargetPanel.this.showRemoteSelector((Component)GitPushTargetPanel.this.myRemoteRenderer, new Point(GitPushTargetPanel.this.myRemoteRenderer.getLocation()));
                }
            }
        });
        this.myTargetEditor.getDocument().putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
    }

    private void updateComponents(@Nullable GitPushTarget target) {
        this.myCurrentTarget = target;
        String initialBranch = "";
        String initialRemote = "";
        boolean noRemotes = this.myRepository.getRemotes().isEmpty();
        if (target == null) {
            if (this.myRepository.getCurrentBranch() == null) {
                this.myError = "Detached HEAD";
            } else if (this.myRepository.isFresh()) {
                this.myError = "Empty repository";
            } else if (!noRemotes) {
                this.myError = "Can't push";
            }
        } else {
            initialBranch = GitPushTargetPanel.getTextFieldText(target);
            initialRemote = target.getBranch().getRemote().getName();
        }
        this.myTargetRenderer.updateLinkText(initialBranch);
        this.myTargetEditor.setText(initialBranch);
        this.myRemoteRenderer.updateLinkText(noRemotes ? "Define remote" : initialRemote);
        this.myTargetEditor.setVisible(!noRemotes);
    }

    private void showDefineRemoteDialog() {
        GitDefineRemoteDialog dialog = new GitDefineRemoteDialog(this.myRepository, this.myGit);
        if (dialog.showAndGet()) {
            this.addRemoteUnderModal(dialog.getRemoteName(), dialog.getRemoteUrl());
        }
    }

    private void addRemoteUnderModal(final @NotNull String remoteName, final @NotNull String remoteUrl) {
        if (remoteName == null) {
            GitPushTargetPanel.$$$reportNull$$$0(2);
        }
        if (remoteUrl == null) {
            GitPushTargetPanel.$$$reportNull$$$0(3);
        }
        ProgressManager.getInstance().run((Task)new Task.Modal(this.myRepository.getProject(), "Adding Remote...", true){
            private GitCommandResult myResult;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                this.myResult = GitPushTargetPanel.this.myGit.addRemote(GitPushTargetPanel.this.myRepository, remoteName, remoteUrl);
                GitPushTargetPanel.this.myRepository.update();
            }

            public void onSuccess() {
                if (this.myResult.success()) {
                    GitPushTargetPanel.this.updateComponents(GitPushTargetPanel.this.myPushSupport.getDefaultTarget(GitPushTargetPanel.this.myRepository));
                    if (GitPushTargetPanel.this.myFireOnChangeAction != null) {
                        GitPushTargetPanel.this.myFireOnChangeAction.run();
                    }
                } else {
                    String message = "Couldn't add remote: " + this.myResult.getErrorOutputAsHtmlString();
                    LOG.warn(message);
                    Messages.showErrorDialog((Project)this.myProject, (String)XmlStringUtil.wrapInHtml((CharSequence)message), (String)"Add Remote");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/push/GitPushTargetPanel$3", "run"));
            }
        });
    }

    private void showRemoteSelector(@NotNull Component component, @NotNull Point point) {
        List<PopupItem> remotes;
        if (component == null) {
            GitPushTargetPanel.$$$reportNull$$$0(4);
        }
        if (point == null) {
            GitPushTargetPanel.$$$reportNull$$$0(5);
        }
        if ((remotes = this.getPopupItems()).size() <= 1) {
            return;
        }
        ListPopupImpl popup = new ListPopupImpl((ListPopupStep)new BaseListPopupStep<PopupItem>(null, remotes){

            public PopupStep onChosen(@NotNull PopupItem selectedValue, boolean finalChoice) {
                if (selectedValue == null) {
                    4.$$$reportNull$$$0(0);
                }
                return this.doFinalStep(() -> {
                    if (selectedValue.isDefineRemote()) {
                        GitPushTargetPanel.this.showDefineRemoteDialog();
                    } else {
                        GitPushTargetPanel.this.myRemoteRenderer.updateLinkText(selectedValue.getPresentable());
                        GitPushTargetPanel.this.myEventFromRemoteChooser = true;
                        if (!GitPushTargetPanel.this.myTargetEditor.isShowing()) {
                            String defaultPushTargetBranch;
                            if (!GitPushTargetPanel.this.myBranchWasUpdatedManually && (defaultPushTargetBranch = GitPushTargetPanel.this.getDefaultPushTargetBranch()) != null) {
                                GitPushTargetPanel.this.myTargetEditor.setText(defaultPushTargetBranch);
                            }
                            if (GitPushTargetPanel.this.myFireOnChangeAction != null) {
                                GitPushTargetPanel.this.myFireOnChangeAction.run();
                            }
                        }
                        GitPushTargetPanel.this.myEventFromRemoteChooser = false;
                    }
                });
            }

            @Nullable
            public ListSeparator getSeparatorAbove(PopupItem value) {
                return value.isDefineRemote() ? new ListSeparator() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedValue", "git4idea/push/GitPushTargetPanel$4", "onChosen"));
            }
        }){

            public void cancel(InputEvent e) {
                super.cancel(e);
                if (GitPushTargetPanel.this.myTargetEditor.isShowing()) {
                    GitPushTargetPanel.this.repaint();
                    IdeFocusManager.getInstance((Project)GitPushTargetPanel.this.myProject).requestFocus((Component)GitPushTargetPanel.this.myTargetEditor, true);
                }
            }
        };
        popup.show(new RelativePoint(component, point));
    }

    @Nullable
    private String getDefaultPushTargetBranch() {
        GitPushTarget fromPushSpec;
        GitLocalBranch sourceBranch = this.myRepository.getCurrentBranch();
        GitRemote remote = GitPushTarget.findRemote(this.myRepository.getRemotes(), this.myRemoteRenderer.getText());
        if (remote != null && sourceBranch != null && (fromPushSpec = GitPushTarget.getFromPushSpec(this.myRepository, remote, sourceBranch)) != null) {
            return fromPushSpec.getBranch().getNameForRemoteOperations();
        }
        return null;
    }

    @NotNull
    private List<PopupItem> getPopupItems() {
        ArrayList items = ContainerUtil.newArrayList((Iterable)ContainerUtil.map(this.myRepository.getRemotes(), PopupItem::forRemote));
        items.add(PopupItem.DEFINE_REMOTE);
        ArrayList arrayList = items;
        if (arrayList == null) {
            GitPushTargetPanel.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public void render(@NotNull ColoredTreeCellRenderer renderer, boolean isSelected, boolean isActive, @Nullable String forceRenderedText) {
        if (renderer == null) {
            GitPushTargetPanel.$$$reportNull$$$0(7);
        }
        SimpleTextAttributes targetTextAttributes = PushLogTreeUtil.addTransparencyIfNeeded((SimpleColoredComponent)renderer, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (boolean)isActive);
        if (this.myError != null) {
            renderer.append(this.myError, PushLogTreeUtil.addTransparencyIfNeeded((SimpleColoredComponent)renderer, (SimpleTextAttributes)SimpleTextAttributes.ERROR_ATTRIBUTES, (boolean)isActive));
        } else {
            Collection<GitRemote> remotes = this.myRepository.getRemotes();
            this.myRemoteRenderer.setSelected(isSelected);
            this.myRemoteRenderer.setTransparent(!remotes.isEmpty() && !isActive);
            this.myRemoteRenderer.render(renderer);
            if (!remotes.isEmpty()) {
                renderer.append(SEPARATOR, targetTextAttributes);
                if (forceRenderedText != null) {
                    renderer.append(forceRenderedText);
                    return;
                }
                GitPushTarget target = this.getValue();
                boolean newRemoteBranch = target != null && target.isNewBranchCreated();
                this.myTargetRenderer.setSelected(isSelected);
                this.myTargetRenderer.setTransparent(!isActive);
                this.myTargetRenderer.render(renderer);
                if (newRemoteBranch) {
                    renderer.setIconOnTheRight(true);
                    NEW_BRANCH_LABEL.setInsets((Insets)JBUI.insets((int)2));
                    NEW_BRANCH_LABEL.setRound(JBUI.scale((int)4));
                    NEW_BRANCH_LABEL.setFont(NEW_BRANCH_LABEL_FONT.derive(renderer.getFont()));
                    NEW_BRANCH_LABEL.setForeground(isSelected ? NEW_BRANCH_LABEL_SELECTION_FG : NEW_BRANCH_LABEL_FG);
                    NEW_BRANCH_LABEL.setBackground(isSelected ? NEW_BRANCH_LABEL_SELECTION_BG : NEW_BRANCH_LABEL_BG);
                    renderer.setIcon((Icon)NEW_BRANCH_LABEL);
                }
            }
        }
    }

    @Nullable
    public GitPushTarget getValue() {
        return this.myCurrentTarget;
    }

    @NotNull
    private static String getTextFieldText(@Nullable GitPushTarget target) {
        String string = target != null ? target.getBranch().getNameForRemoteOperations() : "";
        if (string == null) {
            GitPushTargetPanel.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void fireOnCancel() {
        this.myTargetEditor.setText(GitPushTargetPanel.getTextFieldText(this.myCurrentTarget));
    }

    public void fireOnChange() {
        if (this.myError != null || this.myRepository.getRemotes().isEmpty()) {
            return;
        }
        String remoteName = this.myRemoteRenderer.getText();
        String branchName = this.myTargetEditor.getText();
        try {
            GitPushTarget target = GitPushTarget.parse(this.myRepository, remoteName, branchName);
            if (!target.equals(this.myCurrentTarget)) {
                this.myCurrentTarget = target;
                this.myTargetRenderer.updateLinkText(branchName);
                if (!this.myEventFromRemoteChooser) {
                    this.myBranchWasUpdatedManually = true;
                }
            }
        }
        catch (ParseException e) {
            LOG.error("Invalid remote name shouldn't be allowed. [" + remoteName + ", " + branchName + "]", (Throwable)e);
        }
    }

    @Nullable
    public ValidationInfo verify() {
        if (this.myError != null) {
            return new ValidationInfo(this.myError, (JComponent)this.myTargetEditor);
        }
        try {
            GitPushTarget.parse(this.myRepository, this.myRemoteRenderer.getText(), this.myTargetEditor.getText());
            return null;
        }
        catch (ParseException e) {
            return new ValidationInfo(e.getMessage(), (JComponent)this.myTargetEditor);
        }
    }

    public void setFireOnChangeAction(@NotNull Runnable action) {
        if (action == null) {
            GitPushTargetPanel.$$$reportNull$$$0(9);
        }
        this.myFireOnChangeAction = action;
    }

    @NotNull
    private static List<String> getTargetNames(@NotNull GitRepository repository) {
        if (repository == null) {
            GitPushTargetPanel.$$$reportNull$$$0(10);
        }
        List<String> list = repository.getBranches().getRemoteBranches().stream().sorted(REMOTE_BRANCH_COMPARATOR).map(GitRemoteBranch::getNameForRemoteOperations).collect(Collectors.toList());
        if (list == null) {
            GitPushTargetPanel.$$$reportNull$$$0(11);
        }
        return list;
    }

    public void addTargetEditorListener(final @NotNull PushTargetEditorListener listener) {
        if (listener == null) {
            GitPushTargetPanel.$$$reportNull$$$0(12);
        }
        this.myTargetEditor.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                GitPushTargetPanel.this.processActiveUserChanges(listener);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/push/GitPushTargetPanel$6", "documentChanged"));
            }
        });
        this.myTargetEditor.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                GitPushTargetPanel.this.processActiveUserChanges(listener);
            }
        });
        this.myTargetEditor.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    GitPushTargetPanel.this.myTargetEditor.getDocument().putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)(!GitPushTargetPanel.this.myTargetEditor.isShowing() ? 1 : 0));
                }
            }
        });
    }

    private void processActiveUserChanges(@NotNull PushTargetEditorListener listener) {
        if (listener == null) {
            GitPushTargetPanel.$$$reportNull$$$0(13);
        }
        if (this.myTargetEditor.isShowing()) {
            listener.onTargetInEditModeChanged(this.myTargetEditor.getText());
        }
    }

    public void forceUpdateEditableUiModel(@NotNull String forcedText) {
        if (forcedText == null) {
            GitPushTargetPanel.$$$reportNull$$$0(14);
        }
        if (!this.myTargetEditor.isShowing()) {
            this.myTargetEditor.setText(forcedText);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "support";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteUrl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/push/GitPushTargetPanel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forcedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/push/GitPushTargetPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupItems";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFieldText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addRemoteUnderModal";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showRemoteSelector";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setFireOnChangeAction";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTargetNames";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addTargetEditorListener";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processActiveUserChanges";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "forceUpdateEditableUiModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyGitTargetFocusTraversalPolicy
    extends ComponentsListFocusTraversalPolicy {
        private MyGitTargetFocusTraversalPolicy() {
        }

        @NotNull
        protected List<Component> getOrderedComponents() {
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])new Component[]{GitPushTargetPanel.this.myTargetEditor.getFocusTarget(), GitPushTargetPanel.this.myRemoteRenderer});
            if (arrayList == null) {
                MyGitTargetFocusTraversalPolicy.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        public Component getComponentAfter(Container aContainer, Component aComponent) {
            if (GitPushTargetPanel.this.getPopupItems().size() > 1) {
                return super.getComponentAfter(aContainer, aComponent);
            }
            return aComponent;
        }

        public Component getComponentBefore(Container aContainer, Component aComponent) {
            if (GitPushTargetPanel.this.getPopupItems().size() > 1) {
                return super.getComponentBefore(aContainer, aComponent);
            }
            return aComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/push/GitPushTargetPanel$MyGitTargetFocusTraversalPolicy", "getOrderedComponents"));
        }
    }

    private static class PopupItem {
        static final PopupItem DEFINE_REMOTE = new PopupItem(null);
        @Nullable
        GitRemote remote;

        @NotNull
        static PopupItem forRemote(@NotNull GitRemote remote) {
            if (remote == null) {
                PopupItem.$$$reportNull$$$0(0);
            }
            PopupItem popupItem = new PopupItem(remote);
            if (popupItem == null) {
                PopupItem.$$$reportNull$$$0(1);
            }
            return popupItem;
        }

        private PopupItem(@Nullable GitRemote remote) {
            this.remote = remote;
        }

        @NotNull
        String getPresentable() {
            String string = this.remote == null ? "Define Remote" : this.remote.getName();
            if (string == null) {
                PopupItem.$$$reportNull$$$0(2);
            }
            return string;
        }

        boolean isDefineRemote() {
            return this.remote == null;
        }

        public String toString() {
            return this.getPresentable();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "remote";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/push/GitPushTargetPanel$PopupItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/push/GitPushTargetPanel$PopupItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "forRemote";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "forRemote";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyRemoteBranchComparator
    implements Comparator<GitRemoteBranch> {
        private MyRemoteBranchComparator() {
        }

        @Override
        public int compare(@NotNull GitRemoteBranch o1, @NotNull GitRemoteBranch o2) {
            String remoteName2;
            String remoteName1;
            int remoteComparison;
            if (o1 == null) {
                MyRemoteBranchComparator.$$$reportNull$$$0(0);
            }
            if (o2 == null) {
                MyRemoteBranchComparator.$$$reportNull$$$0(1);
            }
            if ((remoteComparison = (remoteName1 = o1.getRemote().getName()).compareTo(remoteName2 = o2.getRemote().getName())) != 0) {
                if (remoteName1.equals("origin")) {
                    return -1;
                }
                if (remoteName2.equals("origin")) {
                    return 1;
                }
                return remoteComparison;
            }
            return o1.getNameForLocalOperations().compareTo(o2.getNameForLocalOperations());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "o1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "o2";
                    break;
                }
            }
            objectArray[1] = "git4idea/push/GitPushTargetPanel$MyRemoteBranchComparator";
            objectArray[2] = "compare";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

