/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import org.sejda.impl.sambox.component.PageTextWriter;
import org.sejda.model.exception.TaskIOException;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PDPageContentStream;
import org.sejda.sambox.pdmodel.PDPageTree;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.font.PDFont;
import org.sejda.sambox.pdmodel.font.PDType1Font;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationFileAttachment;
import org.sejda.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentsSummaryCreator {
    private static final Logger LOG = LoggerFactory.getLogger(AttachmentsSummaryCreator.class);
    private static final int DEFAULT_FONT_SIZE = 14;
    private static final int DEFAULT_LINE_HEIGHT = 23;
    private static final int DEFAULT_MARGIN = 40;
    private static final String SEPARATOR = "  ";
    private static final PDFont FONT = PDType1Font.HELVETICA;
    private static final PDRectangle PAGE_SIZE = PDRectangle.A4;
    private final Deque<ToCItem> items = new LinkedList<ToCItem>();
    private PDDocument document;
    private PageTextWriter writer;

    public AttachmentsSummaryCreator(PDDocument document) {
        RequireUtils.requireNotNullArg((Object)document, (String)"Containing document cannot be null");
        this.document = document;
        this.writer = new PageTextWriter(document);
    }

    public void appendItem(String attachmentName, PDAnnotationFileAttachment annotation) {
        RequireUtils.requireNotBlank((String)attachmentName, (String)"Attachment name cannot be blank");
        RequireUtils.requireNotNullArg((Object)annotation, (String)"ToC annotation cannot be null");
        this.items.add(new ToCItem(attachmentName, annotation));
    }

    public void addToC() {
        try {
            PDPageTree pagesTree = this.document.getPages();
            Optional.ofNullable(this.generateToC()).filter(l -> !l.isEmpty()).ifPresent(t -> t.descendingIterator().forEachRemaining(p -> {
                if (pagesTree.getCount() > 0) {
                    pagesTree.insertBefore(p, pagesTree.get(0));
                } else {
                    pagesTree.add(p);
                }
            }));
        }
        catch (IOException | TaskIOException e) {
            LOG.error("An error occurred while create the ToC. Skipping ToC creation.", e);
        }
    }

    private LinkedList<PDPage> generateToC() throws TaskIOException, IOException {
        LinkedList<PDPage> pages = new LinkedList<PDPage>();
        int maxRows = (int)((PAGE_SIZE.getHeight() - 80.0f) / 23.0f);
        while (!this.items.isEmpty()) {
            int row = 0;
            float separatorWidth = this.stringLength(SEPARATOR);
            PDPage page = this.createPage(pages);
            PDPageContentStream stream = new PDPageContentStream(this.document, page);
            Throwable throwable = null;
            try {
                while (!this.items.isEmpty() && row < maxRows) {
                    ToCItem i = this.items.poll();
                    if (!Objects.nonNull(i)) continue;
                    float y = PAGE_SIZE.getHeight() - 40.0f - (float)(++row * 23);
                    float x = 40.0f;
                    String itemText = this.sanitize(i.text, separatorWidth);
                    this.writeText(page, itemText, x, y);
                    float textLenght = this.stringLength(itemText);
                    this.writeText(page, SEPARATOR, 40.0f + textLenght, y);
                    i.annotation.setRectangle(new PDRectangle(40.0f + textLenght + separatorWidth, y, 14.0f, 14.0f));
                    page.getAnnotations().add(i.annotation);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stream.close();
            }
        }
        return pages;
    }

    private void writeText(PDPage page, String s, float x, float y) throws TaskIOException {
        this.writer.write(page, (Point2D)new Point2D.Float(x, y), s, FONT, (Double)14.0, Color.BLACK);
    }

    private String sanitize(String text, float separatorWidth) throws TaskIOException {
        float maxLen = PAGE_SIZE.getWidth() - 80.0f - 14.0f - separatorWidth;
        if (this.stringLength(text) > maxLen) {
            LOG.debug("Truncating ToC text to fit available space");
            int currentLength = text.length() / 2;
            while (this.stringLength(text.substring(0, currentLength)) > maxLen) {
                currentLength /= 2;
            }
            int currentChunk = currentLength;
            while (currentChunk > 1) {
                if (!(this.stringLength(text.substring(0, currentLength + (currentChunk /= 2))) < maxLen)) continue;
                currentLength += currentChunk;
            }
            return text.substring(0, currentLength);
        }
        return text;
    }

    private PDPage createPage(LinkedList<PDPage> pages) {
        LOG.debug("Creating new ToC page");
        PDPage page = new PDPage(PAGE_SIZE);
        pages.add(page);
        return page;
    }

    private float stringLength(String text) throws TaskIOException {
        return this.writer.getStringWidth(text, FONT, 14.0f);
    }

    public boolean hasToc() {
        return !this.items.isEmpty();
    }

    private static class ToCItem {
        public final String text;
        public final PDAnnotationFileAttachment annotation;

        public ToCItem(String text, PDAnnotationFileAttachment annotation) {
            this.text = text;
            this.annotation = annotation;
        }
    }
}

