/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.actions;

import com.sun.source.tree.ExportsTree;
import com.sun.source.tree.OpensTree;
import com.sun.source.tree.ProvidesTree;
import com.sun.source.tree.RequiresTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UsesTree;
import com.sun.source.util.TreePath;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.QualifiedNameable;
import javax.swing.AbstractAction;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class OpenAction
extends AbstractAction {
    private final Openable performer;

    private OpenAction(@NonNull Openable performer) {
        Parameters.notNull((CharSequence)"performer", (Object)performer);
        this.performer = performer;
        this.putValue("Name", NbBundle.getMessage(OpenAction.class, (String)"LBL_Goto"));
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        block2: {
            try {
                this.performer.open();
            }
            catch (CannotOpen co) {
                String msg = co.getLocalizedMessage();
                Toolkit.getDefaultToolkit().beep();
                if (msg == null) break block2;
                StatusDisplayer.getDefault().setStatusText(msg);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @NonNull
    public static Openable openable(@NonNull ElementHandle<?> handle, @NonNull FileObject fileObject, @NonNull String displayName) {
        return () -> {
            FileObject src;
            OpenAction.checkFile(fileObject, displayName);
            FileObject file = fileObject;
            if (OpenAction.isClassFile(file) && (src = OpenAction.findSource(file, handle)) != null) {
                file = src;
            }
            if (!ElementOpen.open((FileObject)file, (ElementHandle)handle)) {
                OpenAction.noSource(displayName);
            }
        };
    }

    @NonNull
    public static Openable openable(@NonNull TreePathHandle handle, @NonNull FileObject fileObject, @NonNull String displayName) {
        return () -> {
            OpenAction.checkFile(fileObject, displayName);
            if (!ElementOpen.open((FileObject)fileObject, (TreePathHandle)handle)) {
                OpenAction.noSource(displayName);
            }
        };
    }

    @NonNull
    public static Openable openable(@NonNull ModuleElement module, @NonNull ModuleElement.Directive directive, @NonNull ClasspathInfo cpInfo) {
        String displayName = module.getQualifiedName().toString();
        ElementHandle moduleHandle = ElementHandle.create((Element)module);
        Object[] directiveHandle = OpenAction.createDirectiveHandle(directive);
        return () -> {
            TreePathHandle path;
            FileObject source = SourceUtils.getFile((ElementHandle)moduleHandle, (ClasspathInfo)cpInfo);
            if (source == null) {
                OpenAction.noSource(displayName);
            }
            if ((path = OpenAction.resolveDirectiveHandle(source, directiveHandle)) == null) {
                OpenAction.noSource(displayName);
            }
            if (!ElementOpen.open((FileObject)source, (TreePathHandle)path)) {
                OpenAction.noSource(displayName);
            }
        };
    }

    @NonNull
    public static OpenAction create(@NonNull Openable openable) {
        return new OpenAction(openable);
    }

    private static void checkFile(@NullAllowed FileObject fileObject, @NullAllowed String displayName) {
        if (null == fileObject) {
            OpenAction.noSource(displayName);
        }
    }

    private static void noSource(@NullAllowed String displayName) {
        throw new CannotOpen(displayName == null ? NbBundle.getMessage(OpenAction.class, (String)"MSG_NoSource_Generic") : NbBundle.getMessage(OpenAction.class, (String)"MSG_NoSource", (Object)displayName));
    }

    private static boolean isClassFile(@NonNull FileObject file) {
        return "application/x-class-file".equals(file.getMIMEType(new String[]{"application/x-class-file"})) || "class".equals(file.getExt());
    }

    @CheckForNull
    private static FileObject findSource(@NonNull FileObject file, @NonNull ElementHandle<?> elementHandle) {
        String id;
        ClassPath cp;
        FileObject owner = null;
        String[] stringArray = new String[]{"classpath/execute", "classpath/compile", "classpath/boot"};
        int n = stringArray.length;
        for (int i = 0; i < n && ((cp = ClassPath.getClassPath((FileObject)file, (String)(id = stringArray[i]))) == null || (owner = cp.findOwnerRoot(file)) == null); ++i) {
        }
        return owner == null ? owner : SourceUtils.getFile(elementHandle, (ClasspathInfo)ClasspathInfo.create((ClassPath)ClassPathSupport.createClassPath((FileObject[])new FileObject[]{owner}), (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY));
    }

    @NonNull
    private static Object[] createDirectiveHandle(@NonNull ModuleElement.Directive dir) {
        switch (dir.getKind()) {
            case EXPORTS: {
                return new Object[]{dir.getKind(), ((ModuleElement.ExportsDirective)dir).getPackage().getQualifiedName().toString()};
            }
            case OPENS: {
                return new Object[]{dir.getKind(), ((ModuleElement.OpensDirective)dir).getPackage().getQualifiedName().toString()};
            }
            case REQUIRES: {
                return new Object[]{dir.getKind(), ((ModuleElement.RequiresDirective)dir).getDependency().getQualifiedName().toString()};
            }
            case USES: {
                return new Object[]{dir.getKind(), ((ModuleElement.UsesDirective)dir).getService().getQualifiedName().toString()};
            }
            case PROVIDES: {
                return new Object[]{dir.getKind(), ((ModuleElement.ProvidesDirective)dir).getService().getQualifiedName().toString()};
            }
        }
        throw new IllegalArgumentException(String.valueOf(dir));
    }

    private static TreePathHandle resolveDirectiveHandle(@NonNull FileObject file, final @NonNull Object[] handle) {
        JavaSource js = JavaSource.forFileObject((FileObject)file);
        if (js == null) {
            return null;
        }
        try {
            final TreePathHandle[] res = new TreePathHandle[1];
            js.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(final CompilationController cc) throws Exception {
                    cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    new ErrorAwareTreePathScanner<Void, Void>(){

                        public Void visitExports(ExportsTree node, Void p) {
                            if (this.matches(handle, ModuleElement.DirectiveKind.EXPORTS, node.getPackageName())) {
                                res[0] = TreePathHandle.create((TreePath)this.getCurrentPath(), (CompilationInfo)cc);
                            }
                            return (Void)super.visitExports(node, (Object)p);
                        }

                        public Void visitOpens(OpensTree node, Void p) {
                            if (this.matches(handle, ModuleElement.DirectiveKind.OPENS, node.getPackageName())) {
                                res[0] = TreePathHandle.create((TreePath)this.getCurrentPath(), (CompilationInfo)cc);
                            }
                            return (Void)super.visitOpens(node, (Object)p);
                        }

                        public Void visitRequires(RequiresTree node, Void p) {
                            if (this.matches(handle, ModuleElement.DirectiveKind.REQUIRES, node.getModuleName())) {
                                res[0] = TreePathHandle.create((TreePath)this.getCurrentPath(), (CompilationInfo)cc);
                            }
                            return (Void)super.visitRequires(node, (Object)p);
                        }

                        public Void visitUses(UsesTree node, Void p) {
                            if (this.matches(handle, ModuleElement.DirectiveKind.USES, node.getServiceName())) {
                                res[0] = TreePathHandle.create((TreePath)this.getCurrentPath(), (CompilationInfo)cc);
                            }
                            return (Void)super.visitUses(node, (Object)p);
                        }

                        public Void visitProvides(ProvidesTree node, Void p) {
                            if (this.matches(handle, ModuleElement.DirectiveKind.PROVIDES, node.getServiceName())) {
                                res[0] = TreePathHandle.create((TreePath)this.getCurrentPath(), (CompilationInfo)cc);
                            }
                            return (Void)super.visitProvides(node, (Object)p);
                        }

                        private boolean matches(Object[] handle, ModuleElement.DirectiveKind kind, Tree selector) {
                            if (handle[0] != kind) {
                                return false;
                            }
                            TreePath selectorPath = new TreePath(this.getCurrentPath(), selector);
                            Element e = cc.getTrees().getElement(selectorPath);
                            return e instanceof QualifiedNameable ? ((QualifiedNameable)e).getQualifiedName().contentEquals((String)handle[1]) : false;
                        }
                    }.scan((Tree)cc.getCompilationUnit(), null);
                }
            }, true);
            return res[0];
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
            return null;
        }
    }

    private static final class CannotOpen
    extends RuntimeException {
        CannotOpen(@NullAllowed String localizedMessage) {
            super(localizedMessage);
        }
    }
}

