/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.declarative;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.java.hints.declarative.DeclarativeHintTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

class DeclarativeHintLexer
implements Lexer<DeclarativeHintTokenId> {
    private final LexerInput input;
    private final TokenFactory<DeclarativeHintTokenId> fact;
    private static final Pattern DISPLAY_NAME_RE = Pattern.compile("'[^']*':");
    private static final Pattern VARIABLE_RE = Pattern.compile("\\$[A-Za-z0-9_$]+");
    private static final Map<String, DeclarativeHintTokenId> TOKENS;
    private static final Map<String, DeclarativeHintTokenId> BLOCK_TOKEN_START;
    private static final Map<DeclarativeHintTokenId, String> BLOCK_TOKEN_END;

    public DeclarativeHintLexer(LexerRestartInfo<DeclarativeHintTokenId> info) {
        this.input = info.input();
        this.fact = info.tokenFactory();
    }

    public Token<DeclarativeHintTokenId> nextToken() {
        int read = this.input.read();
        if (read == -1) {
            return null;
        }
        int whitespaceLength = 0;
        if (Character.isWhitespace(read)) {
            while (read != -1 && Character.isWhitespace((char)read)) {
                read = this.input.read();
            }
            if (read == -1) {
                return this.fact.createToken((TokenId)DeclarativeHintTokenId.WHITESPACE);
            }
            whitespaceLength = this.input.readLength() - 1;
        }
        while (read != -1) {
            Object m;
            Matcher variableMatcher = VARIABLE_RE.matcher(this.input.readText());
            if (variableMatcher.find()) {
                int start = variableMatcher.start();
                if (start == 0) {
                    while ((read = this.input.read()) != -1 && ((Matcher)(m = VARIABLE_RE.matcher(this.input.readText()))).find() && ((Matcher)m).end() >= this.input.readLength()) {
                    }
                    if (read != -1) {
                        this.input.backup(1);
                    }
                    return this.fact.createToken((TokenId)DeclarativeHintTokenId.VARIABLE);
                }
                if (whitespaceLength == start) {
                    this.input.backup(this.input.readLength() - whitespaceLength);
                    return this.fact.createToken((TokenId)DeclarativeHintTokenId.WHITESPACE);
                }
                this.input.backup(this.input.readLength() - start);
                return this.fact.createToken((TokenId)DeclarativeHintTokenId.JAVA_SNIPPET);
            }
            if (this.input.readLength() > 1) {
                String inputString = this.input.readText().toString();
                m = BLOCK_TOKEN_START.entrySet().iterator();
                while (m.hasNext()) {
                    Map.Entry<String, DeclarativeHintTokenId> e = m.next();
                    if (!inputString.substring(0, inputString.length() - 1).endsWith(e.getKey())) continue;
                    this.input.backup(1);
                    Token<DeclarativeHintTokenId> preread = this.resolvePrereadText(e.getKey().length(), whitespaceLength);
                    if (preread != null) {
                        return preread;
                    }
                    return this.readBlockToken(e.getValue(), BLOCK_TOKEN_END.get((Object)e.getValue()));
                }
                Token<DeclarativeHintTokenId> t = this.testToken(inputString, whitespaceLength, false);
                if (t != null) {
                    return t;
                }
            }
            read = this.input.read();
        }
        Token<DeclarativeHintTokenId> t = this.testToken(this.input.readText().toString(), whitespaceLength, true);
        if (t != null) {
            return t;
        }
        return this.fact.createToken((TokenId)DeclarativeHintTokenId.JAVA_SNIPPET);
    }

    public Object state() {
        return null;
    }

    public void release() {
    }

    private Token<DeclarativeHintTokenId> testToken(String toTest, int whitespaceLength, boolean eof) {
        if (toTest.length() < 2 && !eof) {
            return null;
        }
        DeclarativeHintTokenId id = null;
        boolean exact = false;
        int backup = -1;
        int add = eof ? 0 : 1;
        String snip = toTest.substring(0, toTest.length() - add);
        String lastImage = "";
        for (Map.Entry<String, DeclarativeHintTokenId> e : TOKENS.entrySet()) {
            int i = snip.indexOf(e.getKey());
            if (i != -1 && (snip.length() - i + 1 > backup || e.getKey().startsWith(lastImage))) {
                id = e.getValue();
                backup = snip.length() - i + 1;
                exact = i == 0;
                lastImage = e.getKey();
            }
            if (eof) continue;
            for (int c = 1; c <= e.getKey().length(); ++c) {
                if (!toTest.endsWith(e.getKey().substring(e.getKey().length() - c))) continue;
                return null;
            }
        }
        if (id == null) {
            return null;
        }
        if (exact) {
            if (this.input.readLength() - lastImage.length() + (eof ? 1 : 0) > 0) {
                this.input.backup(this.input.readLength() - lastImage.length() + (eof ? 1 : 0));
            }
            return this.fact.createToken(id);
        }
        Token<DeclarativeHintTokenId> t = this.resolvePrereadText(backup, whitespaceLength);
        if (t != null) {
            return t;
        }
        if (!eof) {
            this.input.backup(1);
        }
        return this.fact.createToken(id);
    }

    private Token<DeclarativeHintTokenId> resolvePrereadText(int backupLength, int whitespaceLength) {
        if (whitespaceLength > 0) {
            if (this.input.readLengthEOF() == whitespaceLength + backupLength) {
                this.input.backup(this.input.readLengthEOF() - whitespaceLength);
                return this.fact.createToken((TokenId)DeclarativeHintTokenId.WHITESPACE);
            }
            this.input.backup(backupLength);
            return this.fact.createToken((TokenId)DeclarativeHintTokenId.JAVA_SNIPPET);
        }
        if (this.input.readLengthEOF() == backupLength) {
            return null;
        }
        this.input.backup(backupLength);
        return this.fact.createToken((TokenId)DeclarativeHintTokenId.JAVA_SNIPPET);
    }

    private Token<DeclarativeHintTokenId> readBlockToken(DeclarativeHintTokenId tokenId, String tokenEnd) {
        while (this.input.read() != -1 && !this.input.readText().toString().endsWith(tokenEnd)) {
        }
        return this.fact.createToken((TokenId)tokenId);
    }

    static {
        HashMap<String, DeclarativeHintTokenId> map = new HashMap<String, DeclarativeHintTokenId>();
        map.put("=>", DeclarativeHintTokenId.LEADS_TO);
        map.put("::", DeclarativeHintTokenId.DOUBLE_COLON);
        map.put("&&", DeclarativeHintTokenId.AND);
        map.put("!", DeclarativeHintTokenId.NOT);
        map.put(";;", DeclarativeHintTokenId.DOUBLE_SEMICOLON);
        map.put("%%", DeclarativeHintTokenId.DOUBLE_PERCENT);
        map.put("instanceof", DeclarativeHintTokenId.INSTANCEOF);
        map.put("otherwise", DeclarativeHintTokenId.OTHERWISE);
        map.put(":", DeclarativeHintTokenId.COLON);
        TOKENS = Collections.unmodifiableMap(map);
        HashMap<String, DeclarativeHintTokenId> blockStartMap = new HashMap<String, DeclarativeHintTokenId>();
        blockStartMap.put("/*", DeclarativeHintTokenId.BLOCK_COMMENT);
        blockStartMap.put("//", DeclarativeHintTokenId.LINE_COMMENT);
        blockStartMap.put("<?", DeclarativeHintTokenId.JAVA_BLOCK);
        blockStartMap.put("<!", DeclarativeHintTokenId.OPTIONS);
        blockStartMap.put("'", DeclarativeHintTokenId.CHAR_LITERAL);
        blockStartMap.put("\"", DeclarativeHintTokenId.STRING_LITERAL);
        BLOCK_TOKEN_START = Collections.unmodifiableMap(blockStartMap);
        HashMap<DeclarativeHintTokenId, String> blockEndMap = new HashMap<DeclarativeHintTokenId, String>();
        blockEndMap.put(DeclarativeHintTokenId.BLOCK_COMMENT, "*/");
        blockEndMap.put(DeclarativeHintTokenId.LINE_COMMENT, "\n");
        blockEndMap.put(DeclarativeHintTokenId.JAVA_BLOCK, "?>");
        blockEndMap.put(DeclarativeHintTokenId.OPTIONS, ">");
        blockEndMap.put(DeclarativeHintTokenId.CHAR_LITERAL, "'");
        blockEndMap.put(DeclarativeHintTokenId.STRING_LITERAL, "\"");
        BLOCK_TOKEN_END = Collections.unmodifiableMap(blockEndMap);
    }
}

