/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.Cache;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.Query;
import javax.persistence.SynchronizationType;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.metamodel.Metamodel;
import org.eclipse.persistence.config.ReferenceMode;
import org.eclipse.persistence.core.queries.CoreAttributeGroup;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.PersistenceUnitLoadingException;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.jpa.EntityGraphImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryDelegate;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.QueryImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.sessions.coordination.MetadataRefreshCommand;
import org.eclipse.persistence.jpa.JpaEntityManagerFactory;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.sessions.coordination.CommandManager;
import org.eclipse.persistence.sessions.coordination.MetadataRefreshListener;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.sessions.server.ServerSession;

public class EntityManagerFactoryImpl
implements EntityManagerFactory,
PersistenceUnitUtil,
JpaEntityManagerFactory {
    protected EntityManagerFactoryDelegate delegate;

    public static Object getIdentifier(Object entity, AbstractSession session) {
        ClassDescriptor descriptor = session.getDescriptor(entity);
        if (descriptor == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"jpa_persistence_util_non_persistent_class", (Object[])new Object[]{entity}));
        }
        if (descriptor.getCMPPolicy() != null) {
            return descriptor.getCMPPolicy().createPrimaryKeyInstance(entity, session);
        }
        throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"jpa_persistence_util_non_persistent_class", (Object[])new Object[]{entity}));
    }

    public static Boolean isLoaded(Object entity, AbstractSession session) {
        ClassDescriptor descriptor = session.getDescriptor(entity);
        if (descriptor == null) {
            return null;
        }
        Vector mappings = descriptor.getMappings();
        for (DatabaseMapping mapping : mappings) {
            if (mapping.isLazy() || EntityManagerFactoryImpl.isLoaded(entity, mapping.getAttributeName(), mapping)) continue;
            return false;
        }
        return true;
    }

    public static Boolean isLoaded(Object entity, String attributeName, AbstractSession session) {
        ClassDescriptor descriptor = session.getDescriptor(entity);
        if (descriptor == null) {
            return null;
        }
        if (descriptor.hasFetchGroupManager() && !descriptor.getFetchGroupManager().isAttributeFetched(entity, attributeName)) {
            return false;
        }
        DatabaseMapping mapping = descriptor.getMappingForAttributeName(attributeName);
        if (mapping == null) {
            return null;
        }
        return EntityManagerFactoryImpl.isLoaded(entity, attributeName, mapping);
    }

    public static boolean isLoaded(Object entity, String attributeName, DatabaseMapping mapping) {
        if (mapping.isForeignReferenceMapping() && ((ForeignReferenceMapping)mapping).isLazy()) {
            Object value = mapping.getAttributeValueFromObject(entity);
            IndirectionPolicy policy = ((ForeignReferenceMapping)mapping).getIndirectionPolicy();
            return policy.objectIsInstantiated(value);
        }
        if (entity instanceof FetchGroupTracker) {
            return ((FetchGroupTracker)entity)._persistence_isAttributeFetched(attributeName);
        }
        return true;
    }

    public EntityManagerFactoryImpl(AbstractSession session) {
        this.delegate = new EntityManagerFactoryDelegate(session, this);
    }

    public EntityManagerFactoryImpl(EntityManagerSetupImpl setupImpl, Map properties) {
        this.delegate = new EntityManagerFactoryDelegate(setupImpl, properties, this);
    }

    public EntityManagerFactoryImpl(String persistenceUnitName, Map<String, Object> properties, List<ClassDescriptor> descriptors) {
        this.delegate = new EntityManagerFactoryDelegate(persistenceUnitName, properties, descriptors, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshMetadata(Map properties) {
        EntityManagerSetupImpl setupImpl = this.delegate.getSetupImpl();
        if (setupImpl == null) {
            throw PersistenceUnitLoadingException.cannotRefreshEntityManagerFactoryCreatedFromSession((String)this.delegate.getServerSession().getName());
        }
        String sessionName = setupImpl.getSessionName();
        Map<String, Object> existingProperties = this.delegate.getProperties();
        HashMap<String, Object> deployProperties = new HashMap<String, Object>();
        deployProperties.putAll(existingProperties);
        if (properties != null) {
            deployProperties.putAll(properties);
        }
        EntityManagerSetupImpl newSetupImpl = setupImpl.refreshMetadata(properties);
        EntityManagerFactoryDelegate oldDelegate = this.delegate;
        this.delegate = new EntityManagerFactoryDelegate(newSetupImpl, deployProperties, this);
        try {
            if (newSetupImpl.shouldGetSessionOnCreateFactory(deployProperties)) {
                ServerSession session = this.getServerSession();
                CommandManager rcm = session.getCommandManager();
                if (rcm != null && newSetupImpl.shouldSendMetadataRefreshCommand(deployProperties)) {
                    MetadataRefreshCommand command = new MetadataRefreshCommand(properties);
                    rcm.propagateCommand((Object)command);
                }
                session.setRefreshMetadataListener((MetadataRefreshListener)newSetupImpl);
            }
        }
        catch (RuntimeException ex) {
            if (this.delegate != null) {
                this.delegate.close();
            } else {
                newSetupImpl.undeploy();
            }
            HashMap<String, EntityManagerSetupImpl> hashMap = EntityManagerFactoryProvider.emSetupImpls;
            synchronized (hashMap) {
                EntityManagerFactoryProvider.emSetupImpls.put(sessionName, setupImpl);
                SessionManager.getManager().getSessions().put(sessionName, setupImpl.getSession());
                setupImpl.setIsMetadataExpired(false);
            }
            this.delegate = oldDelegate;
            throw ex;
        }
    }

    @Override
    public SessionBroker getSessionBroker() {
        return this.delegate.getSessionBroker();
    }

    @Override
    public ServerSession getServerSession() {
        return this.delegate.getServerSession();
    }

    public synchronized void close() {
        this.delegate.close();
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public EntityManager createEntityManager() {
        return this.createEntityManagerImpl(null, null);
    }

    public EntityManager createEntityManager(Map properties) {
        return this.createEntityManagerImpl(properties, null);
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType) {
        return this.createEntityManagerImpl(null, synchronizationType);
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType, Map map) {
        return this.createEntityManagerImpl(map, synchronizationType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EntityManagerImpl createEntityManagerImpl(Map properties, SynchronizationType syncType) {
        EntityManagerSetupImpl setupImpl = this.delegate.getSetupImpl();
        if (setupImpl != null && setupImpl.isMetadataExpired()) {
            String sessionName = setupImpl.getSessionName();
            EntityManagerSetupImpl storedImpl = null;
            HashMap<String, EntityManagerSetupImpl> hashMap = EntityManagerFactoryProvider.emSetupImpls;
            synchronized (hashMap) {
                storedImpl = EntityManagerFactoryProvider.emSetupImpls.get(sessionName);
            }
            if (storedImpl != null) {
                this.delegate = new EntityManagerFactoryDelegate(storedImpl, this.delegate.getProperties(), this);
            }
        }
        return this.delegate.createEntityManagerImpl(properties, syncType);
    }

    @Override
    public EntityManagerFactoryDelegate unwrap() {
        return this.delegate;
    }

    protected void verifyOpen() {
        this.delegate.verifyOpen();
    }

    protected void finalize() throws Throwable {
        this.delegate = null;
    }

    public Object getProperty(String name) {
        return this.delegate.getProperty(name);
    }

    public boolean getBeginEarlyTransaction() {
        return this.delegate.getBeginEarlyTransaction();
    }

    public void setBeginEarlyTransaction(boolean beginEarlyTransaction) {
        this.delegate.setBeginEarlyTransaction(beginEarlyTransaction);
    }

    public FlushModeType getFlushMode() {
        return this.delegate.getFlushMode();
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.delegate.setFlushMode(flushMode);
    }

    public ReferenceMode getReferenceMode() {
        return this.delegate.getReferenceMode();
    }

    public void setReferenceMode(ReferenceMode referenceMode) {
        this.delegate.setReferenceMode(referenceMode);
    }

    public boolean getCloseOnCommit() {
        return this.delegate.getCloseOnCommit();
    }

    public void setCloseOnCommit(boolean closeOnCommit) {
        this.delegate.setCloseOnCommit(closeOnCommit);
    }

    public boolean getPersistOnCommit() {
        return this.delegate.getPersistOnCommit();
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this.delegate.getPersistenceUnitUtil();
    }

    public void setPersistOnCommit(boolean persistOnCommit) {
        this.delegate.setPersistOnCommit(persistOnCommit);
    }

    public boolean getCommitWithoutPersistRules() {
        return this.delegate.getCommitWithoutPersistRules();
    }

    public void setCommitWithoutPersistRules(boolean commitWithoutPersistRules) {
        this.delegate.setCommitWithoutPersistRules(commitWithoutPersistRules);
    }

    public String getFlushClearCache() {
        return this.delegate.getFlushClearCache();
    }

    public void setFlushClearCache(String flushClearCache) {
        this.delegate.setFlushClearCache(flushClearCache);
    }

    public boolean shouldValidateExistence() {
        return this.delegate.shouldValidateExistence();
    }

    public void setShouldValidateExistence(boolean shouldValidateExistence) {
        this.delegate.setShouldValidateExistence(shouldValidateExistence);
    }

    public Cache getCache() {
        return this.delegate.getCache();
    }

    public Map<String, Object> getProperties() {
        return this.delegate.getProperties();
    }

    @Override
    public DatabaseSessionImpl getDatabaseSession() {
        return this.delegate.getDatabaseSession();
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.delegate.getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.delegate.getMetamodel();
    }

    public void setMetamodel(Metamodel aMetamodel) {
        this.delegate.setMetamodel(aMetamodel);
    }

    public boolean isLoaded(Object entity, String attributeName) {
        return this.delegate.isLoaded(entity, attributeName);
    }

    public boolean isLoaded(Object entity) {
        return this.delegate.isLoaded(entity);
    }

    public Object getIdentifier(Object entity) {
        return this.delegate.getIdentifier(entity);
    }

    public boolean shouldOrderUpdates() {
        return this.delegate.shouldOrderUpdates();
    }

    public void setShouldOrderUpdates(boolean shouldOrderUpdates) {
        this.delegate.setShouldOrderUpdates(shouldOrderUpdates);
    }

    public void addNamedQuery(String name, Query query) {
        QueryImpl queryImpl = (QueryImpl)query.unwrap(QueryImpl.class);
        DatabaseQuery unwrapped = (DatabaseQuery)queryImpl.getDatabaseQueryInternal().clone();
        if (queryImpl.lockMode != null) {
            ((ObjectLevelReadQuery)unwrapped).setLockModeType(queryImpl.lockMode.name(), (AbstractSession)this.getServerSession());
        }
        if (unwrapped.isReadQuery()) {
            ((ReadQuery)unwrapped).setInternalMax(queryImpl.getMaxResultsInternal());
            ((ReadQuery)unwrapped).setFirstResult(queryImpl.getFirstResult());
        }
        this.getServerSession().addQuery(name, unwrapped, true);
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.equals(JpaEntityManagerFactory.class) || cls.equals(EntityManagerFactoryImpl.class)) {
            return (T)this;
        }
        if (cls.equals(EntityManagerFactoryDelegate.class)) {
            return (T)this.delegate;
        }
        if (cls.equals(Session.class) || cls.equals(AbstractSession.class)) {
            return (T)this.delegate.getAbstractSession();
        }
        if (cls.equals(DatabaseSession.class) || cls.equals(DatabaseSessionImpl.class)) {
            return (T)this.getDatabaseSession();
        }
        if (cls.equals(Server.class) || cls.equals(ServerSession.class)) {
            return (T)this.getServerSession();
        }
        if (cls.equals(SessionBroker.class)) {
            return (T)this.getSessionBroker();
        }
        throw new PersistenceException(ExceptionLocalization.buildMessage((String)"unable_to_unwrap_jpa", (Object[])new String[]{EntityManagerFactory.class.getName(), cls.getName()}));
    }

    public <T> void addNamedEntityGraph(String graphName, EntityGraph<T> entityGraph) {
        AttributeGroup group = ((EntityGraphImpl)entityGraph).getAttributeGroup().clone();
        group.setName(graphName);
        this.getServerSession().getAttributeGroups().put(graphName, group);
        this.getServerSession().getDescriptor(((EntityGraphImpl)entityGraph).getClassType()).addAttributeGroup((CoreAttributeGroup)group);
    }
}

