/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.unit;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.modules.j2ee.persistence.dd.common.Persistence;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_1.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.unit.PersistenceUnitPanel;
import org.netbeans.modules.j2ee.persistence.unit.PersistenceUnitPanelFactory;
import org.netbeans.modules.j2ee.persistence.unit.PersistenceValidator;
import org.netbeans.modules.j2ee.persistence.unit.PropertiesPanel;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.entity.WrapperPanel;
import org.netbeans.modules.j2ee.persistence.wizard.library.PersistenceLibrarySupport;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardDescriptor;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanel;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanelDS;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanelJdbc;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.ui.ConfirmDialog;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.netbeans.modules.xml.multiview.ui.SectionContainer;
import org.netbeans.modules.xml.multiview.ui.SectionContainerNode;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PersistenceToolBarMVElement
extends ToolBarMultiViewElement
implements PropertyChangeListener {
    private final ModelListener modelListener = new ModelListener();
    private ToolBarDesignEditor comp;
    private PersistenceView view;
    private PUDataObject puDataObject;
    private PersistenceUnitPanelFactory factory;
    private Action addAction;
    private Action removeAction;
    private Project project;
    private boolean needInit = true;
    private RequestProcessor.Task repaintingTask;

    public PersistenceToolBarMVElement(Lookup context) {
        super((XmlMultiViewDataObject)context.lookup(PUDataObject.class));
        this.puDataObject = (PUDataObject)((Object)context.lookup(PUDataObject.class));
        this.project = FileOwnerQuery.getOwner((FileObject)this.puDataObject.getPrimaryFile());
        this.addAction = new AddAction(NbBundle.getMessage(PersistenceToolBarMVElement.class, (String)"LBL_Add"));
        this.removeAction = new RemoveAction(NbBundle.getMessage(PersistenceToolBarMVElement.class, (String)"LBL_Remove"));
        this.comp = new ToolBarDesignEditor();
        this.factory = new PersistenceUnitPanelFactory(this.comp, this.puDataObject);
        this.setVisualEditor(this.comp);
        this.repaintingTask = RequestProcessor.getDefault().create(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PersistenceToolBarMVElement.this.repaintView();
                    }
                });
            }
        });
    }

    public SectionView getSectionView() {
        return this.view;
    }

    public void componentOpened() {
        super.componentOpened();
        this.dObj.addPropertyChangeListener((PropertyChangeListener)this);
        if (this.puDataObject != null && this.puDataObject.getPersistence() != null) {
            this.puDataObject.getPersistence().addPropertyChangeListener(this.modelListener);
        }
    }

    public void componentClosed() {
        super.componentClosed();
        this.dObj.removePropertyChangeListener((PropertyChangeListener)this);
        if (this.puDataObject != null && this.puDataObject.getPersistence() != null) {
            this.puDataObject.getPersistence().removePropertyChangeListener(this.modelListener);
        }
    }

    public void componentShowing() {
        super.componentShowing();
        this.view = new PersistenceView();
        if (!this.puDataObject.viewCanBeDisplayed()) {
            this.view.setRoot(Node.EMPTY);
            this.comp.setContentView((PanelView)this.view);
            return;
        }
        this.view.initialize(this.puDataObject);
        this.comp.setContentView((PanelView)this.view);
        Object lastActive = this.comp.getLastActive();
        if (lastActive != null) {
            this.view.openPanel(lastActive);
        } else {
            Node[] childrenNodes = this.view.getPersistenceUnitsNode().getChildren().getNodes();
            if (childrenNodes.length > 0) {
                this.view.selectNode(childrenNodes[0]);
                if (childrenNodes[0].getChildren().getNodes().length > 0) {
                    this.view.selectNode(childrenNodes[0].getChildren().getNodes()[0]);
                }
            }
        }
        this.view.checkValidity();
    }

    private boolean repaintView() {
        this.view = new PersistenceView();
        this.view.initialize(this.puDataObject);
        this.comp.setContentView((PanelView)this.view);
        Object lastActive = this.comp.getLastActive();
        if (lastActive != null) {
            this.view.openPanel(lastActive);
        } else {
            Node initialNode = this.view.getPersistenceUnitsNode();
            Children ch = initialNode.getChildren();
            if (ch.getNodesCount() > 0) {
                initialNode = ch.getNodes()[0];
            }
            this.view.selectNode(initialNode);
        }
        this.view.checkValidity();
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("persistence_unit_added_or_removed".equals(name)) {
            this.repaintingTask.schedule(100);
        } else if (("data modified".equals(name) || "data changed".equals(name)) && !this.equals(this.puDataObject.getActiveMultiViewElement0())) {
            this.needInit = true;
        } else if ("non ui pu classes modified".equals(name) && this.equals(this.puDataObject.getActiveMultiViewElement0())) {
            org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit pu;
            org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit = pu = evt.getNewValue() instanceof org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit ? (org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit)evt.getNewValue() : null;
            if (pu != null) {
                SectionContainer sc = this.view.getPersistenceUnitsCont();
                SectionContainerNode sn = (SectionContainerNode)sc.getNode();
                Children ch = sn.getChildren();
                Node mainPUNode = null;
                for (Node n : ch.getNodes()) {
                    PersistenceUnitNode pun = (PersistenceUnitNode)n;
                    String pusecname = pun.getDisplayName();
                    if (!pusecname.equals(pu.getName())) continue;
                    mainPUNode = pun.getChildren().getNodes()[0];
                    break;
                }
                if (mainPUNode == null) {
                    this.needInit = true;
                } else {
                    NodeSectionPanel nsp = sc.getSection(mainPUNode);
                    SectionPanel sp = nsp != null && nsp instanceof SectionPanel ? (SectionPanel)nsp : null;
                    PersistenceUnitPanel up = (PersistenceUnitPanel)(sp != null && sp.getInnerPanel() != null && sp.getInnerPanel() instanceof PersistenceUnitPanel ? sp.getInnerPanel() : null);
                    if (up != null) {
                        up.initEntityList();
                    } else {
                        this.needInit = true;
                    }
                }
            } else {
                this.needInit = true;
            }
        }
    }

    private void validateUnitName(PersistenceUnitWizardPanel panel) {
        try {
            if (!panel.isNameUnique()) {
                panel.setErrorMessage(NbBundle.getMessage(PersistenceUnitWizardDescriptor.class, (String)"ERR_PersistenceUnitNameNotUnique"));
            } else {
                panel.setErrorMessage(null);
            }
        }
        catch (InvalidPersistenceXmlException ipx) {
            panel.setErrorMessage(NbBundle.getMessage(PersistenceUnitWizardDescriptor.class, (String)"ERR_InvalidPersistenceXml", (Object)ipx.getPath()));
        }
    }

    private class RemoveAction
    extends AbstractAction {
        RemoveAction(String actionName) {
            super(actionName);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JButton but = (JButton)evt.getSource();
            SectionContainer sc = null;
            for (Container c = but.getParent(); c != null; c = c.getParent()) {
                if (!(c instanceof SectionContainer)) continue;
                sc = (SectionContainer)c;
                break;
            }
            PersistenceUnitNode pun = (PersistenceUnitNode)sc.getNode();
            org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit punit = pun.getPersistenceUnit();
            ConfirmDialog desc = new ConfirmDialog(NbBundle.getMessage(PersistenceToolBarMVElement.class, (String)"LBL_ConfirmRemove", (Object)punit.getName()));
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)desc);
            dialog.setVisible(true);
            if (DialogDescriptor.OK_OPTION.equals(desc.getValue())) {
                sc.removeSection((NodeSectionPanel)sc);
                PersistenceToolBarMVElement.this.puDataObject.removePersistenceUnit(punit);
            }
        }

        @Override
        public boolean isEnabled() {
            boolean disable = PersistenceToolBarMVElement.this.puDataObject.getPersistence().sizePersistenceUnit() <= 1 && Double.parseDouble(PersistenceToolBarMVElement.this.puDataObject.getPersistence().getVersion()) >= Double.parseDouble("2.0");
            return !disable;
        }
    }

    private class AddAction
    extends AbstractAction {
        AddAction(String actionName) {
            super(actionName);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object result;
            boolean isContainer = Util.isSupportedJavaEEVersion(PersistenceToolBarMVElement.this.project);
            final PersistenceUnitWizardPanel panel = isContainer && ProviderUtil.isValidServerInstanceOrNone(PersistenceToolBarMVElement.this.project) ? new PersistenceUnitWizardPanelDS(PersistenceToolBarMVElement.this.project, null, true) : new PersistenceUnitWizardPanelJdbc(PersistenceToolBarMVElement.this.project, null, true);
            final NotifyDescriptor nd = new NotifyDescriptor((Object)new WrapperPanel(panel), NbBundle.getMessage(PersistenceToolBarMVElement.class, (String)"LBL_NewPersistenceUnit"), 2, -1, null, null);
            panel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Object newvalue;
                    if (evt.getPropertyName().equals("PersistenceUnitWizardPanel_isValid") && (newvalue = evt.getNewValue()) != null && newvalue instanceof Boolean) {
                        PersistenceToolBarMVElement.this.validateUnitName(panel);
                        nd.setValid(((Boolean)newvalue).booleanValue());
                    }
                }
            });
            if (!panel.isValidPanel()) {
                PersistenceToolBarMVElement.this.validateUnitName(panel);
                nd.setValid(false);
            }
            if ((result = DialogDisplayer.getDefault().notify(nd)) == NotifyDescriptor.OK_OPTION) {
                Library mLib;
                org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit punit;
                String version = PersistenceToolBarMVElement.this.puDataObject.getPersistence().getVersion();
                boolean useModelgen = false;
                String modelGenLib = null;
                if ("2.1".equals(version)) {
                    useModelgen = true;
                    punit = new PersistenceUnit();
                } else if ("2.0".equals(version)) {
                    useModelgen = true;
                    punit = new org.netbeans.modules.j2ee.persistence.dd.persistence.model_2_0.PersistenceUnit();
                } else {
                    punit = new org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit();
                }
                if (isContainer) {
                    Library lib;
                    PersistenceUnitWizardPanelDS puPanel = (PersistenceUnitWizardPanelDS)panel;
                    if (puPanel.getDatasource() != null && !"".equals(puPanel.getDatasource().trim())) {
                        if (puPanel.isJTA()) {
                            punit.setJtaDataSource(puPanel.getDatasource());
                        } else {
                            punit.setNonJtaDataSource(puPanel.getDatasource());
                            punit.setTransactionType("RESOURCE_LOCAL");
                        }
                    }
                    Provider provider = puPanel.getSelectedProvider();
                    if (puPanel.isNonDefaultProviderEnabled()) {
                        punit.setProvider(puPanel.getNonDefaultProvider());
                        lib = PersistenceLibrarySupport.getLibrary(provider);
                        if (lib != null && !Util.isDefaultProvider(PersistenceToolBarMVElement.this.project, provider)) {
                            Util.addLibraryToProject(PersistenceToolBarMVElement.this.project, lib);
                            modelGenLib = lib.getName() + "modelgen";
                            provider = null;
                        }
                    }
                    if (provider != null && provider.getAnnotationProcessor() != null && (lib = PersistenceLibrarySupport.getLibrary(provider)) != null) {
                        Util.addLibraryToProject(PersistenceToolBarMVElement.this.project, lib, "classpath/processor");
                        modelGenLib = lib.getName() + "modelgen";
                    }
                } else {
                    Library lib;
                    PersistenceUnitWizardPanelJdbc puJdbc = (PersistenceUnitWizardPanelJdbc)panel;
                    punit = ProviderUtil.buildPersistenceUnit(puJdbc.getPersistenceUnitName(), puJdbc.getSelectedProvider(), puJdbc.getPersistenceConnection(), version);
                    punit.setTransactionType("RESOURCE_LOCAL");
                    if (!Util.isJavaSE(PersistenceToolBarMVElement.this.project)) {
                        punit.setExcludeUnlistedClasses(false);
                    }
                    if ((lib = PersistenceLibrarySupport.getLibrary(puJdbc.getSelectedProvider())) != null) {
                        Util.addLibraryToProject(PersistenceToolBarMVElement.this.project, lib);
                        modelGenLib = lib.getName() + "modelgen";
                    }
                    JDBCDriver[] driver = JDBCDriverManager.getDefault().getDrivers(puJdbc.getPersistenceConnection().getDriverClass());
                    PersistenceLibrarySupport.addDriver(PersistenceToolBarMVElement.this.project, driver[0]);
                }
                punit.setName(panel.getPersistenceUnitName());
                ProviderUtil.setTableGeneration(punit, panel.getTableGeneration(), PersistenceToolBarMVElement.this.project);
                PersistenceToolBarMVElement.this.puDataObject.addPersistenceUnit(punit);
                PersistenceToolBarMVElement.this.comp.setLastActive((Object)punit);
                if (useModelgen && modelGenLib != null && (mLib = LibraryManager.getDefault().getLibrary(modelGenLib)) != null) {
                    Util.addLibraryToProject(PersistenceToolBarMVElement.this.project, mLib, "classpath/processor");
                }
            }
        }
    }

    private class ModelListener
    implements PropertyChangeListener {
        private ModelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!PersistenceToolBarMVElement.this.puDataObject.isChangedFromUI()) {
                MultiViewPerspective selectedPerspective = PersistenceToolBarMVElement.this.dObj.getSelectedPerspective();
                if (selectedPerspective != null && "persistence_multiview_design".equals(selectedPerspective.preferredID())) {
                    PersistenceToolBarMVElement.this.repaintingTask.schedule(100);
                } else {
                    PersistenceToolBarMVElement.this.needInit = true;
                }
            }
        }
    }

    private static class ElementLeafNode
    extends AbstractNode {
        ElementLeafNode(String displayName) {
            super(Children.LEAF);
            this.setDisplayName(displayName);
        }

        public HelpCtx getHelpCtx() {
            return null;
        }
    }

    private static class PersistenceUnitNode
    extends AbstractNode {
        org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit pu;

        PersistenceUnitNode(Children children, org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit persistenceUnit) {
            super(children);
            this.setDisplayName(persistenceUnit.getName());
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/persistence/unit/PersistenceIcon.gif");
            this.pu = persistenceUnit;
        }

        org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit getPersistenceUnit() {
            return this.pu;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("persistence_multiview_design_persistenceUnitNode");
        }
    }

    private class PersistenceView
    extends SectionView {
        private SectionContainer persistenceUnitsCont;
        private Node persistenceUnitsNode;

        public SectionContainer getPersistenceUnitsCont() {
            return this.persistenceUnitsCont;
        }

        public Node getPersistenceUnitsNode() {
            return this.persistenceUnitsNode;
        }

        PersistenceView() {
            super((InnerPanelFactory)PersistenceToolBarMVElement.this.factory);
        }

        void initialize(PUDataObject pudo) {
            Persistence persistence = pudo.getPersistence();
            org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit[] persistenceUnits = persistence.getPersistenceUnit();
            Node[] persistenceUnitNode = new Node[persistenceUnits.length];
            Children.Array ch = new Children.Array();
            for (int i = 0; i < persistenceUnits.length; ++i) {
                ElementLeafNode mainPUNode = new ElementLeafNode(NbBundle.getMessage(PersistenceToolBarMVElement.class, (String)"LBL_PU_General"));
                ElementLeafNode propertiesNode = new ElementLeafNode(NbBundle.getMessage(PersistenceToolBarMVElement.class, (String)"LBL_PU_Properties"));
                Children.Array puCh = new Children.Array();
                puCh.add(new Node[]{mainPUNode, propertiesNode});
                persistenceUnitNode[i] = new PersistenceUnitNode((Children)puCh, persistenceUnits[i]);
            }
            ch.add(persistenceUnitNode);
            this.persistenceUnitsNode = new SectionContainerNode((Children)ch);
            this.persistenceUnitsNode.setDisplayName(NbBundle.getMessage(PersistenceToolBarMVElement.class, (String)"LBL_PersistenceUnits"));
            this.persistenceUnitsCont = new SectionContainer((SectionView)this, this.persistenceUnitsNode, NbBundle.getMessage(PersistenceToolBarMVElement.class, (String)"LBL_PersistenceUnits"));
            this.persistenceUnitsCont.setHeaderActions(new Action[]{PersistenceToolBarMVElement.this.addAction});
            Children.Array rootChildren = new Children.Array();
            rootChildren.add(new Node[]{this.persistenceUnitsNode});
            AbstractNode root = new AbstractNode((Children)rootChildren);
            SectionContainer[] pan = new SectionContainer[persistenceUnits.length];
            for (int i = 0; i < persistenceUnits.length; ++i) {
                pan[i] = new SectionContainer((SectionView)this, persistenceUnitNode[i], persistenceUnitNode[i].getDisplayName(), false);
                pan[i].setHeaderActions(new Action[]{PersistenceToolBarMVElement.this.removeAction});
                this.persistenceUnitsCont.addSection((NodeSectionPanel)pan[i]);
                Node mainPUNode = persistenceUnitNode[i].getChildren().getNodes()[0];
                Node propertiesNode = persistenceUnitNode[i].getChildren().getNodes()[1];
                Provider prov = persistenceUnits[i].getProvider() != null ? ProviderUtil.getProvider(persistenceUnits[i]) : Util.getDefaultProvider(PersistenceToolBarMVElement.this.project);
                pan[i].addSection((NodeSectionPanel)new SectionPanel((SectionView)this, mainPUNode, mainPUNode.getDisplayName(), (Object)persistenceUnits[i], false, false));
                pan[i].addSection((NodeSectionPanel)new SectionPanel((SectionView)this, propertiesNode, propertiesNode.getDisplayName(), (Object)new PropertiesPanel.PropertiesParamHolder(persistenceUnits[i], prov), false, false));
            }
            this.addSection((NodeSectionPanel)this.persistenceUnitsCont);
            this.setRoot((Node)root);
        }

        public Error validateView() {
            PersistenceValidator validator = new PersistenceValidator((PUDataObject)PersistenceToolBarMVElement.this.dObj);
            List<Error> result = validator.validate();
            if (!result.isEmpty()) {
                return result.get(0);
            }
            return null;
        }
    }
}

