/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.export;

import java.io.IOException;
import java.io.Writer;
import javax.swing.table.TableModel;
import org.netbeans.modules.profiler.snaptracer.TracerProgressObject;
import org.netbeans.modules.profiler.snaptracer.impl.export.Exporter;

final class CSVExporter
extends Exporter {
    private static final String DELIMITER = ",";
    private float step = 1.0f;
    private int lastStep = 0;

    CSVExporter() {
    }

    @Override
    protected int getSteps(TableModel model) {
        int steps = model.getRowCount();
        if (steps > 300) {
            this.step = 300.0f / (float)steps;
            steps = 300;
        }
        return steps;
    }

    @Override
    protected void writeData(TableModel model, String title, Writer writer, TracerProgressObject progress) throws IOException {
        int columnsCount = model.getColumnCount();
        int rowsCount = model.getRowCount();
        for (int c = 0; c < columnsCount; ++c) {
            CSVExporter.write(writer, "\"" + model.getColumnName(c) + "\"");
            if (c >= columnsCount - 1) continue;
            CSVExporter.write(writer, DELIMITER);
        }
        CSVExporter.writeLine(writer);
        for (int r = 0; r < rowsCount; ++r) {
            for (int c = 0; c < columnsCount; ++c) {
                CSVExporter.write(writer, "\"" + model.getValueAt(r, c) + "\"");
                if (c >= columnsCount - 1) continue;
                CSVExporter.write(writer, DELIMITER);
            }
            CSVExporter.writeLine(writer);
            if (progress.isFinished()) break;
            if (this.step == 1.0f) {
                progress.addStep();
                continue;
            }
            int currentStep = (int)((float)r * this.step);
            if (currentStep <= this.lastStep) continue;
            progress.addStep();
            this.lastStep = currentStep;
        }
    }
}

