/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.ui.actions.Bundle;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;

public class SynchronizeAction
extends AbstractAction
implements ContextAwareAction {
    private final Collection<? extends HudsonInstance> instances;

    public SynchronizeAction() {
        this(Collections.emptySet());
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new SynchronizeAction(actionContext.lookupAll(HudsonInstance.class));
    }

    private SynchronizeAction(Collection<? extends HudsonInstance> instances) {
        this.instances = instances;
        boolean allForbidden = true;
        boolean allDisconnected = true;
        for (HudsonInstance hudsonInstance : instances) {
            if (!hudsonInstance.isForbidden()) {
                allForbidden = false;
            }
            if (!hudsonInstance.isConnected()) continue;
            allDisconnected = false;
        }
        if (allForbidden) {
            this.setEnabled(false);
            this.putValue("hideWhenDisabled", true);
        } else if (allDisconnected) {
            this.putValue("Name", Bundle.LBL_SynchronizeAction_disconnected());
        } else {
            this.putValue("Name", Bundle.LBL_SynchronizeAction());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (HudsonInstance hudsonInstance : this.instances) {
            hudsonInstance.synchronize(true);
        }
    }
}

