/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.discovery;

import org.logstash.plugins.discovery.AbstractScanner;
import org.logstash.plugins.discovery.FilterBuilder;

public class SubTypesScanner
extends AbstractScanner {
    public SubTypesScanner() {
        this(true);
    }

    public SubTypesScanner(boolean excludeObjectClass) {
        if (excludeObjectClass) {
            this.filterResultsBy(new FilterBuilder().exclude(Object.class.getName()));
        }
    }

    @Override
    public void scan(Object cls) {
        String className = this.getMetadataAdapter().getClassName(cls);
        String superclass = this.getMetadataAdapter().getSuperclassName(cls);
        if (this.acceptResult(superclass)) {
            this.getStore().put((Object)superclass, (Object)className);
        }
        for (String anInterface : this.getMetadataAdapter().getInterfacesNames(cls)) {
            if (!this.acceptResult(anInterface)) continue;
            this.getStore().put((Object)anInterface, (Object)className);
        }
    }
}

