/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

class CheckerFrameworkNullityUtil {
    @Nullable
    static NullabilityAnnotationInfo isCheckerDefault(PsiAnnotation anno, PsiAnnotation.TargetType[] types) {
        String qName = anno.getQualifiedName();
        if ("org.checkerframework.framework.qual.DefaultQualifier".equals(qName)) {
            PsiClass valueClass;
            PsiAnnotationMemberValue value = anno.findAttributeValue("value");
            if (value instanceof PsiClassObjectAccessExpression && CheckerFrameworkNullityUtil.hasAppropriateTarget(types, anno.findAttributeValue("locations")) && (valueClass = PsiUtil.resolveClassInClassTypeOnly(((PsiClassObjectAccessExpression)value).getOperand().getType())) != null) {
                NullableNotNullManager instance = NullableNotNullManager.getInstance(value.getProject());
                if (instance.getNullables().contains(valueClass.getQualifiedName())) {
                    return new NullabilityAnnotationInfo(anno, Nullability.NULLABLE, true);
                }
                if (instance.getNotNulls().contains(valueClass.getQualifiedName())) {
                    return new NullabilityAnnotationInfo(anno, Nullability.NULLABLE, true);
                }
            }
            return null;
        }
        if ("org.checkerframework.framework.qual.DefaultQualifiers".equals(qName)) {
            PsiAnnotationMemberValue value = anno.findAttributeValue("value");
            for (PsiAnnotationMemberValue initializer : AnnotationUtil.arrayAttributeValues(value)) {
                NullabilityAnnotationInfo result2;
                if (!(initializer instanceof PsiAnnotation) || (result2 = CheckerFrameworkNullityUtil.isCheckerDefault((PsiAnnotation)initializer, types)) == null) continue;
                return result2;
            }
        }
        return null;
    }

    private static boolean hasAppropriateTarget(PsiAnnotation.TargetType[] types, PsiAnnotationMemberValue locations) {
        Set<String> locationNames = ContainerUtil.map2SetNotNull(AnnotationUtil.arrayAttributeValues(locations), l -> l instanceof PsiReferenceExpression ? ((PsiReferenceExpression)l).getReferenceName() : null);
        if (locationNames.contains("ALL")) {
            return true;
        }
        for (PsiAnnotation.TargetType type2 : types) {
            if (type2 == PsiAnnotation.TargetType.FIELD) {
                return locationNames.contains("FIELD");
            }
            if (type2 == PsiAnnotation.TargetType.METHOD) {
                return locationNames.contains("RETURN");
            }
            if (type2 != PsiAnnotation.TargetType.PARAMETER) continue;
            return locationNames.contains("PARAMETER");
        }
        return false;
    }
}

