/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.J2SIgnoreImport;
import javajs.util.AU;
import javajs.util.BArray;
import javajs.util.BS;
import javajs.util.Base64;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import javajs.util.XmlUtil;
import org.jmol.adapter.writers.QCJSONWriter;
import org.jmol.api.Interface;
import org.jmol.api.JmolPropertyManager;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondSet;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.BioModel;
import org.jmol.script.SV;
import org.jmol.script.T;
import org.jmol.shape.Shape;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.viewer.ActionManager;
import org.jmol.viewer.AnimationManager;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;
import org.jmol.viewer.binding.Binding;

@J2SIgnoreImport(value={XmlUtil.class})
public class PropertyManager
implements JmolPropertyManager {
    Viewer vwr;
    private Map<String, Integer> map = new Hashtable<String, Integer>();
    private T3 vNorm;
    private T3 vTemp;
    private static final String atomExpression = "<atom selection>";
    private static final String[] propertyTypes = new String[]{"appletInfo", "", "", "fileName", "", "", "fileHeader", "", "", "fileContents", "<pathname>", "", "fileContents", "", "", "animationInfo", "", "", "modelInfo", "<atom selection>", "{*}", "ligandInfo", "<atom selection>", "{*}", "shapeInfo", "", "", "measurementInfo", "", "", "centerInfo", "", "", "orientationInfo", "", "", "transformInfo", "", "", "", "", "", "atomInfo", "<atom selection>", "(visible)", "bondInfo", "<atom selection>", "(visible)", "chainInfo", "<atom selection>", "(visible)", "polymerInfo", "<atom selection>", "(visible)", "moleculeInfo", "<atom selection>", "(visible)", "stateInfo", "<state type>", "all", "extractModel", "<atom selection>", "(visible)", "jmolStatus", "statusNameList", "", "jmolViewer", "", "", "messageQueue", "", "", "auxiliaryInfo", "<atom selection>", "{*}", "boundBoxInfo", "", "", "dataInfo", "<data type>", "types", "image", "<width=www,height=hhh>", "", "evaluate", "<expression>", "", "menu", "<type>", "current", "minimizationInfo", "", "", "pointGroupInfo", "<atom selection>", "(visible)", "fileInfo", "<type>", "", "errorMessage", "", "", "mouseInfo", "", "", "isosurfaceInfo", "", "", "isosurfaceData", "", "", "consoleText", "", "", "JSpecView", "<key>", "", "scriptQueueInfo", "", "", "nmrInfo", "<elementSymbol> or 'all' or 'shifts'", "all", "variableInfo", "<name>", "all", "domainInfo", "<atom selection>", "{visible}", "validationInfo", "<atom selection>", "{visible}", "service", "<hashTable>", "", "CIFInfo", "<filename>", "", "spacegroupInfo", "<name>", ""};
    private static final int PROP_APPLET_INFO = 0;
    private static final int PROP_FILENAME = 1;
    private static final int PROP_FILEHEADER = 2;
    private static final int PROP_FILECONTENTS_PATH = 3;
    private static final int PROP_FILECONTENTS = 4;
    private static final int PROP_ANIMATION_INFO = 5;
    private static final int PROP_MODEL_INFO = 6;
    private static final int PROP_LIGAND_INFO = 7;
    private static final int PROP_SHAPE_INFO = 8;
    private static final int PROP_MEASUREMENT_INFO = 9;
    private static final int PROP_CENTER_INFO = 10;
    private static final int PROP_ORIENTATION_INFO = 11;
    private static final int PROP_TRANSFORM_INFO = 12;
    private static final int PROP_ATOM_INFO = 14;
    private static final int PROP_BOND_INFO = 15;
    private static final int PROP_CHAIN_INFO = 16;
    private static final int PROP_POLYMER_INFO = 17;
    private static final int PROP_MOLECULE_INFO = 18;
    private static final int PROP_STATE_INFO = 19;
    private static final int PROP_EXTRACT_MODEL = 20;
    private static final int PROP_JMOL_STATUS = 21;
    private static final int PROP_JMOL_VIEWER = 22;
    private static final int PROP_MESSAGE_QUEUE = 23;
    private static final int PROP_AUXILIARY_INFO = 24;
    private static final int PROP_BOUNDBOX_INFO = 25;
    private static final int PROP_DATA_INFO = 26;
    private static final int PROP_IMAGE = 27;
    private static final int PROP_EVALUATE = 28;
    private static final int PROP_MENU = 29;
    private static final int PROP_MINIMIZATION_INFO = 30;
    private static final int PROP_POINTGROUP_INFO = 31;
    private static final int PROP_FILE_INFO = 32;
    private static final int PROP_ERROR_MESSAGE = 33;
    private static final int PROP_MOUSE_INFO = 34;
    private static final int PROP_ISOSURFACE_INFO = 35;
    private static final int PROP_ISOSURFACE_DATA = 36;
    private static final int PROP_CONSOLE_TEXT = 37;
    private static final int PROP_JSPECVIEW = 38;
    private static final int PROP_SCRIPT_QUEUE_INFO = 39;
    private static final int PROP_NMR_INFO = 40;
    private static final int PROP_VAR_INFO = 41;
    private static final int PROP_DOM_INFO = 42;
    private static final int PROP_VAL_INFO = 43;
    private static final int PROP_SERVICE = 44;
    private static final int PROP_CIF_INFO = 45;
    private static final int PROP_SPACEGROUP_INFO = 46;
    private static final int PROP_COUNT = 47;
    private static final String[] readableTypes = new String[]{"", "stateinfo", "extractmodel", "filecontents", "fileheader", "image", "menu", "minimizationInfo"};
    private int[] connections;
    private P3 ptTemp;

    @Override
    public void setViewer(Viewer viewer) {
        this.vwr = viewer;
        int n = 0;
        int n2 = 0;
        while (n < propertyTypes.length) {
            if (propertyTypes[n].length() > 0) {
                this.map.put(propertyTypes[n].toLowerCase(), n2);
            }
            n += 3;
            ++n2;
        }
    }

    @Override
    public int getPropertyNumber(String string) {
        Integer n = this.map.get(string == null ? "" : string.toLowerCase());
        return n == null ? -1 : n;
    }

    @Override
    public String getDefaultPropertyParam(int n) {
        return n < 0 ? "" : propertyTypes[n * 3 + 2];
    }

    @Override
    public boolean checkPropertyParameter(String string) {
        int n = this.getPropertyNumber(string);
        String string2 = PropertyManager.getParamType(n);
        return string2.length() > 0 && string2 != atomExpression;
    }

    @Override
    public Object getProperty(String string, String string2, Object object) {
        Object object2;
        if (propertyTypes.length != 141) {
            Logger.warn("propertyTypes is not the right length: " + propertyTypes.length + " != " + 141);
        }
        if (string2.indexOf(".") >= 0 || string2.indexOf("[") >= 0) {
            SV[] sVArray = this.getArguments(string2);
            object2 = this.extractProperty(this.getPropertyAsObject(sVArray[0].asString(), object, null), sVArray, 1, null, false);
        } else {
            object2 = this.getPropertyAsObject(string2, object, string);
        }
        if (string == null) {
            return object2;
        }
        boolean bl = string.equalsIgnoreCase("readable");
        if (bl) {
            String string3 = string = PropertyManager.isReadableAsString(string2) ? "String" : "JSON";
        }
        if (string.equalsIgnoreCase("String")) {
            return object2 == null ? "" : object2.toString();
        }
        if (bl) {
            return Escape.toReadable(string2, object2);
        }
        if (string.equalsIgnoreCase("JSON")) {
            return SV.safeJSON(string2, object2);
        }
        return object2;
    }

    /*
     * Unable to fully structure code
     */
    private SV[] getArguments(String var1_1) {
        var2_2 = var1_1.toLowerCase();
        var3_3 = -1;
        if (var1_1.indexOf(34) < 0 && var1_1.indexOf(39) < 0) ** GOTO lbl14
        var1_1 = this.fixSelectQuotes(var1_1);
        if (true) ** GOTO lbl14
        do {
            var4_4 = var2_2.indexOf(" where ", var3_3);
            var5_6 = var2_2.indexOf(" wherein ", var3_3);
            if (var5_6 > 0 && var5_6 < var4_4) {
                var4_4 = var5_6;
            }
            var6_8 = var2_2.lastIndexOf("]");
            if (var4_4 >= 0 && var4_4 <= var6_8) {
                var1_1 = String.valueOf(var1_1.substring(0, var3_3 + 1)) + var1_1.substring(var3_3 + 1, var6_8).replace('.', '\u0001').replace('[', '\u0002').replace(']', '\u0003') + var1_1.substring(var6_8);
            }
lbl14:
            // 5 sources

            ++var3_3;
        } while ((var3_3 = var2_2.indexOf("[select ", var3_3)) >= 0);
        var1_1 = PT.rep(PT.rep(var1_1.replace(']', '\u0000').replace('[', '\u0000'), "..", "\u0004").replace('.', '\u0000').replace('\u0001', '.').replace('\u0002', '[').replace('\u0003', ']'), "\u0004", "..");
        var1_1 = PT.rep(var1_1, "\u0000\u0000", "\u0000");
        var4_5 = PT.split(PT.trim(var1_1, "\u0000"), "\u0000");
        var5_7 = new SV[var4_5.length];
        var6_8 = 0;
        while (var6_8 < var4_5.length) {
            var5_7[var6_8] = var4_5[var6_8].startsWith("'") != false || var4_5[var6_8].startsWith("\"") != false ? SV.newS(PT.trim(var4_5[var6_8], "'\"")) : ((var7_9 = PT.parseInt(var4_5[var6_8])) == -2147483648 ? SV.newS(var4_5[var6_8]) : SV.newI(var7_9));
            ++var6_8;
        }
        return var5_7;
    }

    private String fixSelectQuotes(String string) {
        char[] cArray = string.toCharArray();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = cArray.length;
        while (--n >= 0) {
            switch (cArray[n]) {
                case '\'': {
                    if (bl3) break;
                    bl2 = !bl;
                    bl = bl2;
                    break;
                }
                case '\"': {
                    if (bl2) break;
                    bl3 = !bl;
                    bl = bl3;
                    break;
                }
                case '.': {
                    if (!bl) break;
                    cArray[n] = '\u0001';
                    break;
                }
                case '[': {
                    if (!bl) break;
                    cArray[n] = 2;
                    break;
                }
                case ']': {
                    if (!bl) break;
                    cArray[n] = 3;
                }
            }
        }
        string = new String(cArray);
        return string;
    }

    @Override
    public Object extractProperty(Object object, Object object2, int n, Lst<Object> lst, boolean bl) {
        if (n < 0) {
            object2 = this.getArguments((String)object2);
            n = 0;
        }
        if (n >= ((SV[])object2).length) {
            return object;
        }
        if (!bl) {
            object2 = this.compileSelect((SV[])object2);
        }
        SV sV = ((SV[])object2)[n++];
        Object object3 = SV.oValue(object);
        switch (sV.tok) {
            case 2: {
                int n2 = sV.intValue - 1;
                if (object3 instanceof Lst) {
                    Lst lst2 = (Lst)object3;
                    if (n2 < 0) {
                        n2 += lst2.size();
                    }
                    return n2 >= 0 && n2 < lst2.size() ? this.extractProperty(lst2.get(n2), object2, n, null, true) : "";
                }
                if (object3 instanceof M3) {
                    M3 m3 = (M3)object3;
                    float[][] fArrayArray = new float[][]{{m3.m00, m3.m01, m3.m02}, {m3.m10, m3.m11, m3.m12}, {m3.m20, m3.m21, m3.m22}};
                    if (n2 < 0) {
                        n2 += 3;
                    }
                    if (n2 >= 0 && n2 < 3) {
                        return this.extractProperty(fArrayArray, object2, --n, null, true);
                    }
                    return "";
                }
                if (object3 instanceof M4) {
                    M4 m4 = (M4)object3;
                    float[][] fArrayArray = new float[][]{{m4.m00, m4.m01, m4.m02, m4.m03}, {m4.m10, m4.m11, m4.m12, m4.m13}, {m4.m20, m4.m21, m4.m22, m4.m23}, {m4.m30, m4.m31, m4.m32, m4.m33}};
                    if (n2 < 0) {
                        n2 += 4;
                    }
                    if (n2 >= 0 && n2 < 4) {
                        return this.extractProperty(fArrayArray, object2, --n, null, true);
                    }
                    return "";
                }
                if (AU.isAI(object3)) {
                    int[] nArray = (int[])object3;
                    if (n2 < 0) {
                        n2 += nArray.length;
                    }
                    if (n2 >= 0 && n2 < nArray.length) {
                        return nArray[n2];
                    }
                    return "";
                }
                if (AU.isAD(object3)) {
                    double[] dArray = (double[])object3;
                    if (n2 < 0) {
                        n2 += dArray.length;
                    }
                    if (n2 >= 0 && n2 < dArray.length) {
                        return dArray[n2];
                    }
                    return "";
                }
                if (AU.isAF(object3)) {
                    float[] fArray = (float[])object3;
                    if (n2 < 0) {
                        n2 += fArray.length;
                    }
                    if (n2 >= 0 && n2 < fArray.length) {
                        return Float.valueOf(fArray[n2]);
                    }
                    return "";
                }
                if (AU.isAII(object3)) {
                    int[][] nArray = (int[][])object3;
                    if (n2 < 0) {
                        n2 += nArray.length;
                    }
                    if (n2 >= 0 && n2 < nArray.length) {
                        return this.extractProperty(nArray[n2], object2, n, null, true);
                    }
                    return "";
                }
                if (AU.isAFF(object3)) {
                    float[][] fArray = (float[][])object3;
                    if (n2 < 0) {
                        n2 += fArray.length;
                    }
                    if (n2 >= 0 && n2 < fArray.length) {
                        return this.extractProperty(fArray[n2], object2, n, null, true);
                    }
                    return "";
                }
                if (AU.isAS(object3)) {
                    String[] stringArray = (String[])object3;
                    if (n2 < 0) {
                        n2 += stringArray.length;
                    }
                    if (n2 >= 0 && n2 < stringArray.length) {
                        return stringArray[n2];
                    }
                    return "";
                }
                if (!(object3 instanceof Object[])) break;
                Object[] objectArray = (Object[])object3;
                if (n2 < 0) {
                    n2 += objectArray.length;
                }
                if (n2 >= 0 && n2 < objectArray.length) {
                    return objectArray[n2];
                }
                return "";
            }
            case 4: 
            case 1275082245: {
                if (object3 instanceof Map) {
                    boolean bl2;
                    int n3;
                    Object object4;
                    boolean bl3;
                    String string;
                    Map map = (Map)object3;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    Lst lst3 = sV.tok == 1275082245 ? (Lst)((Object[])sV.value)[0] : null;
                    T[] tArray = null;
                    if (sV.tok == 1275082245) {
                        bl6 = true;
                        tArray = (T[])((Object[])sV.value)[1];
                        string = sV.myName;
                        boolean bl7 = bl5 = string.indexOf(";") >= 0;
                        if (string.contains("**")) {
                            bl3 = lst3.size() == 0;
                            String string2 = "";
                            for (Map.Entry entry : map.entrySet()) {
                                object4 = (String)entry.getKey();
                                n3 = bl3 ? 1 : lst3.size();
                                while (--n3 >= 0) {
                                    if (!bl3 && !PT.isLike((String)object4, (String)lst3.get(n3))) continue;
                                    Object object5 = entry.getValue();
                                    boolean bl8 = false;
                                    switch (object5 instanceof SV ? ((SV)object5).tok : 0) {
                                        case 7: {
                                            bl8 = true;
                                            object5 = ((SV)object5).getList();
                                            break;
                                        }
                                        case 6: 
                                        case 14: {
                                            object5 = ((SV)object5).getMap();
                                            break;
                                        }
                                        default: {
                                            if (object5 instanceof Map || (bl8 = object5 instanceof Lst)) break;
                                            object5 = null;
                                        }
                                    }
                                    if (object5 == null) continue;
                                    if (bl8) {
                                        if (lst == null) {
                                            lst = new Lst();
                                        }
                                        Lst lst4 = (Lst)object5;
                                        int n4 = lst4.size();
                                        int n5 = 0;
                                        while (n5 < n4) {
                                            object5 = lst4.get(n5);
                                            if (object5 instanceof SV && (object5 = ((SV)object5).getMap()) != null && (tArray == null || this.vwr.checkSelect((Map)object5, tArray))) {
                                                lst.addLast(object5);
                                            }
                                            ++n5;
                                        }
                                        return lst;
                                    }
                                    if (tArray != null && !this.vwr.checkSelect((Map)object5, tArray)) continue;
                                    string2 = String.valueOf(string2) + "," + (String)object4;
                                }
                            }
                            if (string2.length() == 0) {
                                return new Lst();
                            }
                            string = string2.substring(1);
                            bl4 = !bl5;
                            lst3 = null;
                        } else if (tArray != null && !this.vwr.checkSelect((Map)object3, tArray)) {
                            return "";
                        }
                    } else {
                        string = sV.asString();
                        if (string.equalsIgnoreCase("keys")) {
                            Lst<String> lst5 = new Lst<String>();
                            for (String string3 : map.keySet()) {
                                lst5.addLast(string3);
                            }
                            return this.extractProperty(lst5, object2, n, null, true);
                        }
                    }
                    boolean bl8 = bl3 = bl5 || string.indexOf(",") >= 0 || string.indexOf(";") >= 0;
                    if (bl6 && !bl3) {
                        bl3 = true;
                        string = String.valueOf(string) + ",";
                    }
                    boolean bl10 = bl5 || string.startsWith("*") || string.endsWith("*") || bl3;
                    boolean bl9 = bl2 = lst != null;
                    if (bl10) {
                        if (!bl2) {
                            lst = new Lst();
                        }
                        if (!bl5 && (lst3 == null ? string.length() == 1 : lst3.size() == 0)) {
                            if (n == ((SV[])object2).length) {
                                if (!bl2) {
                                    return object3;
                                }
                                lst.addLast(object3);
                                return lst;
                            }
                            return this.extractProperty(object3, object2, n, lst, true);
                        }
                    }
                    if (string.contains("**")) {
                        string = PT.rep(string, "**", "*");
                    }
                    if (bl10 && !bl3) {
                        string = String.valueOf(string) + ",";
                    }
                    if (bl4 || bl5 || string.contains(",")) {
                        Hashtable hashtable = new Hashtable();
                        if (lst3 != null && lst3.size() == 0) {
                            lst3 = null;
                            string = "*";
                        }
                        if (lst3 == null) {
                            object4 = PT.split(string, ",");
                            n3 = ((String[])object4).length;
                            while (--n3 >= 0) {
                                PropertyManager.getMapSubset(map, object4[n3], hashtable, bl5 ? lst : null);
                            }
                        } else {
                            int n6 = lst3.size();
                            while (--n6 >= 0) {
                                PropertyManager.getMapSubset(map, (String)lst3.get(n6), hashtable, bl5 ? lst : null);
                            }
                        }
                        if (bl4 && !bl2) {
                            return hashtable;
                        }
                        if (n == ((SV[])object2).length) {
                            if (!bl5) {
                                if (!bl2) {
                                    return hashtable;
                                }
                                lst.addLast(hashtable);
                            }
                            return lst;
                        }
                        return this.extractProperty(hashtable, object2, n, bl2 ? lst : null, true);
                    }
                    return (string = this.checkMap(map, string, bl10, lst, object2, n, bl6)) != null && !bl10 ? this.extractProperty(map.get(string), object2, n, null, true) : (!bl10 ? "" : (bl2 ? lst : lst));
                }
                if (!(object3 instanceof Lst)) break;
                Lst lst6 = (Lst)object3;
                if (lst == null) {
                    lst = new Lst();
                }
                --n;
                int n7 = 0;
                while (n7 < lst6.size()) {
                    Object e = lst6.get(n7);
                    if (e instanceof Map || e instanceof Lst || e instanceof SV && (((SV)e).getMap() != null || ((SV)e).getList() != null)) {
                        this.extractProperty(e, object2, n, lst, true);
                    }
                    ++n7;
                }
                return lst;
            }
        }
        return object;
    }

    private static void getMapSubset(Map<String, ?> map, String string, Map<String, Object> map2, Lst<Object> lst) {
        Object obj;
        if (string.startsWith("\"") || string.startsWith("'")) {
            string = PT.trim(string, "\"'");
        }
        if ((obj = map.get(string)) != null) {
            if (lst == null) {
                map2.put(string, obj);
            } else {
                lst.addLast(obj);
            }
            return;
        }
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String string2 = entry.getKey();
            if (!PT.isLike(string2, string)) continue;
            if (lst == null) {
                map2.put(string2, entry.getValue());
                continue;
            }
            lst.addLast(entry.getValue());
        }
    }

    private Object compileSelect(SV[] sVArray) {
        SV[] sVArray2 = null;
        int n = sVArray.length;
        while (--n >= 0) {
            String string;
            String string2;
            int n2;
            if (sVArray[n].tok != 4) continue;
            String string3 = (String)sVArray[n].value;
            String string4 = string3.toUpperCase();
            if (string4.startsWith("WHERE")) {
                string3 = "SELECT * " + string3;
                string4 = string3.toUpperCase();
            }
            if (!string4.startsWith("SELECT ")) continue;
            if (sVArray2 == null) {
                sVArray2 = (SV[])AU.arrayCopyObject(sVArray, sVArray.length);
            }
            if ((string4 = (string3 = string3.substring(6).trim()).toUpperCase()).startsWith("WHERE ") || string4.startsWith("WHEREIN ")) {
                string3 = "* " + string3;
                string4 = string3.toUpperCase();
            }
            String string5 = (n2 = string4.indexOf(" WHEREIN ")) < 0 ? "" : (string2 = string3.indexOf(";") >= 0 ? ";**" : ",**");
            if (n2 < 0) {
                n2 = string4.indexOf(" WHERE ");
            }
            if ((string = string3.substring(0, n2 < 0 ? string3.length() : n2).trim()).startsWith("(") && string.endsWith(")")) {
                string = String.valueOf(string.substring(1, string.length() - 1)) + ";";
            }
            if (n2 < 0) {
                Object[] objectArray = new Object[2];
                objectArray[0] = this.getKeys(string);
                sVArray2[n] = SV.newV(1275082245, objectArray);
                sVArray2[n].myName = string;
                continue;
            }
            string = String.valueOf(string) + string2;
            sVArray2[n] = SV.newV(1275082245, new Object[]{this.getKeys(string), this.vwr.compileExpr(string3.substring(n2 + 6 + string2.length()).trim())});
            sVArray2[n].myName = string;
        }
        return sVArray2 == null ? sVArray : sVArray2;
    }

    private Lst<String> getKeys(String string) {
        Lst<String> lst = new Lst<String>();
        string = String.valueOf(PT.rep(PT.rep(string, "**", "*"), ";", ",")) + ",";
        int n = 0;
        int n2 = -1;
        while ((n2 = string.indexOf(",", n2 + 1)) >= 0) {
            if (n2 <= n) continue;
            String string2 = string.substring(n, n2);
            if (string2.equals("*")) {
                if (lst.size() != 0) continue;
                return lst;
            }
            lst.addLast(string2);
            n = n2 + 1;
        }
        return lst;
    }

    private String checkMap(Map<String, ?> map, String string, boolean bl, Lst<Object> lst, Object object, int n, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = lst == null && map.containsKey(string);
        if (!bl3) {
            boolean bl5 = string.contains(";");
            String[] stringArray = bl5 ? PT.split(string, ";") : null;
            String string2 = bl && !bl2 ? string.toLowerCase() : null;
            for (String string3 : map.keySet()) {
                if (bl5) {
                    int n2 = stringArray.length;
                    while (--n2 >= 0) {
                        string = stringArray[n2];
                        if (string.length() != 0) {
                            if (bl2) {
                                if (PT.isLike(string3, string)) break;
                            } else {
                                String string4 = string2 = string.indexOf("*") >= 0 ? string.toLowerCase() : null;
                                if (this.checkKey(string3, string, string2)) break;
                            }
                        }
                        string = null;
                    }
                    if (string == null) {
                        continue;
                    }
                } else if (!bl2 ? !this.checkKey(string3, string, string2) : !PT.isLike(string3, string)) continue;
                if (lst == null) {
                    return string3;
                }
                lst.addLast(this.extractProperty(map.get(string3), object, n, null, true));
                if (bl || bl5) continue;
                return null;
            }
        }
        return bl3 ? string : null;
    }

    private boolean checkKey(String string, String string2, String string3) {
        return string.equalsIgnoreCase(string2) || string3 != null && PT.isLike(string.toLowerCase(), string3);
    }

    private static String getPropertyName(int n) {
        return n < 0 ? "" : propertyTypes[n * 3];
    }

    private static String getParamType(int n) {
        return n < 0 ? "" : propertyTypes[n * 3 + 1];
    }

    private static boolean isReadableAsString(String string) {
        int n = readableTypes.length;
        while (--n >= 0) {
            if (!string.equalsIgnoreCase(readableTypes[n])) continue;
            return true;
        }
        return false;
    }

    private Object getPropertyAsObject(String string, Object object, String string2) {
        if (string.equals("tokenList")) {
            return T.getTokensLike((String)object);
        }
        int n = this.getPropertyNumber(string);
        boolean bl = object != null && object.toString().length() > 0;
        Object object2 = bl ? object : this.getDefaultPropertyParam(n);
        switch (n) {
            case 0: {
                return this.getAppletInfo();
            }
            case 5: {
                return this.getAnimationInfo();
            }
            case 14: {
                return this.getAllAtomInfo(this.vwr.getAtomBitSet(object2));
            }
            case 24: {
                return this.vwr.getAuxiliaryInfoForAtoms(object2);
            }
            case 15: {
                return this.getAllBondInfo(object2);
            }
            case 25: {
                return this.getBoundBoxInfo();
            }
            case 10: {
                return this.vwr.tm.fixedRotationCenter;
            }
            case 16: {
                return this.getAllChainInfo(this.vwr.getAtomBitSet(object2));
            }
            case 37: {
                return this.vwr.getProperty("DATA_API", "consoleText", null);
            }
            case 26: {
                return this.vwr.getDataObj(object2.toString(), null, -1);
            }
            case 33: {
                return this.vwr.getErrorMessageUn();
            }
            case 28: {
                return this.vwr.evaluateExpression(object2.toString());
            }
            case 20: {
                return this.vwr.getModelExtract(object2, true, false, "MOL");
            }
            case 32: {
                return PropertyManager.getFileInfo(this.vwr.getFileData(), object2.toString());
            }
            case 45: {
                return this.vwr.readCifData(object2.toString(), null);
            }
            case 1: {
                return this.vwr.fm.getFullPathName(false);
            }
            case 2: {
                return this.vwr.getFileHeader();
            }
            case 3: 
            case 4: {
                return bl ? this.vwr.getFileAsString3(object2.toString(), true, null) : this.vwr.getCurrentFileAsString("prop");
            }
            case 27: {
                String string3 = object2.toString().toLowerCase();
                return this.getImage(string3, string3.indexOf("g64") < 0 && string3.indexOf("base64") < 0 && (string2 == null || string2.equalsIgnoreCase("java")));
            }
            case 35: {
                return this.vwr.getShapeProperty(24, "info");
            }
            case 36: {
                return this.vwr.getShapeProperty(24, "data");
            }
            case 40: {
                return this.vwr.getNMRCalculation().getInfo(object2.toString());
            }
            case 41: {
                return this.getVariables(object2.toString());
            }
            case 21: {
                return this.vwr.getStatusChanged(object2.toString());
            }
            case 22: {
                return this.vwr;
            }
            case 38: {
                return this.vwr.getJspecViewProperties(object2);
            }
            case 7: {
                return this.getLigandInfo(this.vwr.getAtomBitSet(object2));
            }
            case 9: {
                return this.getMeasurementInfo();
            }
            case 29: {
                return this.vwr.getMenu(object2.toString());
            }
            case 23: {
                return this.vwr.sm.messageQueue;
            }
            case 30: {
                return this.vwr.getMinimizationInfo();
            }
            case 6: {
                return this.getModelInfo(this.vwr.getAtomBitSet(object2));
            }
            case 18: {
                return this.getMoleculeInfo(this.vwr.getAtomBitSet(object2));
            }
            case 34: {
                return this.getMouseInfo();
            }
            case 11: {
                return this.vwr.tm.getOrientationInfo();
            }
            case 31: {
                return this.vwr.ms.getPointGroupInfo(this.vwr.getAtomBitSet(object2));
            }
            case 17: {
                return this.getAllPolymerInfo(this.vwr.getAtomBitSet(object2));
            }
            case 39: {
                return this.vwr.getScriptQueueInfo();
            }
            case 8: {
                return this.getShapeInfo();
            }
            case 19: {
                return this.vwr.getStateInfo3(object2.toString(), 0, 0);
            }
            case 12: {
                return M3.newM3(this.vwr.tm.matrixRotate);
            }
            case 42: {
                return this.getAnnotationInfo(object2, 1073741925);
            }
            case 43: {
                return this.getAnnotationInfo(object2, 1073742189);
            }
            case 46: {
                return this.getSpaceGroupInfo(object2);
            }
            case 44: {
                object2 = SV.oValue(object2);
                Map map = object2 instanceof Map ? (Map)object2 : null;
                return map == null ? null : this.vwr.sm.processService(map);
            }
        }
        Object[] objectArray = new String[47];
        int n2 = 0;
        while (n2 < 47) {
            String string4 = PropertyManager.getParamType(n2);
            String string5 = this.getDefaultPropertyParam(n2);
            String string6 = PropertyManager.getPropertyName(n2);
            objectArray[n2] = string6.length() == 0 || string6.charAt(0) == 'X' ? "" : String.valueOf(string6) + (string4 != "" ? " " + PropertyManager.getParamType(n2) + (string5 != "" ? " #default: " + this.getDefaultPropertyParam(n2) : "") : "");
            ++n2;
        }
        Arrays.sort(objectArray);
        SB sB = new SB();
        sB.append("getProperty ERROR\n").append(string).append("?\nOptions include:\n");
        int n3 = 0;
        while (n3 < 47) {
            if (((String)objectArray[n3]).length() > 0) {
                sB.append("\n getProperty ").append((String)objectArray[n3]);
            }
            ++n3;
        }
        return sB.toString();
    }

    private Object getSpaceGroupInfo(Object object) {
        return this.vwr.getSymTemp().getSpaceGroupInfo(this.vwr.ms, object.toString(), -1, true);
    }

    private Object getImage(String string, boolean bl) {
        int n = -1;
        int n2 = -1;
        int n3 = string.indexOf("height=");
        if (n3 >= 0) {
            n = PT.parseInt(string.substring(n3 + 7));
        }
        if ((n3 = string.indexOf("width=")) >= 0) {
            n2 = PT.parseInt(string.substring(n3 + 6));
        }
        if (n2 < 0 && n < 0) {
            n2 = -1;
            n = -1;
        } else if (n2 < 0) {
            n2 = n;
        } else {
            n = n2;
        }
        String string2 = "JPG";
        if (string.indexOf("type=") >= 0) {
            string2 = PT.getTokens(PT.replaceWithCharacter(string.substring(string.indexOf("type=") + 5), ";,", ' '))[0];
        }
        String[] stringArray = new String[1];
        byte[] byArray = this.vwr.getImageAsBytes(string2.toUpperCase(), n2, n, -1, stringArray);
        return stringArray[0] != null ? stringArray[0] : (bl ? new BArray(byArray) : Base64.getBase64(byArray).toString());
    }

    private Object getVariables(String string) {
        return string.toLowerCase().equals("all") ? this.vwr.g.getAllVariables() : this.vwr.evaluateExpressionAsVariable(string);
    }

    static Object getFileInfo(Object object, String string) {
        boolean bl;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (object == null) {
            return hashtable;
        }
        boolean bl2 = bl = string != null && string.length() > 0;
        if (object instanceof Map) {
            return bl ? ((Map)object).get(string) : object;
        }
        String[] stringArray = PT.split((String)object, "\n");
        if (stringArray.length == 0 || stringArray[0].length() < 6 || stringArray[0].charAt(6) != ' ' || !stringArray[0].substring(0, 6).equals(stringArray[0].substring(0, 6).toUpperCase())) {
            hashtable.put("fileHeader", (String)object);
            return hashtable;
        }
        String string2 = "";
        SB sB = new SB();
        if (bl) {
            string = string.toUpperCase();
        }
        String string3 = "";
        int n = 0;
        while (n < stringArray.length) {
            String string4 = stringArray[n];
            if (string4.length() >= 12) {
                string3 = string4.substring(0, 6).trim();
                String string5 = string4.substring(7, 10).trim();
                if (string3.equals("REMARK")) {
                    string3 = String.valueOf(string3) + string5;
                }
                if (!string3.equals(string2)) {
                    if (bl && string2.equals(string)) {
                        return sB.toString();
                    }
                    if (!bl) {
                        hashtable.put(string2, sB.toString());
                        sB = new SB();
                    }
                    string2 = string3;
                }
                if (!bl || string3.equals(string)) {
                    sB.append(string4).appendC('\n');
                }
            }
            ++n;
        }
        if (!bl) {
            hashtable.put(string2, sB.toString());
        }
        if (bl) {
            return string3.equals(string) ? sB.toString() : "";
        }
        return hashtable;
    }

    public Lst<Map<String, Object>> getMoleculeInfo(Object object) {
        BS bS = this.vwr.getAtomBitSet(object);
        JmolMolecule[] jmolMoleculeArray = this.vwr.ms.getMolecules();
        Lst<Map<String, Object>> lst = new Lst<Map<String, Object>>();
        BS bS2 = new BS();
        int n = 0;
        while (n < jmolMoleculeArray.length) {
            bS2 = BSUtil.copy(bS);
            JmolMolecule jmolMolecule = jmolMoleculeArray[n];
            bS2.and(jmolMolecule.atomList);
            if (bS2.length() > 0) {
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                hashtable.put("mf", jmolMolecule.getMolecularFormula(true, null, false));
                hashtable.put("number", jmolMolecule.moleculeIndex + 1);
                hashtable.put("modelNumber", this.vwr.ms.getModelNumberDotted(jmolMolecule.modelIndex));
                hashtable.put("numberInModel", jmolMolecule.indexInModel + 1);
                hashtable.put("nAtoms", jmolMolecule.ac);
                hashtable.put("nElements", jmolMolecule.nElements);
                lst.addLast((Map<String, Object>)hashtable);
            }
            ++n;
        }
        return lst;
    }

    @Override
    public Map<String, Object> getModelInfo(Object object) {
        BS bS = this.vwr.ms.getModelBS(this.vwr.getAtomBitSet(object), false);
        ModelSet modelSet = this.vwr.ms;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("modelSetName", modelSet.modelSetName);
        hashtable.put("modelIndex", this.vwr.am.cmi);
        hashtable.put("modelCount", modelSet.mc);
        hashtable.put("isTainted", modelSet.tainted != null);
        hashtable.put("canSkipLoad", modelSet.canSkipLoad);
        hashtable.put("modelSetHasVibrationVectors", modelSet.modelSetHasVibrationVectors());
        if (modelSet.modelSetProperties != null) {
            hashtable.put("modelSetProperties", modelSet.modelSetProperties);
        }
        hashtable.put("modelCountSelected", bS.cardinality());
        hashtable.put("modelsSelected", bS);
        Lst lst = new Lst();
        modelSet.getMolecules();
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            Float f;
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            hashtable2.put("_ipt", n);
            hashtable2.put("num", modelSet.getModelNumber(n));
            hashtable2.put("file_model", modelSet.getModelNumberDotted(n));
            hashtable2.put("name", modelSet.getModelName(n));
            String string = modelSet.getModelTitle(n);
            if (string != null) {
                hashtable2.put("title", string);
            }
            if ((string = modelSet.getModelFileName(n)) != null) {
                hashtable2.put("file", string);
            }
            if ((string = (String)modelSet.getInfo(n, "modelID")) != null) {
                hashtable2.put("id", string);
            }
            hashtable2.put("vibrationVectors", this.vwr.modelHasVibrationVectors(n));
            Model model = modelSet.am[n];
            hashtable2.put("atomCount", model.act);
            hashtable2.put("bondCount", model.getBondCount());
            hashtable2.put("groupCount", model.getGroupCount());
            hashtable2.put("moleculeCount", model.moleculeCount);
            if (model.isBioModel) {
                hashtable2.put("polymerCount", ((BioModel)model).getBioPolymerCount());
            }
            hashtable2.put("chainCount", modelSet.getChainCountInModelWater(n, true));
            if (model.properties != null) {
                hashtable2.put("modelProperties", model.properties);
            }
            if ((f = (Float)modelSet.getInfo(n, "Energy")) != null) {
                hashtable2.put("energy", f);
            }
            hashtable2.put("atomCount", model.act);
            lst.addLast(hashtable2);
            n = bS.nextSetBit(n + 1);
        }
        hashtable.put("models", lst);
        return hashtable;
    }

    @Override
    public Map<String, Object> getLigandInfo(Object object) {
        BS bS = this.vwr.getAtomBitSet(object);
        BS bS2 = this.vwr.getAtomBitSet("solvent");
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Lst lst = new Lst();
        hashtable.put("ligands", lst);
        ModelSet modelSet = this.vwr.ms;
        BS bS3 = BSUtil.copyInvert(bS, modelSet.ac);
        bS3.or(bS2);
        Node[] nodeArray = modelSet.at;
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            if (nodeArray[n].group.isProtein() || nodeArray[n].group.isDna() || nodeArray[n].group.isRna()) {
                nodeArray[n].group.setAtomBitsAndClear(bS3, bS);
            }
            n = bS.nextSetBit(n + 1);
        }
        BS[] bSArray = new BS[modelSet.mc];
        int n2 = modelSet.mc;
        while (--n2 >= 0) {
            bSArray[n2] = this.vwr.getModelUndeletedAtomsBitSet(n2);
            bSArray[n2].andNot(bS3);
        }
        JmolMolecule[] jmolMoleculeArray = JmolMolecule.getMolecules(nodeArray, bSArray, null, bS3);
        int n3 = 0;
        while (n3 < jmolMoleculeArray.length) {
            BS bS4 = jmolMoleculeArray[n3].atomList;
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            lst.addLast(hashtable2);
            hashtable2.put("atoms", Escape.eBS(bS4));
            String string = "";
            String string2 = "";
            Group group = null;
            int n4 = 0;
            String string3 = null;
            String string4 = "";
            String string5 = "";
            int n5 = Integer.MAX_VALUE;
            int n6 = Integer.MAX_VALUE;
            int n7 = bS4.nextSetBit(0);
            while (n7 >= 0) {
                Node node = nodeArray[n7];
                if (group != ((Atom)node).group) {
                    group = ((Atom)node).group;
                    int n8 = ((Atom)node).getResno();
                    int n9 = ((Atom)node).getChainID();
                    if (n5 != n8 - 1) {
                        if (string4.length() != 0 && n5 != n6) {
                            string4 = String.valueOf(string4) + "-" + n5;
                        }
                        n9 = -1;
                        n6 = n8;
                    }
                    string5 = "/" + modelSet.getModelNumberDotted(((Atom)node).mi);
                    if (n4 != 0 && n9 != n4) {
                        string4 = String.valueOf(string4) + ":" + string3 + string5;
                    }
                    if (n9 == -1) {
                        string4 = String.valueOf(string4) + " " + n8;
                    }
                    n5 = n8;
                    n4 = ((Atom)node).getChainID();
                    string3 = ((Atom)node).getChainIDStr();
                    string = String.valueOf(string) + string2 + ((Atom)node).getGroup3(false);
                    string2 = "-";
                }
                n7 = bS4.nextSetBit(n7 + 1);
            }
            string4 = String.valueOf(string4) + (n6 == n5 ? "" : "-" + n5) + (n4 == 0 ? "" : ":" + string3) + string5;
            hashtable2.put("groupNames", string);
            hashtable2.put("residueList", string4.substring(1));
            ++n3;
        }
        return hashtable;
    }

    @Override
    public String getAtomData(String string, String string2, boolean bl) {
        String string3;
        if (!string.startsWith("{")) {
            string = "{" + string + "}";
        }
        boolean bl2 = string2.toLowerCase().startsWith("user:");
        boolean bl3 = string2.toLowerCase().startsWith("property_");
        if (bl && !bl2 && !bl3) {
            string2 = string2.toUpperCase();
        }
        String string4 = bl3 ? "%{" + string2 + "}" : (bl2 ? string2.substring(5) : (string2.equals("xyzrn") ? "%-2e %8.3x %8.3y %8.3z %4.2[vdw] 1 [%n]%r.%a#%i" : (string2.equals("xyzvib") ? "%-2e %10.5x %10.5y %10.5z %10.5vx %10.5vy %10.5vz" : (string2.equals("pdb") ? "{selected and not hetero}.label(\"ATOM  %5i %-4a%1A%3.3n %1c%4R%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2e  \").lines+{selected and hetero}.label(\"HETATM%5i %-4a%1A%3.3n %1c%4R%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2e  \").lines" : (string2.equals("xyz") ? "%-2e %10.5x %10.5y %10.5z" : (string3 = string2.equals("cfi") ? "print '$CFI from Jmol" + Viewer.getJmolVersion() + "\n'+{selected}.count + ' ' + {selected}.bonds.count + '\n'   + {selected}.format('%10.0[atomno] %10.0[elemno] %10.4[xyz]')  + {selected}.bonds.format('%i1 %i2') + '\n' + {selected}.bonds.format('%ORDER')" : null))))));
        if (string3 == null) {
            return this.getModelExtract(this.vwr.getAtomBitSet(string), false, false, string2.toUpperCase(), bl);
        }
        if (string3.startsWith("print")) {
            if (!string.equals("selected")) {
                string3 = PT.rep(string3, "selected", string.substring(1, string.length() - 1));
            }
            return this.vwr.runScriptCautiously(string3);
        }
        if (string3.indexOf("label") < 0) {
            string3 = String.valueOf(string) + ".label(\"" + string3 + "\").lines";
        } else if (!string.equals("selected")) {
            string3 = PT.rep(string3, "selected", string.substring(1, string.length() - 1));
        }
        return (String)this.vwr.evaluateExpression(string3);
    }

    @Override
    public String getModelExtract(BS bS, boolean bl, boolean bl2, String string, boolean bl3) {
        Quat quat;
        int n;
        int n2;
        Object object;
        if (string.equalsIgnoreCase("CIF")) {
            return this.getModelCif(bS);
        }
        if (string.equalsIgnoreCase("QCJSON")) {
            return this.getQCJSON(bS);
        }
        if (string.equalsIgnoreCase("CML")) {
            return this.getModelCml(bS, Integer.MAX_VALUE, true, bl, bl3);
        }
        if (string.equals("PDB") || string.equals("PQR")) {
            return this.getPdbAtomData(bS, null, string.equals("PQR"), bl, bl3);
        }
        boolean bl4 = string.equalsIgnoreCase("V3000");
        boolean bl5 = string.equalsIgnoreCase("SDF");
        boolean bl6 = string.equalsIgnoreCase("MOL");
        boolean bl7 = !bl && string.equalsIgnoreCase("XYZVIB");
        boolean bl8 = string.equalsIgnoreCase("XYZRN");
        boolean bl9 = string.toUpperCase().startsWith("XYZ");
        boolean bl10 = string.equalsIgnoreCase("JSON") || string.equalsIgnoreCase("CD");
        SB sB = new SB();
        ModelSet modelSet = this.vwr.ms;
        BS bS2 = BSUtil.copy(bS);
        BS bS3 = this.vwr.ms.getModelBS(bS2, true);
        if (!bl9 && !bl10) {
            object = this.vwr.ms.getFrameTitle(bS3.nextSetBit(0));
            Object object2 = object != null ? ((String)object).replace('\n', ' ') : (object = bl2 ? "Jmol Model Kit" : FileManager.fixDOSName(this.vwr.fm.getFullPathName(false)));
            if (((String)object).length() > 80) {
                object = String.valueOf(((String)object).substring(0, 77)) + "...";
            }
            sB.append((String)object);
            String string2 = Viewer.getJmolVersion();
            sB.append("\n__Jmol-").append(string2.substring(0, 2));
            Calendar calendar = Calendar.getInstance();
            n2 = calendar.get(2);
            int n3 = calendar.get(5);
            int n4 = calendar.get(1);
            n = calendar.get(11);
            int n5 = calendar.get(12);
            PT.rightJustify(sB, "_00", "" + (1 + n2));
            PT.rightJustify(sB, "00", "" + n3);
            sB.append(("" + n4).substring(2, 4));
            PT.rightJustify(sB, "00", "" + n);
            PT.rightJustify(sB, "00", "" + n5);
            sB.append("3D 1   1.00000     0.00000     0");
            sB.append("\nJmol version ").append(Viewer.getJmolVersion()).append(" EXTRACT: ").append(Escape.eBS(bS)).append("\n");
        }
        object = modelSet.at;
        int n6 = bS.nextSetBit(0);
        while (n6 >= 0) {
            if (bl && object[n6].isDeleted()) {
                bS2.clear(n6);
            }
            n6 = bS.nextSetBit(n6 + 1);
        }
        BS bS4 = PropertyManager.getCovalentBondsForAtoms(modelSet.bo, modelSet.bondCount, bS2);
        if (!bl7 && bS2.isEmpty()) {
            return "";
        }
        n2 = 1;
        if (modelSet.trajectory != null && !bl3) {
            modelSet.trajectory.selectDisplayed(bS3);
        }
        Quat quat2 = quat = bl ? this.vwr.tm.getRotationQ() : null;
        if (bl5) {
            String string3 = sB.toString();
            sB = new SB();
            n = bS3.nextSetBit(0);
            while (n >= 0) {
                sB.append(string3);
                BS bS5 = BSUtil.copy(bS2);
                bS5.and(modelSet.getModelAtomBitSetIncludingDeleted(n, false));
                bS4 = PropertyManager.getCovalentBondsForAtoms(modelSet.bo, modelSet.bondCount, bS5);
                boolean bl11 = this.addMolFile(n, sB, bS5, bS4, false, false, bl6, quat);
                n2 = bl11 ? 1 : 0;
                if (bl11) {
                    n = bS3.nextSetBit(n + 1);
                    continue;
                }
                break;
            }
        } else if (bl9) {
            LabelToken[] labelTokenArray = LabelToken.compile(this.vwr, bl8 ? "%-2e _XYZ_ %4.2[vdw] 1 [%n]%r.%a#%i\n" : "%-2e _XYZ_\n", '\u0000', null);
            LabelToken[] labelTokenArray2 = bl7 ? LabelToken.compile(this.vwr, "%-2e _XYZ_ %12.5vx %12.5vy %12.5vz\n", '\u0000', null) : null;
            P3 p3 = new P3();
            int n7 = bS3.nextSetBit(0);
            while (n7 >= 0) {
                BS bS6 = BSUtil.copy(bS2);
                bS6.and(modelSet.getModelAtomBitSetIncludingDeleted(n7, false));
                if (!bS6.isEmpty()) {
                    String string4;
                    Object[] objectArray;
                    sB.appendI(bS6.cardinality()).appendC('\n');
                    Properties properties = modelSet.am[n7].properties;
                    sB.append("Model[" + (n7 + 1) + "]: ");
                    if (modelSet.frameTitles[n7] != null && modelSet.frameTitles[n7].length() > 0) {
                        sB.append(modelSet.frameTitles[n7].replace('\n', ' '));
                    } else if (properties == null) {
                        sB.append("Jmol " + Viewer.getJmolVersion());
                    } else {
                        objectArray = new SB();
                        Enumeration<?> enumeration = properties.propertyNames();
                        string4 = null;
                        while (enumeration.hasMoreElements()) {
                            String string5 = (String)enumeration.nextElement();
                            if (string5.equals(".PATH")) {
                                string4 = properties.getProperty(string5);
                                continue;
                            }
                            objectArray.append(";").append(string5).append("=").append(properties.getProperty(string5));
                        }
                        if (string4 != null) {
                            objectArray.append(";PATH=").append(string4);
                        }
                        string4 = objectArray.substring(objectArray.length() > 0 ? 1 : 0);
                        sB.append(string4.replace('\n', ' '));
                    }
                    sB.appendC('\n');
                    objectArray = new Object[]{p3};
                    int n8 = bS6.nextSetBit(0);
                    while (n8 >= 0) {
                        string4 = LabelToken.formatLabelAtomArray(this.vwr, (Atom)object[n8], bl7 && modelSet.getVibration(n8, false) != null ? labelTokenArray2 : labelTokenArray, '\u0000', null, p3);
                        this.getPointTransf(n7, modelSet, (Atom)object[n8], quat, p3);
                        string4 = PT.rep(string4, "_XYZ_", PT.sprintf("%12.5p %12.5p %12.5p", "p", objectArray));
                        sB.append(string4);
                        n8 = bS6.nextSetBit(n8 + 1);
                    }
                }
                n7 = bS3.nextSetBit(n7 + 1);
            }
        } else {
            n2 = this.addMolFile(-1, sB, bS2, bS4, bl4, bl10, bl6, quat) ? 1 : 0;
        }
        return n2 != 0 ? sB.toString() : "ERROR: Too many atoms or bonds -- use V3000 format.";
    }

    private String getQCJSON(BS bS) {
        QCJSONWriter qCJSONWriter = (QCJSONWriter)Interface.getInterface("org.jmol.adapter.writers.QCJSONWriter", this.vwr, "script");
        qCJSONWriter.set(this.vwr, null);
        qCJSONWriter.writeJSON();
        return qCJSONWriter.toString();
    }

    private String getModelCif(BS bS) {
        float[] fArray;
        SB sB = new SB();
        sB.append("# primitive CIF file created by Jmol " + Viewer.getJmolVersion() + "\ndata_primitive");
        SymmetryInterface symmetryInterface = this.vwr.ms.getUnitCellForAtom(bS.nextSetBit(0));
        if (symmetryInterface == null) {
            float[] fArray2 = new float[6];
            fArray2[0] = 1.0f;
            fArray2[1] = 1.0f;
            fArray2[2] = 1.0f;
            fArray2[3] = 90.0f;
            fArray2[4] = 90.0f;
            fArray = fArray2;
            fArray2[5] = 90.0f;
        } else {
            fArray = symmetryInterface.getUnitCellAsArray(false);
        }
        float[] fArray3 = fArray;
        sB.append("\n_cell_length_a ").appendF(fArray3[0]);
        sB.append("\n_cell_length_b ").appendF(fArray3[1]);
        sB.append("\n_cell_length_c ").appendF(fArray3[2]);
        sB.append("\n_cell_angle_alpha ").appendF(fArray3[3]);
        sB.append("\n_cell_angle_beta ").appendF(fArray3[4]);
        sB.append("\n_cell_angle_gamma ").appendF(fArray3[5]);
        sB.append("\n\n_symmetry_space_group_name_H-M 'P 1'\nloop_\n_space_group_symop_operation_xyz\n'x,y,z'");
        sB.append("\n\nloop_\n_atom_site_label\n_atom_site_fract_x\n_atom_site_fract_y\n_atom_site_fract_z\n");
        Atom[] atomArray = this.vwr.ms.at;
        P3 p3 = new P3();
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            Atom atom = atomArray[n];
            p3.setT(atom);
            if (symmetryInterface != null) {
                symmetryInterface.toFractional(p3, false);
            }
            sB.append(atom.getElementSymbol()).append("\t").append(PT.formatF(p3.x, 10, 5, true, false)).append("\t").append(PT.formatF(p3.y, 10, 5, true, false)).append("\t").append(PT.formatF(p3.z, 10, 5, true, false)).append("\n");
            n = bS.nextSetBit(n + 1);
        }
        return sB.toString();
    }

    private boolean addMolFile(int n, SB sB, BS bS, BS bS2, boolean bl, boolean bl2, boolean bl3, Quat quat) {
        String string;
        int n2 = bS.cardinality();
        int n3 = bS2.cardinality();
        if (!(bl || bl2 || n2 <= 999 && n3 <= 999)) {
            return false;
        }
        boolean bl4 = n >= 0;
        Hashtable<String, String> hashtable = bl4 ? (Hashtable<String, String>)this.vwr.ms.getInfo(n, "molData") : null;
        ModelSet modelSet = this.vwr.ms;
        int[] nArray = new int[modelSet.ac];
        P3 p3 = new P3();
        if (bl) {
            sB.append("  0  0  0  0  0  0            999 V3000");
        } else if (bl2) {
            sB.append("{\"mol\":{\"createdBy\":\"Jmol " + Viewer.getJmolVersion() + "\",\"a\":[");
        } else {
            PT.rightJustify(sB, "   ", "" + n2);
            PT.rightJustify(sB, "   ", "" + n3);
            sB.append("  0  0  0  0            999 V2000");
        }
        if (!bl2) {
            sB.append("\n");
        }
        if (bl) {
            sB.append("M  V30 BEGIN CTAB\nM  V30 COUNTS ").appendI(n2).append(" ").appendI(n3).append(" 0 0 0\n").append("M  V30 BEGIN ATOM\n");
        }
        String string2 = string = hashtable == null ? null : (String)hashtable.get("atom_value_name");
        if (string instanceof SV) {
            string = ((SV)((Object)string)).asString();
        }
        int n4 = string == null ? 0 : T.getTokFromName(string);
        SB sB2 = n4 == 0 && !bl4 ? null : new SB();
        int n5 = bS.nextSetBit(0);
        int n6 = 0;
        while (n5 >= 0) {
            nArray[n5] = ++n6;
            this.getAtomRecordMOL(n, modelSet, sB, nArray[n5], modelSet.at[n5], quat, p3, bl, bl2, sB2, n4, bl4);
            n5 = bS.nextSetBit(n5 + 1);
        }
        if (bl) {
            sB.append("M  V30 END ATOM\nM  V30 BEGIN BOND\n");
        } else if (bl2) {
            sB.append("],\"b\":[");
        }
        n5 = bS2.nextSetBit(0);
        n6 = 0;
        while (n5 >= 0) {
            this.getBondRecordMOL(sB, ++n6, modelSet.bo[n5], nArray, bl, bl2, bl3);
            n5 = bS2.nextSetBit(n5 + 1);
        }
        if (bl) {
            sB.append("M  V30 END BOND\nM  V30 END CTAB\n");
        }
        if (bl2) {
            sB.append("]}}");
        } else {
            if (sB2 != null && sB2.length() > 0) {
                sB.append(sB2.toString());
            }
            sB.append("M  END\n");
        }
        if (bl4) {
            try {
                int n7;
                int n8;
                float[] fArray = modelSet.getPartialCharges();
                if (hashtable == null) {
                    hashtable = new Hashtable<String, String>();
                }
                SB sB3 = new SB();
                if (fArray != null) {
                    sB3.appendI(n2).appendC('\n');
                    n8 = bS.nextSetBit(0);
                    n7 = 0;
                    while (n8 >= 0) {
                        sB3.appendI(++n7).append(" ").appendF(fArray[n8]).appendC('\n');
                        n8 = bS.nextSetBit(n8 + 1);
                    }
                    hashtable.put("jmol_partial_charges", sB3.toString());
                }
                sB3.setLength(0);
                sB3.appendI(n2).appendC('\n');
                n8 = bS.nextSetBit(0);
                n7 = 0;
                while (n8 >= 0) {
                    String string3 = modelSet.at[n8].getAtomName().trim();
                    if (string3.length() == 0) {
                        string3 = ".";
                    }
                    sB3.appendI(++n7).append(" ").append(string3.replace(' ', '_')).appendC('\n');
                    n8 = bS.nextSetBit(n8 + 1);
                }
                hashtable.put("jmol_atom_names", sB3.toString());
                for (String string4 : hashtable.keySet()) {
                    string = hashtable.get(string4);
                    if (string instanceof SV) {
                        string = ((SV)((Object)string)).asString();
                    }
                    sB.append("> <" + string4.toUpperCase() + ">\n");
                    this.output80CharWrap(sB, string.toString(), 80);
                    sB.append("\n\n");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            sB.append("$$$$\n");
        }
        return true;
    }

    private void output80CharWrap(SB sB, String string, int n) {
        if (n < 80) {
            string = PT.rep(string, "\n", "|");
        }
        String[] stringArray = PT.split(PT.trim(PT.rep(string, "\n\n", "\n"), "\n"), "\n");
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.outputLines(sB, stringArray[n2], n);
            ++n2;
        }
    }

    private void outputLines(SB sB, String string, int n) {
        boolean bl = false;
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3 && !bl) {
            sB.append(string.substring(n2, Math.min(n2 + n, n3)));
            bl = n != 80;
            if (!bl && n2 + 80 < n3) {
                sB.append("+");
            }
            sB.append("\n");
            n2 += 80;
        }
    }

    private static BS getCovalentBondsForAtoms(Bond[] bondArray, int n, BS bS) {
        BS bS2 = new BS();
        int n2 = 0;
        while (n2 < n) {
            Bond bond = bondArray[n2];
            if (bS.get(bond.atom1.i) && bS.get(bond.atom2.i) && bond.isCovalent()) {
                bS2.set(n2);
            }
            ++n2;
        }
        return bS2;
    }

    private void getAtomRecordMOL(int n, ModelSet modelSet, SB sB, int n2, Atom atom, Quat quat, P3 p3, boolean bl, boolean bl2, SB sB2, int n3, boolean bl3) {
        this.getPointTransf(n, modelSet, atom, quat, p3);
        int n4 = atom.getElementNumber();
        String string = atom.isDeleted() ? "Xx" : Elements.elementSymbolFromNumber(n4);
        int n5 = atom.getIsotopeNumber();
        int n6 = atom.getFormalCharge();
        Object[] objectArray = new Object[]{p3};
        if (bl) {
            sB.append("M  V30 ").appendI(n2).append(" ").append(string).append(PT.sprintf(" %12.5p %12.5p %12.5p 0", "p", objectArray));
            if (n6 != 0) {
                sB.append(" CHG=").appendI(n6);
            }
            if (n5 != 0) {
                sB.append(" MASS=").appendI(n5);
            }
            sB.append("\n");
        } else if (bl2) {
            if (n2 != 1) {
                sB.append(",");
            }
            sB.append("{");
            if (atom.getElementNumber() != 6) {
                sB.append("\"l\":\"").append(atom.getElementSymbol()).append("\",");
            }
            if (n6 != 0) {
                sB.append("\"c\":").appendI(n6).append(",");
            }
            if (n5 != 0) {
                sB.append("\"m\":").appendI(n5).append(",");
            }
            sB.append("\"x\":").appendF(atom.x).append(",\"y\":").appendF(atom.y).append(",\"z\":").appendF(atom.z).append("}");
        } else {
            String string2;
            sB.append(PT.sprintf("%10.4p%10.4p%10.4p", "p", objectArray));
            sB.append(" ").append(string);
            if (string.length() == 1) {
                sB.append(" ");
            }
            PT.rightJustify(sB, "   ", "" + (n5 > 0 ? n5 - Elements.getNaturalIsotope(atom.getElementNumber()) : 0));
            if (bl3 && n5 > 0) {
                sB2.append("M  ISO  1");
                PT.rightJustify(sB2, "    ", "" + n2);
                PT.rightJustify(sB2, "    ", "" + n5);
                sB2.append("\n");
            }
            PT.rightJustify(sB, "   ", "" + (n6 == 0 ? 0 : 4 - n6));
            sB.append("  ").append(this.getAtomParity(atom));
            sB.append("  0  0  0\n");
            String string3 = string2 = n3 == 0 || bl ? null : this.getAtomPropertyAsString(atom, n3);
            if (string2 != null && (string2 = string2.trim()).length() > 0) {
                String string4 = "   " + n2 + " ";
                sB2.append("V  ").append(string4.substring(string4.length() - 4));
                this.output80CharWrap(sB2, string2, 73);
            }
        }
    }

    private String getAtomParity(Atom atom) {
        if (atom.getCovalentBondCount() == 4) {
            if (this.connections == null) {
                this.connections = new int[4];
                this.vTemp = new V3();
                this.vNorm = new V3();
            }
            Bond[] bondArray = atom.bonds;
            int n = 0;
            int n2 = 0;
            int n3 = bondArray.length;
            while (--n3 >= 0) {
                if (!bondArray[n3].isCovalent()) continue;
                Atom atom2 = bondArray[n3].getOtherAtom(atom);
                if (atom2.getAtomicAndIsotopeNumber() == 1) {
                    ++n;
                }
                this.connections[n2++] = atom2.i;
            }
            if (n < 3) {
                Arrays.sort(this.connections);
                Atom[] atomArray = this.vwr.ms.at;
                Measure.getNormalThroughPoints(atomArray[this.connections[0]], atomArray[this.connections[1]], atomArray[this.connections[2]], this.vNorm, this.vTemp);
                this.vTemp.sub2(atomArray[this.connections[3]], atomArray[this.connections[0]]);
                return this.vTemp.dot(this.vNorm) > 0.0f ? "1" : "2";
            }
        }
        return "0";
    }

    private String getAtomPropertyAsString(Atom atom, int n) {
        switch (n & 0x43C00000) {
            case 0x41400000: {
                int n2 = atom.atomPropertyInt(n);
                return n == 1765808134 ? PT.trim(Escape.escapeColor(n2), "[x]").toUpperCase() : "" + n2;
            }
            case 0x40C00000: {
                return atom.atomPropertyString(this.vwr, n);
            }
            case 0x42400000: {
                float f = atom.atomPropertyFloat(this.vwr, n, null);
                return Float.isNaN(f) ? null : "" + f;
            }
        }
        if (this.ptTemp == null) {
            this.ptTemp = new P3();
        }
        atom.atomPropertyTuple(this.vwr, n, this.ptTemp);
        return this.ptTemp == null ? null : this.ptTemp.toString();
    }

    private void getPointTransf(int n, ModelSet modelSet, Atom atom, Quat quat, P3 p3) {
        if (modelSet.isTrajectory(n >= 0 ? n : (int)atom.mi)) {
            modelSet.trajectory.getFractional(atom, p3);
        } else {
            p3.setT(atom);
        }
        if (quat != null) {
            quat.transform2(p3, p3);
        }
    }

    private void getBondRecordMOL(SB sB, int n, Bond bond, int[] nArray, boolean bl, boolean bl2, boolean bl3) {
        int n2 = nArray[bond.atom1.i];
        int n3 = nArray[bond.atom2.i];
        int n4 = bond.getValence();
        if (n4 > 3) {
            n4 = 1;
        }
        switch (bond.order & 0xFFFDFFFF) {
            case 515: {
                n4 = bl2 ? -3 : 4;
                break;
            }
            case 66: {
                n4 = bl2 ? -3 : 5;
                break;
            }
            case 513: {
                n4 = bl2 || bl3 ? 1 : 6;
                break;
            }
            case 514: {
                n4 = bl2 || bl3 ? 2 : 7;
                break;
            }
            case 33: {
                int n5 = n4 = bl2 ? -1 : 8;
            }
        }
        if (bl) {
            sB.append("M  V30 ").appendI(n).append(" ").appendI(n4).append(" ").appendI(n2).append(" ").appendI(n3).appendC('\n');
        } else if (bl2) {
            if (n != 1) {
                sB.append(",");
            }
            sB.append("{\"b\":").appendI(n2 - 1).append(",\"e\":").appendI(n3 - 1);
            if (n4 != 1) {
                sB.append(",\"o\":");
                if (n4 < 0) {
                    sB.appendF((float)(-n4) / 2.0f);
                } else {
                    sB.appendI(n4);
                }
            }
            sB.append("}");
        } else {
            PT.rightJustify(sB, "   ", "" + n2);
            PT.rightJustify(sB, "   ", "" + n3);
            sB.append("  ").appendI(n4).append("  0  0  0\n");
        }
    }

    @Override
    public String getChimeInfo(int n, BS bS) {
        switch (n) {
            case 1073741982: {
                break;
            }
            case 1073741863: {
                return this.getBasePairInfo(bS);
            }
            default: {
                return this.getChimeInfoA(this.vwr.ms.at, n, bS);
            }
        }
        SB sB = new SB();
        this.vwr.getChimeMessenger().getAllChimeInfo(sB);
        return sB.appendC('\n').toString().substring(1);
    }

    /*
     * Exception decompiling
     */
    private String getChimeInfoA(Atom[] var1_1, int var2_2, BS var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[SWITCH], 5[CASE]], but top level block is 6[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getModelFileInfo(BS bS) {
        ModelSet modelSet = this.vwr.ms;
        SB sB = new SB();
        int n = 0;
        while (n < modelSet.mc) {
            if (bS == null || bS.get(n)) {
                String string = "[\"" + modelSet.getModelNumberDotted(n) + "\"] = ";
                sB.append("\n\nfile").append(string).append(PT.esc(modelSet.getModelFileName(n)));
                String string2 = (String)modelSet.getInfo(n, "modelID");
                if (string2 != null) {
                    sB.append("\nid").append(string).append(PT.esc(string2));
                }
                sB.append("\ntitle").append(string).append(PT.esc(modelSet.getModelTitle(n)));
                sB.append("\nname").append(string).append(PT.esc(modelSet.getModelName(n)));
                sB.append("\ntype").append(string).append(PT.esc(modelSet.getModelFileType(n)));
            }
            ++n;
        }
        return sB.toString();
    }

    public Lst<Map<String, Object>> getAllAtomInfo(BS bS) {
        Lst<Map<String, Object>> lst = new Lst<Map<String, Object>>();
        P3 p3 = new P3();
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            lst.addLast(this.getAtomInfoLong(n, p3));
            n = bS.nextSetBit(n + 1);
        }
        return lst;
    }

    private Map<String, Object> getAtomInfoLong(int n, P3 p3) {
        ModelSet modelSet = this.vwr.ms;
        Atom atom = modelSet.at[n];
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        modelSet.getAtomIdentityInfo(n, hashtable, p3);
        hashtable.put("element", modelSet.getElementName(n));
        hashtable.put("elemno", modelSet.at[n].getElementNumber());
        hashtable.put("x", Float.valueOf(atom.x));
        hashtable.put("y", Float.valueOf(atom.y));
        hashtable.put("z", Float.valueOf(atom.z));
        hashtable.put("coord", P3.newP(atom));
        if (modelSet.vibrations != null && modelSet.vibrations[n] != null) {
            modelSet.vibrations[n].getInfo(hashtable);
        }
        hashtable.put("bondCount", atom.getCovalentBondCount());
        hashtable.put("radius", Float.valueOf((float)((double)atom.getRasMolRadius() / 120.0)));
        hashtable.put("model", atom.getModelNumberForLabel());
        String string = atom.atomPropertyString(this.vwr, 0x40C0000C);
        if (string != null) {
            hashtable.put("shape", string);
        }
        hashtable.put("visible", atom.checkVisible());
        hashtable.put("clickabilityFlags", atom.clickabilityFlags);
        hashtable.put("visibilityFlags", atom.shapeVisibilityFlags);
        hashtable.put("spacefill", Float.valueOf(atom.getRadius()));
        String string2 = Escape.escapeColor(this.vwr.gdata.getColorArgbOrGray(atom.colixAtom));
        if (string2 != null) {
            hashtable.put("color", string2);
        }
        hashtable.put("colix", atom.colixAtom);
        boolean bl = C.isColixTranslucent(atom.colixAtom);
        if (bl) {
            hashtable.put("translucent", bl);
        }
        hashtable.put("formalCharge", atom.getFormalCharge());
        hashtable.put("partialCharge", Float.valueOf(atom.getPartialCharge()));
        float f = (float)atom.getSurfaceDistance100() / 100.0f;
        if (f >= 0.0f) {
            hashtable.put("surfaceDistance", Float.valueOf(f));
        }
        if (modelSet.am[atom.mi].isBioModel) {
            hashtable.put("resname", atom.getGroup3(false));
            char c = atom.group.getInsertionCode();
            int n2 = atom.getResno();
            if (n2 > 0) {
                hashtable.put("resno", n2);
            }
            if (c != '\u0000') {
                hashtable.put("insertionCode", "" + c);
            }
            hashtable.put("name", modelSet.at[n].getAtomName());
            hashtable.put("chain", atom.getChainIDStr());
            hashtable.put("atomID", atom.atomID);
            hashtable.put("groupID", atom.group.groupID);
            if (atom.altloc != '\u0000') {
                hashtable.put("altLocation", "" + atom.altloc);
            }
            hashtable.put("structure", atom.group.getProteinStructureType().getId());
            hashtable.put("polymerLength", atom.group.getBioPolymerLength());
            hashtable.put("occupancy", atom.getOccupancy100());
            int n3 = atom.getBfactor100();
            hashtable.put("temp", n3 / 100);
        }
        return hashtable;
    }

    public Lst<Map<String, Object>> getAllBondInfo(Object object) {
        Lst<Map<String, Object>> lst;
        block7: {
            P3 p3;
            Bond[] bondArray;
            int n;
            block8: {
                block6: {
                    lst = new Lst<Map<String, Object>>();
                    ModelSet modelSet = this.vwr.ms;
                    n = modelSet.bondCount;
                    bondArray = modelSet.bo;
                    if (object instanceof String) {
                        object = this.vwr.getAtomBitSet(object);
                    }
                    p3 = new P3();
                    if (!(object instanceof BS[])) break block6;
                    BS bS = ((BS[])object)[0];
                    BS bS2 = ((BS[])object)[1];
                    int n2 = 0;
                    while (n2 < n) {
                        int n3 = bondArray[n2].atom1.i;
                        int n4 = bondArray[n2].atom2.i;
                        if (bS.get(n3) && bS2.get(n4) || bS2.get(n3) && bS.get(n4)) {
                            lst.addLast(this.getBondInfo(n2, p3));
                        }
                        ++n2;
                    }
                    break block7;
                }
                if (!(object instanceof BondSet)) break block8;
                BS bS = (BS)object;
                int n5 = bS.nextSetBit(0);
                while (n5 >= 0 && n5 < n) {
                    lst.addLast(this.getBondInfo(n5, p3));
                    n5 = bS.nextSetBit(n5 + 1);
                }
                break block7;
            }
            if (!(object instanceof BS)) break block7;
            BS bS = (BS)object;
            int n6 = bS.cardinality() == 1 ? bS.nextSetBit(0) : -1;
            int n7 = 0;
            while (n7 < n) {
                if (n6 >= 0 ? bondArray[n7].atom1.i == n6 || bondArray[n7].atom2.i == n6 : bS.get(bondArray[n7].atom1.i) && bS.get(bondArray[n7].atom2.i)) {
                    lst.addLast(this.getBondInfo(n7, p3));
                }
                ++n7;
            }
        }
        return lst;
    }

    private Map<String, Object> getBondInfo(int n, P3 p3) {
        Bond bond = this.vwr.ms.bo[n];
        Atom atom = bond.atom1;
        Atom atom2 = bond.atom2;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("_bpt", n);
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        this.vwr.ms.getAtomIdentityInfo(atom.i, hashtable2, p3);
        Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
        this.vwr.ms.getAtomIdentityInfo(atom2.i, hashtable3, p3);
        hashtable.put("atom1", hashtable2);
        hashtable.put("atom2", hashtable3);
        hashtable.put("jmol_order", "0x" + Integer.toHexString(bond.order));
        hashtable.put("order", Float.valueOf(PT.fVal(Edge.getBondOrderNumberFromOrder(bond.order))));
        hashtable.put("type", Edge.getBondOrderNameFromOrder(bond.order));
        hashtable.put("radius", Float.valueOf((float)((double)bond.mad / 2000.0)));
        hashtable.put("length_Ang", Float.valueOf(atom.distance(atom2)));
        hashtable.put("visible", bond.shapeVisibilityFlags != 0);
        String string = Escape.escapeColor(this.vwr.gdata.getColorArgbOrGray(bond.colix));
        if (string != null) {
            hashtable.put("color", string);
        }
        hashtable.put("colix", Integer.valueOf(bond.colix));
        if (C.isColixTranslucent(bond.colix)) {
            hashtable.put("translucent", Boolean.TRUE);
        }
        return hashtable;
    }

    public Map<String, Lst<Map<String, Object>>> getAllChainInfo(BS bS) {
        Hashtable<String, Lst<Map<String, Object>>> hashtable = new Hashtable<String, Lst<Map<String, Object>>>();
        Lst lst = new Lst();
        int n = this.vwr.ms.mc;
        int n2 = 0;
        while (n2 < n) {
            Hashtable<String, Serializable> hashtable2 = new Hashtable<String, Serializable>();
            Lst<Map<String, Lst<Map<String, Object>>>> lst2 = this.getChainInfo(n2, bS);
            if (lst2.size() > 0) {
                hashtable2.put("modelIndex", Integer.valueOf(n2));
                hashtable2.put("chains", lst2);
                lst.addLast(hashtable2);
            }
            ++n2;
        }
        hashtable.put("models", lst);
        return hashtable;
    }

    private Lst<Map<String, Lst<Map<String, Object>>>> getChainInfo(int n, BS bS) {
        Model model = this.vwr.ms.am[n];
        int n2 = model.getChainCount(true);
        Lst<Map<String, Lst<Map<String, Object>>>> lst = new Lst<Map<String, Lst<Map<String, Object>>>>();
        P3 p3 = new P3();
        int n3 = 0;
        while (n3 < n2) {
            Chain chain = model.getChainAt(n3);
            Lst<Map<String, Object>> lst2 = new Lst<Map<String, Object>>();
            int n4 = chain.groupCount;
            Hashtable<String, Lst<Map<String, Object>>> hashtable = new Hashtable<String, Lst<Map<String, Object>>>();
            int n5 = 0;
            while (n5 < n4) {
                Group group = chain.groups[n5];
                if (bS.get(group.firstAtomIndex)) {
                    lst2.addLast(group.getGroupInfo(n5, p3));
                }
                ++n5;
            }
            if (!lst2.isEmpty()) {
                hashtable.put("residues", lst2);
                lst.addLast((Map<String, Lst<Map<String, Object>>>)hashtable);
            }
            ++n3;
        }
        return lst;
    }

    private Map<String, Lst<Map<String, Object>>> getAllPolymerInfo(BS bS) {
        Hashtable<String, Lst<Map<String, Object>>> hashtable = new Hashtable<String, Lst<Map<String, Object>>>();
        if (this.vwr.ms.bioModelset != null) {
            this.vwr.ms.bioModelset.getAllPolymerInfo(bS, hashtable);
        }
        return hashtable;
    }

    private String getBasePairInfo(BS bS) {
        SB sB = new SB();
        Lst<Bond> lst = new Lst<Bond>();
        this.vwr.ms.calcRasmolHydrogenBonds(bS, bS, lst, true, 1, false, null);
        int n = lst.size();
        while (--n >= 0) {
            Bond bond = (Bond)lst.get(n);
            PropertyManager.getAtomResidueInfo(sB, bond.atom1);
            sB.append(" - ");
            PropertyManager.getAtomResidueInfo(sB, bond.atom2);
            sB.append("\n");
        }
        return sB.toString();
    }

    private static void getAtomResidueInfo(SB sB, Atom atom) {
        sB.append("[").append(atom.getGroup3(false)).append("]").append(atom.group.getSeqcodeString()).append(":");
        int n = atom.getChainID();
        sB.append(n == 0 ? " " : atom.getChainIDStr());
    }

    private Map<String, Object> getAppletInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("htmlName", this.vwr.htmlName);
        hashtable.put("syncId", this.vwr.syncId);
        hashtable.put("fullName", this.vwr.fullName);
        hashtable.put("codeBase", Viewer.appletCodeBase);
        if (this.vwr.isApplet) {
            hashtable.put("documentBase", Viewer.appletDocumentBase);
            hashtable.put("registry", this.vwr.sm.getRegistryInfo());
        }
        hashtable.put("version", JC.version);
        hashtable.put("date", JC.date);
        hashtable.put("javaVendor", Viewer.strJavaVendor);
        hashtable.put("javaVersion", String.valueOf(Viewer.strJavaVersion) + (!Viewer.isJS ? "" : (Viewer.isWebGL ? "(WebGL)" : "(HTML5)")));
        hashtable.put("operatingSystem", Viewer.strOSName);
        return hashtable;
    }

    private Map<String, Object> getAnimationInfo() {
        AnimationManager animationManager = this.vwr.am;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("firstModelIndex", animationManager.firstFrameIndex);
        hashtable.put("lastModelIndex", animationManager.lastFrameIndex);
        hashtable.put("animationDirection", animationManager.animationDirection);
        hashtable.put("currentDirection", animationManager.currentDirection);
        hashtable.put("displayModelIndex", animationManager.cmi);
        if (animationManager.animationFrames != null) {
            hashtable.put("isMovie", Boolean.TRUE);
            hashtable.put("frames", Escape.eAI(animationManager.animationFrames));
            hashtable.put("currentAnimationFrame", animationManager.caf);
        }
        hashtable.put("displayModelNumber", this.vwr.getModelNumberDotted(animationManager.cmi));
        hashtable.put("displayModelName", animationManager.cmi >= 0 ? this.vwr.getModelName(animationManager.cmi) : "");
        hashtable.put("animationFps", animationManager.animationFps);
        hashtable.put("animationReplayMode", T.nameOf(animationManager.animationReplayMode));
        hashtable.put("firstFrameDelay", Float.valueOf(animationManager.firstFrameDelay));
        hashtable.put("lastFrameDelay", Float.valueOf(animationManager.lastFrameDelay));
        hashtable.put("animationOn", animationManager.animationOn);
        hashtable.put("animationPaused", animationManager.animationPaused);
        return hashtable;
    }

    private Map<String, Object> getBoundBoxInfo() {
        P3[] p3Array = this.vwr.ms.getBoxInfo(null, 1.0f).getBoundBoxPoints(true);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("center", P3.newP(p3Array[0]));
        hashtable.put("vector", V3.newV(p3Array[1]));
        hashtable.put("corner0", P3.newP(p3Array[2]));
        hashtable.put("corner1", P3.newP(p3Array[3]));
        return hashtable;
    }

    private Map<String, Object> getShapeInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        SB sB = new SB();
        Shape[] shapeArray = this.vwr.shm.shapes;
        if (shapeArray != null) {
            int n = 0;
            while (n < 37) {
                Shape shape = shapeArray[n];
                if (shape != null) {
                    String string = JC.shapeClassBases[n];
                    Object object = shape.getShapeDetail();
                    if (object != null) {
                        hashtable.put(string, object);
                    }
                }
                ++n;
            }
        }
        if (sB.length() > 0) {
            hashtable.put("shapeCommands", sB.toString());
        }
        return hashtable;
    }

    private SV getAnnotationInfo(Object object, int n) {
        BS bS = this.vwr.getAtomBitSet(object);
        int n2 = this.vwr.ms.getModelBS(bS, false).nextSetBit(0);
        if (n2 < 0) {
            return null;
        }
        Map<String, Object> map = this.vwr.ms.getModelAuxiliaryInfo(n2);
        SV sV = (SV)map.get(n == 1073741925 ? "domains" : "validation");
        if (sV == null || sV.tok != 6) {
            return null;
        }
        this.vwr.getAnnotationParser(false).initializeAnnotation(sV, n, n2);
        return sV.mapGet("_list");
    }

    private Lst<Map<String, Object>> getMeasurementInfo() {
        return (Lst)this.vwr.getShapeProperty(6, "info");
    }

    /*
     * WARNING - void declaration
     */
    private Object getMouseInfo() {
        if (!this.vwr.haveDisplay) {
            return null;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Lst<void> lst = new Lst<void>();
        ActionManager actionManager = this.vwr.acm;
        for (Object object : actionManager.b.getBindings().values()) {
            void stringArray;
            if (object instanceof Boolean) continue;
            if (AU.isAI(object)) {
                int[] nArray = (int[])object;
                String[] stringArray2 = new String[]{Binding.getMouseActionName(nArray[0], false), ActionManager.getActionName(nArray[1])};
            }
            lst.addLast(stringArray);
        }
        hashtable.put("bindings", lst);
        hashtable.put("bindingName", actionManager.b.name);
        hashtable.put("actionNames", ActionManager.actionNames);
        hashtable.put("actionInfo", ActionManager.actionInfo);
        hashtable.put("bindingInfo", PT.split(actionManager.getBindingInfo(null), "\n"));
        return hashtable;
    }

    @Override
    public String getPdbAtomData(BS bS, OC oC, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        boolean bl4;
        boolean bl5;
        String string;
        Atom atom;
        Object object2;
        LabelToken[] labelTokenArray;
        int n;
        if (this.vwr.ms.ac == 0 || bS.nextSetBit(0) < 0) {
            return "";
        }
        if (oC == null) {
            oC = this.vwr.getOutputChannel(null, null);
        } else {
            bl |= oC.getType().indexOf("PQR") >= 0;
            bl2 |= oC.getType().indexOf("-coord true") >= 0;
        }
        Atom[] atomArray = this.vwr.ms.at;
        Model[] modelArray = this.vwr.ms.am;
        String string2 = "%6.2Q%6.2b          ";
        if (bl) {
            string2 = "%8.4P%7.4V       ";
            float f = 0.0f;
            n = bS.nextSetBit(0);
            while (n >= 0) {
                f += atomArray[n].getPartialCharge();
                n = bS.nextSetBit(n + 1);
            }
            oC.append("REMARK   1 PQR file generated by Jmol " + Viewer.getJmolVersion()).append("\nREMARK   1 created " + new Date()).append("\nREMARK   1 Forcefield Used: unknown\nREMARK   1").append("\nREMARK   5").append("\nREMARK   6 Total charge on this protein: " + f + " e\nREMARK   6\n");
        }
        short s = atomArray[bS.nextSetBit((int)0)].mi;
        n = -1;
        int n2 = bS.length() - 1;
        short s2 = atomArray[n2].mi;
        boolean bl6 = s != s2;
        BS bS2 = this.vwr.ms.getModelBS(bS, true);
        int n3 = bS2.cardinality();
        Lst<String> lst = new Lst<String>();
        boolean bl7 = modelArray[s].isPdbWithMultipleBonds;
        boolean bl8 = false;
        if (n3 > 1) {
            labelTokenArray = null;
            int n4 = 0;
            int n5 = bS2.nextSetBit(0);
            while (n5 >= 0) {
                object2 = this.vwr.ms.getModelAuxiliaryInfo(n5).get("PDB_CONECT_bonds");
                if (object2 != labelTokenArray || !this.vwr.ms.am[n5].isBioModel) {
                    labelTokenArray = object2;
                    if (n4++ > 0) {
                        bl8 = true;
                        break;
                    }
                }
                n5 = bS2.nextSetBit(n5 + 1);
            }
        }
        P3 p3 = new P3();
        Object[] objectArray = new Object[]{p3};
        object2 = bl2 ? this.vwr.tm.getRotationQ() : null;
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        boolean bl9 = false;
        int[] nArray = bl8 ? new int[n3] : null;
        int n6 = 0;
        int n7 = bS.nextSetBit(0);
        while (n7 >= 0) {
            atom = atomArray[n7];
            bl9 = modelArray[atom.mi].isBioModel;
            if (bl6 && atom.mi != n) {
                if (n != -1) {
                    n6 = this.fixPDBFormat(lst, hashtable, oC, nArray, n6);
                    oC.append("ENDMDL\n");
                }
                lst = new Lst();
                n = atom.mi;
                oC.append("MODEL     " + (n + 1) + "\n");
            }
            string = atom.getAtomName();
            bl5 = atom.getElementSymbol().length() == 2 || string.length() >= 4 || PT.isDigit(string.charAt(0));
            bl4 = atom.isHetero();
            labelTokenArray = !bl9 ? (bl5 ? LabelToken.compile(this.vwr, "HETATM%5.-5i %-4.4a%1AUNK %1c   1%1E   _XYZ_" + string2, '\u0000', null) : LabelToken.compile(this.vwr, "HETATM%5.-5i  %-3.3a%1AUNK %1c   1%1E   _XYZ_" + string2, '\u0000', null)) : (bl4 ? (bl5 ? LabelToken.compile(this.vwr, "HETATM%5.-5i %-4.4a%1A%3.3n %1c%4.-4R%1E   _XYZ_" + string2, '\u0000', null) : LabelToken.compile(this.vwr, "HETATM%5.-5i  %-3.3a%1A%3.3n %1c%4.-4R%1E   _XYZ_" + string2, '\u0000', null)) : (bl5 ? LabelToken.compile(this.vwr, "ATOM  %5.-5i %-4.4a%1A%3.3n %1c%4.-4R%1E   _XYZ_" + string2, '\u0000', null) : LabelToken.compile(this.vwr, "ATOM  %5.-5i  %-3.3a%1A%3.3n %1c%4.-4R%1E   _XYZ_" + string2, '\u0000', null)));
            object = atom.getElementSymbolIso(false).toUpperCase();
            object = String.valueOf(this.pdbKey(atom.group.getBioPolymerIndexInModel())) + this.pdbKey(atom.group.groupIndex) + LabelToken.formatLabelAtomArray(this.vwr, atom, labelTokenArray, '\u0000', null, p3) + (object.length() == 1 ? " " + (String)object : object.substring(0, 2)) + "  ";
            this.getPointTransf(-1, this.vwr.ms, atom, (Quat)object2, p3);
            String string3 = PT.sprintf("%8.3p%8.3p%8.3p", "p", objectArray);
            if (string3.length() > 24) {
                string3 = PT.sprintf("%8.2p%8.2p%8.2p", "p", objectArray);
            }
            object = PT.rep((String)object, "_XYZ_", string3);
            lst.addLast((String)object);
            n7 = bS.nextSetBit(n7 + 1);
        }
        this.fixPDBFormat(lst, hashtable, oC, nArray, n6);
        if (bl6) {
            oC.append("ENDMDL\n");
        }
        n6 = -1;
        n = -1;
        bl9 = false;
        n7 = bS.nextSetBit(0);
        while (n7 >= 0) {
            atom = atomArray[n7];
            if (bl6 && atom.mi != n) {
                n = atom.mi;
                bl9 = modelArray[n].isBioModel;
                ++n6;
            }
            string = "" + (bl6 ? n6 : 0);
            bl5 = !bl9 || atom.isHetero();
            boolean bl10 = bl4 = !bl5 && atom.getElementNumber() == 16;
            if ((bl5 || bl7 || bl4) && (object = atom.bonds) != null) {
                int n8 = 0;
                while (n8 < ((Bond[])object).length) {
                    int n9;
                    int n10 = atom.getAtomNumber();
                    Atom atom2 = object[n8].getOtherAtom(atom);
                    if (!(!bS.get(atom2.i) || (n9 = object[n8].getCovalentOrder()) == 1 && (bl7 && !bl5 && !bl4 || bl4 && atom2.getElementNumber() != 16))) {
                        int n11 = atom2.getAtomNumber();
                        switch (n9) {
                            case 2: 
                            case 3: {
                                if (n11 < n10) break;
                            }
                            case 1: {
                                Integer n12 = (Integer)hashtable.get(String.valueOf(string) + "." + Integer.valueOf(n10));
                                Integer n13 = (Integer)hashtable.get(String.valueOf(string) + "." + Integer.valueOf(n11));
                                if (n12 == null || n13 == null) break;
                                oC.append("CONECT").append(PT.formatStringS("%5s", "s", "" + n12));
                                String string4 = PT.formatStringS("%5s", "s", "" + n13);
                                int n14 = 0;
                                while (n14 < n9) {
                                    oC.append(string4);
                                    ++n14;
                                }
                                oC.append("\n");
                            }
                        }
                    }
                    ++n8;
                }
            }
            n7 = bS.nextSetBit(n7 + 1);
        }
        return oC.toString();
    }

    private String pdbKey(int n) {
        String string = n < 0 ? "~999" : "   " + n;
        return string.substring(string.length() - 4);
    }

    private int fixPDBFormat(Lst<String> lst, Map<String, Integer> map, OC oC, int[] nArray, int n) {
        lst.addLast("~999~999XXXXXX99999999999999999999~99~");
        Object[] objectArray = new String[lst.size()];
        lst.toArray(objectArray);
        Arrays.sort(objectArray);
        lst.clear();
        int n2 = 0;
        int n3 = objectArray.length;
        while (n2 < n3) {
            lst.addLast((String)objectArray[n2]);
            ++n2;
        }
        String string = null;
        String string2 = null;
        int n4 = lst.size();
        int n5 = 0;
        int n6 = nArray == null ? 0 : nArray[n];
        int n7 = 0;
        while (n7 < n4) {
            boolean bl;
            String string3 = (String)lst.get(n7);
            String string4 = string3.substring(0, 4);
            string3 = string3.substring(8);
            boolean bl2 = false;
            boolean bl3 = bl = string3.indexOf("~99~") >= 0;
            if (!string4.equals(string) || bl) {
                if (string != null && !string.equals("~999")) {
                    bl2 = true;
                    string3 = "TER   " + string2.substring(6, 11) + "      " + string2.substring(17, 27);
                    lst.add(n7, String.valueOf(string4) + "~~~~" + string3);
                    ++n4;
                }
                string = string4;
            }
            if (bl && !bl2) break;
            string2 = string3;
            n5 = n7 + 1 + n6;
            if (map != null && !bl2) {
                map.put(n + "." + Integer.valueOf(PT.parseInt(string3.substring(6, 11))), n5);
            }
            String string5 = "     " + n5;
            oC.append(string3.substring(0, 6)).append(string5.substring(string5.length() - 5)).append(string3.substring(11)).append("\n");
            ++n7;
        }
        if (nArray != null && ++n < nArray.length) {
            nArray[n] = n5;
        }
        return n;
    }

    @Override
    public String getPdbData(int n, String string, BS bS, Object[] objectArray, OC oC, boolean bl) {
        if (this.vwr.ms.isJmolDataFrameForModel(n)) {
            n = this.vwr.ms.getJmolDataSourceFrame(n);
        }
        if (n < 0) {
            return "";
        }
        Model model = this.vwr.ms.am[n];
        boolean bl2 = model.isBioModel;
        if (objectArray == null && !bl2) {
            return null;
        }
        if (oC == null) {
            oC = this.vwr.getOutputChannel(null, null);
        }
        SB sB = new SB();
        boolean bl3 = string.indexOf("draw") >= 0;
        BS bS2 = null;
        BS bS3 = new BS();
        char c = '\u0000';
        this.vwr.ms.getLabeler();
        LabelToken[] labelTokenArray = LabelToken.compile(this.vwr, "ATOM  %-6i%4a%1A%3.-3n %1c%4R%1E   ", '\u0000', null);
        if (objectArray == null) {
            c = string.length() > 11 && string.indexOf("quaternion ") >= 0 ? (char)string.charAt(11) : (char)'R';
            ((BioModel)model).getPdbData(string, c, bl3, bS, oC, labelTokenArray, sB, bS3);
            bS2 = this.vwr.getModelUndeletedAtomsBitSet(n);
        } else {
            Object object;
            String string2;
            bS2 = (BS)objectArray[0];
            float[] fArray = (float[])objectArray[1];
            float[] fArray2 = (float[])objectArray[2];
            float[] fArray3 = (float[])objectArray[3];
            boolean bl4 = fArray2 != null;
            boolean bl5 = fArray3 != null;
            P3 p3 = (P3)objectArray[4];
            P3 p32 = (P3)objectArray[5];
            P3 p33 = (P3)objectArray[6];
            P3 p34 = (P3)objectArray[7];
            String string3 = (String)objectArray[8];
            String[] stringArray = (String[])objectArray[9];
            boolean bl6 = p33 != null && string3 == null;
            Atom[] atomArray = this.vwr.ms.at;
            if (bl6) {
                oC.append("REMARK   6 Jmol PDB-encoded data: ").append(string).append("; ").append(Viewer.getJmolVersion()).append("; ").append(this.vwr.apiPlatform.getDateFormat(null)).append("\n");
                oC.append("REMARK   6 Jmol data").append(" min = ").append(Escape.eP(p3)).append(" max = ").append(Escape.eP(p32)).append(" unScaledXyz = xyz * ").append(Escape.eP(p33)).append(" + ").append(Escape.eP(p34)).append(";\n");
                string2 = null;
                int n2 = bS2.nextSetBit(0);
                while (n2 >= 0) {
                    String string4 = atomArray[n2].getAtomName();
                    if (string2 != null || string4.length() > 4) {
                        if (string2 == null) {
                            string2 = "";
                            n2 = -1;
                        } else {
                            string2 = String.valueOf(string2) + " " + string4;
                        }
                    }
                    n2 = bS2.nextSetBit(n2 + 1);
                }
                if (string2 != null) {
                    oC.append("REMARK   6 Jmol atom names").append(string2).append("\n");
                }
                object = null;
                int n3 = bS2.nextSetBit(0);
                while (n3 >= 0) {
                    String string5 = atomArray[n3].getGroup3(true);
                    if (object != null || string5.length() > 3) {
                        if (object == null) {
                            object = "";
                            n3 = -1;
                        } else {
                            object = String.valueOf(object) + " " + string5;
                        }
                    }
                    n3 = bS2.nextSetBit(n3 + 1);
                }
                if (object != null) {
                    oC.append("REMARK   6 Jmol residue names").append((String)object).append("\n");
                }
                n3 = 0;
                while (n3 < stringArray.length) {
                    if (stringArray[n3] != null) {
                        oC.append("REMARK   6 Jmol property ").append(stringArray[n3]).append(";\n");
                    }
                    ++n3;
                }
            }
            string2 = "";
            object = null;
            P3 p35 = new P3();
            if (!bl6) {
                if (string3 == null) {
                    string3 = "%-5i %-10s %-13.5f " + (bl5 ? "%-13.5f %-13.5f" : (bl4 ? "%-13.5f" : ""));
                }
                string3 = String.valueOf(string3) + "\n";
            }
            int n4 = bS2.nextSetBit(0);
            int n5 = 0;
            while (n4 >= 0) {
                float f;
                float f2 = fArray[n5];
                float f3 = bl4 ? fArray2[n5] : 0.0f;
                float f4 = f = bl5 ? fArray3[n5] : 0.0f;
                if (!(Float.isNaN(f2) || Float.isNaN(f3) || Float.isNaN(f))) {
                    Atom atom = atomArray[n4];
                    if (bl6) {
                        oC.append(LabelToken.formatLabelAtomArray(this.vwr, atom, labelTokenArray, '\u0000', null, p35));
                        if (bl2) {
                            bS3.set(n4);
                        }
                        oC.append(PT.sprintf("%-8.2f%-8.2f%-10.2f    %6.3f          %2s    %s\n", "ssF", new Object[]{atom.getElementSymbolIso(false).toUpperCase(), string2, new float[]{f2, f3, f, 0.0f}}));
                        if (object != null && ((Atom)object).group.getBioPolymerIndexInModel() == atom.group.getBioPolymerIndexInModel()) {
                            sB.append("CONECT").append(PT.formatStringI("%5i", "i", ((Atom)object).getAtomNumber())).append(PT.formatStringI("%5i", "i", atom.getAtomNumber())).appendC('\n');
                        }
                    } else if (bl5) {
                        oC.append(PT.sprintf(string3, "isF", new Object[]{atom.getAtomNumber(), atom.getAtomName(), new float[]{f2, f3, f}}));
                    } else if (bl4) {
                        oC.append(PT.sprintf(string3, "isF", new Object[]{atom.getAtomNumber(), atom.getAtomName(), new float[]{f2, f3}}));
                    } else {
                        oC.append(PT.sprintf(string3, "isF", new Object[]{atom.getAtomNumber(), atom.getAtomName(), new float[]{f2}}));
                    }
                    object = atom;
                }
                n4 = bS2.nextSetBit(n4 + 1);
                ++n5;
            }
        }
        oC.append(sB.toString());
        if (bl3) {
            return oC.toString();
        }
        bS.and(bS2);
        if (bl2 && bl) {
            oC.append("\n\n" + this.vwr.ms.getProteinStructureState(bS3, c == 'R' ? 4138 : 1073742086));
        }
        return oC.toString();
    }

    @Override
    public String getModelCml(BS bS, int n, boolean bl, boolean bl2, boolean bl3) {
        Bond[] bondArray;
        SB sB = new SB();
        int n2 = bS.cardinality();
        if (n2 == 0) {
            return "";
        }
        if (Viewer.isJS) {
            Interface.getInterface("javajs.util.XmlUtil", this.vwr, "file");
        }
        XmlUtil.openTag(sB, "molecule");
        XmlUtil.openTag(sB, "atomArray");
        BS bS2 = new BS();
        Atom[] atomArray = this.vwr.ms.at;
        int n3 = bS.nextSetBit(0);
        while (n3 >= 0) {
            if (--n < 0) break;
            bondArray = atomArray[n3];
            String string = bondArray.getAtomName();
            PT.rep(string, "\"", "''");
            bS2.set(bondArray.i);
            XmlUtil.appendTag(sB, "atom/", new String[]{"id", "a" + (bondArray.i + 1), "title", bondArray.getAtomName(), "elementType", bondArray.getElementSymbol(), "x3", "" + bondArray.x, "y3", "" + bondArray.y, "z3", "" + bondArray.z});
            n3 = bS.nextSetBit(n3 + 1);
        }
        XmlUtil.closeTag(sB, "atomArray");
        if (bl) {
            XmlUtil.openTag(sB, "bondArray");
            n3 = this.vwr.ms.bondCount;
            bondArray = this.vwr.ms.bo;
            int n4 = 0;
            while (n4 < n3) {
                String string;
                Bond bond = bondArray[n4];
                Atom atom = bond.atom1;
                Atom atom2 = bond.atom2;
                if (bS2.get(atom.i) && bS2.get(atom2.i) && (string = Edge.getCmlBondOrder(bond.order)) != null) {
                    XmlUtil.appendTag(sB, "bond/", new String[]{"atomRefs2", "a" + (bond.atom1.i + 1) + " a" + (bond.atom2.i + 1), "order", string});
                }
                ++n4;
            }
            XmlUtil.closeTag(sB, "bondArray");
        }
        XmlUtil.closeTag(sB, "molecule");
        return sB.toString();
    }

    @Override
    public String fixJMEFormalCharges(BS bS, String string) {
        Object object;
        boolean bl = false;
        if (bS == null) {
            return string;
        }
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            object = this.vwr.ms.at[n];
            if (((Atom)object).getFormalCharge() != 0) {
                bl = true;
                break;
            }
            n = bS.nextSetBit(n + 1);
        }
        if (!bl) {
            return string;
        }
        int[][] nArray = this.vwr.getSmilesMatcher().getMapForJME(string, this.vwr.ms.at, bS);
        if (nArray == null) {
            return string;
        }
        object = nArray[0];
        int[] nArray2 = nArray[1];
        String[] stringArray = PT.getTokens(string);
        int n2 = PT.parseInt(stringArray[0]);
        int[] nArray3 = new int[n2];
        int n3 = ((Object)object).length;
        while (--n3 >= 0) {
            nArray3[object[n3]] = nArray2[n3] + 1;
        }
        n3 = 0;
        int n4 = 2;
        while (n4 < stringArray.length) {
            Atom atom;
            String string2;
            String string3 = stringArray[n4];
            if (PT.parseInt(string3) != Integer.MIN_VALUE) break;
            string3 = PT.replaceAllCharacters(string3, "+-", "");
            if (!(string2 = (atom = this.vwr.ms.at[nArray3[n3++] - 1]).getElementSymbol()).equals(string3)) {
                return string;
            }
            int n5 = atom.getFormalCharge();
            if (n5 != 0) {
                stringArray[n4] = String.valueOf(string3) + (n5 > 0 ? "+" : "-") + (Math.abs(n5) > 1 ? "" + Math.abs(n5) : "");
            }
            n4 += 3;
        }
        return PT.join(stringArray, ' ', 0);
    }
}

