/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.general;

import javax.swing.Icon;
import org.gephi.datalab.api.AttributeColumnsController;
import org.gephi.datalab.api.datatables.DataTablesController;
import org.gephi.datalab.plugin.manipulators.general.ui.SearchReplaceUI;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.datalab.spi.general.GeneralActionsManipulator;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.Table;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class SearchReplace
implements GeneralActionsManipulator {
    public void execute() {
        SearchReplaceUI ui = (SearchReplaceUI)Lookup.getDefault().lookup(SearchReplaceUI.class);
        if (ui.isActive()) {
            return;
        }
        if (((DataTablesController)Lookup.getDefault().lookup(DataTablesController.class)).isNodeTableMode()) {
            ui.setMode(SearchReplaceUI.Mode.NODES_TABLE);
        } else {
            ui.setMode(SearchReplaceUI.Mode.EDGES_TABLE);
        }
        DialogDescriptor dd = new DialogDescriptor((Object)ui, this.getName());
        dd.setModal(true);
        dd.setOptions(new Object[]{NbBundle.getMessage(SearchReplace.class, (String)"SearchReplace.window.close")});
        ui.setActive(true);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        ui.setActive(false);
    }

    public String getName() {
        return NbBundle.getMessage(SearchReplace.class, (String)"SearchReplace.name");
    }

    public String getDescription() {
        return "";
    }

    public boolean canExecute() {
        Table currentTable = this.getCurrentTable();
        return currentTable != null && ((AttributeColumnsController)Lookup.getDefault().lookup(AttributeColumnsController.class)).getTableRowsCount(currentTable) > 0;
    }

    public ManipulatorUI getUI() {
        return null;
    }

    public int getType() {
        return 100;
    }

    public int getPosition() {
        return 0;
    }

    public Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"org/gephi/datalab/plugin/manipulators/resources/binocular--pencil.png", (boolean)true);
    }

    private Table getCurrentTable() {
        DataTablesController dtc = (DataTablesController)Lookup.getDefault().lookup(DataTablesController.class);
        if (dtc.getDataTablesEventListener() == null) {
            return null;
        }
        if (dtc.isNodeTableMode()) {
            return ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getNodeTable();
        }
        return ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel().getEdgeTable();
    }
}

