define(["globalize","imageLoader","cardBuilder","loading","connectionManager","apphost","layoutManager","scrollHelper","focusManager","emby-itemscontainer","emby-scroller"],function(globalize,imageLoader,cardBuilder,loading,connectionManager,appHost,layoutManager,scrollHelper,focusManager){"use strict";function getRecommendationHtml(recommendation){var html="",title="";switch(recommendation.RecommendationType){case"SimilarToRecentlyPlayed":title=globalize.translate("BecauseYouWatchedValue",recommendation.BaselineItemName);break;case"SimilarToLikedItem":title=globalize.translate("BecauseYouLikeValue",recommendation.BaselineItemName);break;case"HasDirectorFromRecentlyPlayed":case"HasLikedDirector":title=globalize.translate("DirectedByValue",recommendation.BaselineItemName);break;case"HasActorFromRecentlyPlayed":case"HasLikedActor":title=globalize.translate("StarringValue",recommendation.BaselineItemName)}return html+='<div class="verticalSection">',html+='<h2 class="sectionTitle sectionTitle-cards padded-left">'+title+"</h2>",html+='<div is="emby-scroller" class="padded-top-focusscale padded-bottom-focusscale" data-mousewheel="false" data-centerfocus="true">',html+='<div is="emby-itemscontainer" class="scrollSlider focuscontainer-x padded-left padded-right">',html+=cardBuilder.getCardsHtml(recommendation.Items,{shape:"autooverflow",scalable:!0,overlayPlayButton:!0,showTitle:!0,showYear:!0,centerText:!0}),html+="</div>",html+="</div>",html+="</div>"}function loadSuggestions(page,apiClient){var url=apiClient.getUrl("Movies/Recommendations",{userId:apiClient.getCurrentUserId(),categoryLimit:6,ItemLimit:12,Fields:"PrimaryImageAspectRatio,MediaSourceCount,BasicSyncInfo",ImageTypeLimit:1,EnableImageTypes:"Primary,Backdrop,Banner,Thumb"});apiClient.getJSON(url).then(function(recommendations){var suggestionsElement=page.querySelector(".suggestions");suggestionsElement.innerHTML=recommendations.map(getRecommendationHtml).join(""),imageLoader.lazyChildren(suggestionsElement)})}function MovieSuggestionsTab(view,params){this.view=view,this.params=params,this.apiClient=connectionManager.getApiClient(params.serverId),this.resumeItemsContainer=view.querySelector(".resumeSection .itemsContainer"),this.resumeItemsContainer.fetchData=fetchResumeItems.bind(this),this.resumeItemsContainer.getItemsHtml=getResumeItemsHtml.bind(this),this.resumeItemsContainer.parentContainer=view.querySelector(".resumeSection"),this.latestItemsContainer=view.querySelector(".latestSection .itemsContainer"),this.latestItemsContainer.fetchData=fetchLatestItems.bind(this),this.latestItemsContainer.getItemsHtml=getLatestItemsHtml.bind(this),this.latestItemsContainer.parentContainer=view.querySelector(".latestSection"),params.parentId&&(this.resumeItemsContainer.setAttribute("data-parentid",params.parentId),this.latestItemsContainer.setAttribute("data-parentid",params.parentId)),layoutManager.tv||initCategorySyncButtons(view,params,this.apiClient)}function initCategorySyncButtons(view,params,apiClient){require(["categorySyncButton"],function(categorySyncButton){apiClient.getCurrentUser().then(function(user){categorySyncButton.init(view.querySelector(".btnSyncLatest"),user,params.serverId,params.parentId)})})}function getThumbShape(){return"overflowBackdrop"}function fetchResumeItems(){var apiClient=this.apiClient,parentId=this.params.parentId;return apiClient.getResumableItems(apiClient.getCurrentUserId(),{IncludeItemTypes:"Movie",Limit:8,Fields:"PrimaryImageAspectRatio,BasicSyncInfo",ParentId:parentId,ImageTypeLimit:1,EnableImageTypes:"Primary,Backdrop,Thumb",EnableTotalRecordCount:!1})}function fetchLatestItems(){var apiClient=this.apiClient,parentId=this.params.parentId;return apiClient.getLatestItems({IncludeItemTypes:"Movie",Limit:24,Fields:"PrimaryImageAspectRatio,BasicSyncInfo",ParentId:parentId,ImageTypeLimit:1,EnableImageTypes:"Primary,Backdrop,Thumb"})}function getResumeItemsHtml(items){appHost.supports("imageanalysis");return cardBuilder.getCardsHtml({items:items,preferThumb:!0,shape:getThumbShape("resume"),scalable:!0,showTitle:!0,showYear:!0,overlayText:!1,centerText:!0,overlayPlayButton:!0,cardLayout:!1,vibrant:!1})}function getLatestItemsHtml(items){appHost.supports("imageanalysis");return cardBuilder.getCardsHtml({items:items,shape:"autooverflow",scalable:!0,showTitle:!0,showYear:!0,overlayText:!1,centerText:!0,overlayPlayButton:!0,cardLayout:!1,vibrant:!1})}return MovieSuggestionsTab.prototype.onResume=function(options){var apiClient=this.apiClient,promises=[];promises.push(this.resumeItemsContainer.resume(options)),promises.push(this.latestItemsContainer.resume(options)),options&&options.refresh&&loadSuggestions(this.view,apiClient);var view=this.view;Promise.all(promises).then(function(){options.autoFocus&&focusManager.autoFocus(view)})},MovieSuggestionsTab.prototype.onPause=function(){this.resumeItemsContainer.pause(),this.latestItemsContainer.pause()},MovieSuggestionsTab.prototype.destroy=function(){this.view=null,this.params=null,this.apiClient=null},MovieSuggestionsTab});