/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.mapping.put.MappingRequestValidator;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;

public interface ActionPlugin {
    default public List<ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Collections.emptyList();
    }

    default public List<Action<? extends ActionResponse>> getClientActions() {
        return this.getActions().stream().map(a -> ((ActionHandler)a).action).collect(Collectors.toList());
    }

    default public List<ActionFilter> getActionFilters() {
        return Collections.emptyList();
    }

    default public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Collections.emptyList();
    }

    default public Collection<String> getRestHeaders() {
        return Collections.emptyList();
    }

    default public Collection<String> getTaskHeaders() {
        return Collections.emptyList();
    }

    default public UnaryOperator<RestHandler> getRestHandlerWrapper(ThreadContext threadContext) {
        return null;
    }

    default public Collection<MappingRequestValidator> mappingRequestValidators() {
        return Collections.emptyList();
    }

    public static final class ActionHandler<Request extends ActionRequest, Response extends ActionResponse> {
        private final Action<Response> action;
        private final Class<? extends TransportAction<Request, Response>> transportAction;
        private final Class<?>[] supportTransportActions;

        public ActionHandler(Action<Response> action, Class<? extends TransportAction<Request, Response>> transportAction, Class<?> ... supportTransportActions) {
            this.action = action;
            this.transportAction = transportAction;
            this.supportTransportActions = supportTransportActions;
        }

        public Action<Response> getAction() {
            return this.action;
        }

        public Class<? extends TransportAction<Request, Response>> getTransportAction() {
            return this.transportAction;
        }

        public Class<?>[] getSupportTransportActions() {
            return this.supportTransportActions;
        }

        public String toString() {
            StringBuilder b = new StringBuilder().append(this.action.name()).append(" is handled by ").append(this.transportAction.getName());
            if (this.supportTransportActions.length > 0) {
                b.append('[').append(Strings.arrayToCommaDelimitedString(this.supportTransportActions)).append(']');
            }
            return b.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != ActionHandler.class) {
                return false;
            }
            ActionHandler other = (ActionHandler)obj;
            return Objects.equals(this.action, other.action) && Objects.equals(this.transportAction, other.transportAction) && Objects.deepEquals(this.supportTransportActions, other.supportTransportActions);
        }

        public int hashCode() {
            return Objects.hash(this.action, this.transportAction, this.supportTransportActions);
        }
    }
}

