/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.connector.process;

import org.eclipse.core.runtime.Assert;
import org.eclipse.tm.terminal.connector.process.ProcessConnector;

public class ProcessMonitor {
    private final ProcessConnector processConnector;
    private final Process process;
    private Thread thread;
    private boolean disposed;

    public ProcessMonitor(ProcessConnector processConnector) {
        Assert.isNotNull((Object)((Object)processConnector));
        this.processConnector = processConnector;
        this.process = processConnector.getProcess();
    }

    public void dispose() {
        this.disposed = true;
        if (this.thread == null) {
            return;
        }
        Thread oldThread = this.thread;
        this.thread = null;
        oldThread.interrupt();
    }

    public void startMonitoring() {
        if (this.thread != null) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ProcessMonitor.this.monitorProcess();
            }
        };
        this.thread = new Thread(runnable, "Terminal Process Monitor Thread");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void monitorProcess() {
        if (this.disposed) {
            return;
        }
        try {
            try {
                this.process.waitFor();
            }
            catch (InterruptedException ie) {
                Thread.interrupted();
                if (!this.disposed) {
                    this.processConnector.disconnect();
                }
            }
        }
        finally {
            if (!this.disposed) {
                this.processConnector.disconnect();
            }
        }
    }
}

