/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.completion.ContentAssistInvocationContext;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposalCollector;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposalComputer;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.dltk.ui.text.completion.ScriptTextMessages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.php.internal.ui.editor.contentassist.PHPCompletionProposalCollector;
import org.eclipse.php.internal.ui.editor.contentassist.PHPContentAssistInvocationContext;
import org.eclipse.php.internal.ui.editor.templates.PHPTemplateCompletionProcessor;
import org.eclipse.swt.widgets.Shell;

public class PHPCompletionProposalComputer
extends ScriptCompletionProposalComputer {
    private PHPCompletionProposalCollector phpCompletionProposalCollector;
    private PHPTemplateCompletionProcessor phpTemplateCompletionProcessor;

    protected TemplateCompletionProcessor createTemplateProposalComputer(ScriptContentAssistInvocationContext context) {
        boolean explicit = false;
        if (context instanceof PHPContentAssistInvocationContext) {
            explicit = ((PHPContentAssistInvocationContext)context).isExplicit();
        }
        this.phpTemplateCompletionProcessor = new PHPTemplateCompletionProcessor(context, explicit);
        return this.phpTemplateCompletionProcessor;
    }

    protected ScriptCompletionProposalCollector createCollector(ScriptContentAssistInvocationContext context) {
        boolean explicit = false;
        if (context instanceof PHPContentAssistInvocationContext) {
            explicit = ((PHPContentAssistInvocationContext)context).isExplicit();
        }
        this.phpCompletionProposalCollector = new PHPCompletionProposalCollector(context.getDocument(), context.getSourceModule(), explicit);
        return this.phpCompletionProposalCollector;
    }

    protected int guessContextInformationPosition(ContentAssistInvocationContext context) {
        IDocument document = context.getDocument();
        int offset = context.getInvocationOffset();
        int leftNumber = 0;
        if (document.getLength() == offset) {
            --offset;
        }
        try {
            while (offset > 0) {
                if (document.getChar(offset) == '(') {
                    ++leftNumber;
                } else if (document.getChar(offset - 1) == ')') {
                    --leftNumber;
                }
                if (leftNumber == 1) {
                    return offset;
                }
                --offset;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return super.guessContextInformationPosition(context);
    }

    private void handleCodeCompletionException(ModelException e, ScriptContentAssistInvocationContext context) {
        ISourceModule module = context.getSourceModule();
        Shell shell = context.getViewer().getTextWidget().getShell();
        if (e.isDoesNotExist() && !module.getScriptProject().isOnBuildpath((IModelElement)module)) {
            IPreferenceStore store = DLTKUIPlugin.getDefault().getPreferenceStore();
            boolean value = store.getBoolean("org.eclipse.dltk.ui.notification.not_on_buildpath");
            if (!value) {
                MessageDialog.openInformation((Shell)shell, (String)ScriptTextMessages.CompletionProcessor_error_notOnBuildPath_title, (String)ScriptTextMessages.CompletionProcessor_error_notOnBuildPath_message);
            }
            store.setValue("org.eclipse.dltk.ui.notification.not_on_buildpath", true);
        } else {
            ErrorDialog.openError((Shell)shell, (String)ScriptTextMessages.CompletionProcessor_error_accessing_title, (String)ScriptTextMessages.CompletionProcessor_error_accessing_message, (IStatus)e.getStatus());
        }
    }

    public void sessionEnded() {
        super.sessionEnded();
        if (this.phpTemplateCompletionProcessor != null) {
            this.phpTemplateCompletionProcessor.reset();
        }
    }
}

