/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.ui.InspectPopupDialog;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.EvaluateAction;
import org.eclipse.jdt.internal.debug.ui.display.JavaInspectExpression;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

public class ForceReturnAction
extends EvaluateAction {
    private IJavaStackFrame fTargetFrame = null;

    @Override
    protected void displayResult(final IEvaluationResult result) {
        this.evaluationCleanup();
        final Display display = JDIDebugUIPlugin.getStandardDisplay();
        if (result.hasErrors()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (display.isDisposed()) {
                        return;
                    }
                    ForceReturnAction.this.reportErrors(result);
                }
            });
            return;
        }
        try {
            IJavaStackFrame frame = this.fTargetFrame;
            IJavaValue value = result.getValue();
            frame.forceReturn(value);
            if (!"V".equals(value)) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (display.isDisposed()) {
                            return;
                        }
                        IWorkbenchPart part = ForceReturnAction.this.getTargetPart();
                        InspectPopupDialog dialog = new InspectPopupDialog(ForceReturnAction.this.getShell(), ForceReturnAction.getPopupAnchor(ForceReturnAction.getStyledText(part)), null, (IExpression)new JavaInspectExpression(result));
                        dialog.open();
                    }
                });
            }
        }
        catch (DebugException e) {
            final IStatus status = e.getStatus();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (display.isDisposed()) {
                        return;
                    }
                    JDIDebugUIPlugin.statusDialog(status);
                }
            });
        }
    }

    @Override
    protected void run() {
        IJavaStackFrame stackFrame = this.getStackFrameContext();
        if (stackFrame != null) {
            try {
                String returnType = Signature.getReturnType((String)stackFrame.getSignature());
                if ("V".equals(returnType)) {
                    stackFrame.forceReturn(((IJavaDebugTarget)stackFrame.getDebugTarget()).voidValue());
                    return;
                }
            }
            catch (DebugException e) {
                JDIDebugUIPlugin.statusDialog(e.getStatus());
                return;
            }
        }
        this.fTargetFrame = stackFrame;
        super.run();
    }
}

