/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.jpql.spi;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import org.eclipse.jpt.jpa.core.jpql.spi.JavaType;
import org.eclipse.jpt.jpa.core.jpql.spi.JavaTypeDeclaration;
import org.eclipse.persistence.jpa.jpql.tools.spi.IConstructor;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeRepository;

public class JavaConstructor
implements IConstructor {
    private Constructor<?> constructor;
    private ITypeDeclaration[] parameterTypes;
    private JavaType type;

    public JavaConstructor(JavaType type, Constructor<?> constructor) {
        this.type = type;
        this.constructor = constructor;
    }

    protected ITypeDeclaration[] buildParameterTypes() {
        Class<?>[] types = this.constructor.getParameterTypes();
        Type[] genericTypes = this.constructor.getGenericParameterTypes();
        ITypeDeclaration[] typeDeclarations = new ITypeDeclaration[types.length];
        int index = 0;
        int count = types.length;
        while (index < count) {
            typeDeclarations[index] = this.buildTypeDeclaration(types[index], genericTypes[index]);
            ++index;
        }
        return typeDeclarations;
    }

    protected ITypeDeclaration buildTypeDeclaration(Class<?> javaType, Type genericType) {
        ITypeRepository typeRepository = this.getTypeRepository();
        IType type = typeRepository.getType(javaType);
        return new JavaTypeDeclaration(typeRepository, type, genericType, javaType.isArray());
    }

    public ITypeDeclaration[] getParameterTypes() {
        if (this.parameterTypes == null) {
            this.parameterTypes = this.buildParameterTypes();
        }
        return this.parameterTypes;
    }

    protected ITypeRepository getTypeRepository() {
        return this.type.getTypeRepository();
    }

    public String toString() {
        return this.constructor.toGenericString();
    }
}

