/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.parsers.custom;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.parsers.custom.Messages;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class CustomTraceDefinition {
    public static final int ACTION_SET = 0;
    public static final int ACTION_APPEND = 1;
    public static final int ACTION_APPEND_WITH_SEPARATOR = 2;
    public static final @NonNull String SEPARATOR = " | ";
    private static final String TMF_CUSTOM_TRACE_BUILTIN_EXTENSION_ID = "org.eclipse.tracecompass.tmf.core.custom.trace";
    private static final String ATTRIBUTE_NAME_FILE = "file";
    private static final String ATTRIBUTE_NAME_TRACE_CONTENT_TYPE = "traceContentType";
    private static final String ELEMENT_NAME_CUSTOM_TRACE = "customTrace";
    public String categoryName;
    public String definitionName;
    public List<OutputColumn> outputs;
    public String timeStampOutputFormat;

    public String formatTimeStamp(TmfTimestamp timestamp) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.timeStampOutputFormat);
        return simpleDateFormat.format(timestamp.getValue());
    }

    public abstract void save();

    public abstract void save(String var1);

    protected static EntityResolver createEmptyEntityResolver() {
        return new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                String empty = "";
                ByteArrayInputStream bais = new ByteArrayInputStream(empty.getBytes());
                return new InputSource(bais);
            }
        };
    }

    protected static ErrorHandler createErrorHandler() {
        return new ErrorHandler(){

            @Override
            public void error(SAXParseException saxparseexception) throws SAXException {
            }

            @Override
            public void warning(SAXParseException saxparseexception) throws SAXException {
            }

            @Override
            public void fatalError(SAXParseException saxparseexception) throws SAXException {
                throw saxparseexception;
            }
        };
    }

    protected static Map.Entry<@NonNull Tag, @NonNull String> extractTagAndName(Element element, String tagAttribute, String nameAttribute) {
        Tag tag = Tag.fromName(element.getAttribute(tagAttribute));
        String name = element.getAttribute(nameAttribute);
        if (tag == null) {
            if (name.equals(Messages.CustomTraceDefinition_timestampTag)) {
                tag = Tag.TIMESTAMP;
                name = (String)NonNullUtils.checkNotNull((Object)Tag.TIMESTAMP.toString());
            } else if (name.equals(Messages.CustomTraceDefinition_messageTag)) {
                tag = Tag.MESSAGE;
                name = (String)NonNullUtils.checkNotNull((Object)Tag.MESSAGE.toString());
            } else if (name.equals(Messages.CustomXmlTraceDefinition_ignoreTag)) {
                tag = Tag.IGNORE;
                name = (String)NonNullUtils.checkNotNull((Object)Tag.IGNORE.toString());
            } else {
                tag = Tag.OTHER;
            }
        } else if (name.isEmpty()) {
            name = (String)NonNullUtils.checkNotNull((Object)tag.toString());
        }
        return new AbstractMap.SimpleEntry<Tag, String>(tag, name);
    }

    static final Collection<String> getExtensionDefinitionsPaths(String traceContentTypeToLoad) {
        IConfigurationElement[] elements;
        final ArrayList<String> extensionDefinitionsPaths = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(TMF_CUSTOM_TRACE_BUILTIN_EXTENSION_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String traceContentType;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(ELEMENT_NAME_CUSTOM_TRACE) && (traceContentType = element.getAttribute(ATTRIBUTE_NAME_TRACE_CONTENT_TYPE)).equals(traceContentTypeToLoad)) {
                final String filename = element.getAttribute(ATTRIBUTE_NAME_FILE);
                final String name = element.getContributor().getName();
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws IOException {
                        Bundle bundle;
                        if (name != null && (bundle = Platform.getBundle((String)name)) != null) {
                            URL xmlUrl = bundle.getResource(filename);
                            URL locatedURL = FileLocator.toFileURL((URL)xmlUrl);
                            extensionDefinitionsPaths.add(locatedURL.getPath());
                        }
                    }

                    public void handleException(Throwable exception) {
                    }
                });
            }
            ++n2;
        }
        return extensionDefinitionsPaths;
    }

    public static class OutputColumn {
        public @NonNull Tag tag;
        public @NonNull String name;

        public OutputColumn(@NonNull Tag tag, @NonNull String name) {
            this.tag = tag;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Tag {
        IGNORE(Messages.CustomXmlTraceDefinition_ignoreTag),
        TIMESTAMP(TmfBaseAspects.getTimestampAspect().getName()),
        EVENT_TYPE(TmfBaseAspects.getEventTypeAspect().getName()),
        MESSAGE(Messages.CustomTraceDefinition_messageTag),
        EXTRA_FIELD_NAME(Messages.CustomTraceDefinition_extraFieldNameTag),
        EXTRA_FIELD_VALUE(Messages.CustomTraceDefinition_extraFieldValueTag),
        EXTRA_FIELDS(Messages.CustomExtraFieldsAspect_extraFieldsAspectName),
        OTHER(Messages.CustomTraceDefinition_otherTag);

        private final String fLabel;

        private Tag(String label) {
            this.fLabel = label;
        }

        public String toString() {
            return this.fLabel;
        }

        public static Tag fromLabel(String label) {
            Tag[] tagArray = Tag.values();
            int n = tagArray.length;
            int n2 = 0;
            while (n2 < n) {
                Tag tag = tagArray[n2];
                if (tag.toString().equals(label)) {
                    return tag;
                }
                ++n2;
            }
            return null;
        }

        public static Tag fromName(String name) {
            Tag[] tagArray = Tag.values();
            int n = tagArray.length;
            int n2 = 0;
            while (n2 < n) {
                Tag tag = tagArray[n2];
                if (tag.name().equals(name)) {
                    return tag;
                }
                ++n2;
            }
            return null;
        }
    }
}

