/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.model;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.TmfCommonXAxisModel;
import org.eclipse.tracecompass.tmf.core.model.TmfXyModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ISeriesModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXyModel;
import org.eclipse.tracecompass.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;

public final class TmfXyResponseFactory {
    private TmfXyResponseFactory() {
    }

    public static TmfModelResponse<ITmfXyModel> create(String title, long[] xValues, Map<String, IYModel> yModels, boolean isComplete) {
        TmfCommonXAxisModel model = new TmfCommonXAxisModel(title, xValues, yModels);
        if (isComplete) {
            return new TmfModelResponse<ITmfXyModel>(model, ITmfResponse.Status.COMPLETED, Objects.requireNonNull(CommonStatusMessage.COMPLETED));
        }
        return new TmfModelResponse<ITmfXyModel>(model, ITmfResponse.Status.RUNNING, Objects.requireNonNull(CommonStatusMessage.RUNNING));
    }

    public static TmfModelResponse<ITmfXyModel> create(String title, Map<String, ISeriesModel> yModels, boolean isComplete) {
        TmfXyModel model = new TmfXyModel(title, yModels);
        if (isComplete) {
            return new TmfModelResponse<ITmfXyModel>(model, ITmfResponse.Status.COMPLETED, Objects.requireNonNull(CommonStatusMessage.COMPLETED));
        }
        return new TmfModelResponse<ITmfXyModel>(model, ITmfResponse.Status.RUNNING, Objects.requireNonNull(CommonStatusMessage.RUNNING));
    }

    public static TmfModelResponse<ITmfXyModel> createFailedResponse(String message) {
        return new TmfModelResponse<Object>(null, ITmfResponse.Status.FAILED, message);
    }

    public static TmfModelResponse<ITmfXyModel> createCancelledResponse(String message) {
        return new TmfModelResponse<Object>(null, ITmfResponse.Status.CANCELLED, message);
    }

    public static TmfModelResponse<ITmfXyModel> createEmptyResponse(String message) {
        TmfXyModel model = new TmfXyModel("", Collections.emptyMap());
        return new TmfModelResponse<ITmfXyModel>(model, ITmfResponse.Status.COMPLETED, message);
    }
}

