/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.modules;

import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.debug.core.model.ICModule;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.IInternalCDebugUIConstants;
import org.eclipse.cdt.debug.internal.ui.views.modules.ModulesMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.ICDebugUIConstants;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.internal.ui.views.variables.details.AbstractDetailPane;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.console.actions.TextViewerAction;
import org.eclipse.ui.progress.WorkbenchJob;

public class ModuleDetailPane
extends AbstractDetailPane
implements IAdaptable,
IPropertyChangeListener {
    protected static final String DETAIL_COPY_ACTION = String.valueOf(ActionFactory.COPY.getId()) + ".SourceDetailPane";
    protected static final String DETAIL_SELECT_ALL_ACTION = String.valueOf(IDebugView.SELECT_ALL_ACTION) + ".SourceDetailPane";
    public static final String ID = "ModuleDetailPane";
    public static final String NAME = "Module Viewer";
    public static final String DESCRIPTION = "A detail pane that is based on a source viewer.  Displays as text and has actions for assigning values, content assist and text modifications.";
    private SourceViewer fSourceViewer;
    private IDocument fDetailDocument;
    private DetailJob fDetailJob = null;

    private String getModuleDetail(ICModule module) {
        long size;
        IAddress baseAddress;
        StringBuilder sb = new StringBuilder();
        String type = null;
        switch (module.getType()) {
            case 1: {
                type = ModulesMessages.getString("ModulesView.1");
                break;
            }
            case 2: {
                type = ModulesMessages.getString("ModulesView.2");
            }
        }
        if (type != null) {
            sb.append(ModulesMessages.getString("ModulesView.3"));
            sb.append(type);
            sb.append('\n');
        }
        sb.append(ModulesMessages.getString("ModulesView.4"));
        sb.append(module.areSymbolsLoaded() ? ModulesMessages.getString("ModulesView.5") : ModulesMessages.getString("ModulesView.6"));
        sb.append('\n');
        sb.append(ModulesMessages.getString("ModulesView.7"));
        sb.append(module.getSymbolsFileName().toOSString());
        sb.append('\n');
        String cpu = module.getCPU();
        if (cpu != null) {
            sb.append(ModulesMessages.getString("ModulesView.8"));
            sb.append(cpu);
            sb.append('\n');
        }
        if (!(baseAddress = module.getBaseAddress()).isZero()) {
            sb.append(ModulesMessages.getString("ModulesView.9"));
            sb.append(baseAddress.toHexAddressString());
            sb.append('\n');
        }
        if ((size = module.getSize()) > 0L) {
            sb.append(ModulesMessages.getString("ModulesView.10"));
            sb.append(size);
            sb.append('\n');
        }
        return sb.toString();
    }

    public Control createControl(Composite parent) {
        this.createSourceViewer(parent);
        if (this.isInView()) {
            this.createViewSpecificComponents();
            this.createActions();
            CDebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
            JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        }
        return this.fSourceViewer.getControl();
    }

    private void createSourceViewer(Composite parent) {
        this.fSourceViewer = new SourceViewer(parent, null, 768);
        this.fSourceViewer.setDocument(this.getDetailDocument());
        this.fSourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)IInternalCDebugUIConstants.DETAIL_PANE_FONT));
        this.fSourceViewer.setEditable(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fSourceViewer.getTextWidget(), ICDebugHelpContextIds.MODULES_DETAIL_PANE);
        Control control = this.fSourceViewer.getControl();
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
    }

    private void createViewSpecificComponents() {
        this.getDetailDocument().addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                ModuleDetailPane.this.updateSelectionDependentActions();
            }
        });
        this.fSourceViewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModuleDetailPane.this.updateSelectionDependentActions();
            }
        });
        this.fSourceViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ModuleDetailPane.this.getViewSite().setSelectionProvider(ModuleDetailPane.this.fSourceViewer.getSelectionProvider());
                ModuleDetailPane.this.setGlobalAction(IDebugView.SELECT_ALL_ACTION, ModuleDetailPane.this.getAction(DETAIL_SELECT_ALL_ACTION));
                ModuleDetailPane.this.setGlobalAction(IDebugView.COPY_ACTION, ModuleDetailPane.this.getAction(DETAIL_COPY_ACTION));
                ModuleDetailPane.this.getViewSite().getActionBars().updateActionBars();
            }

            public void focusLost(FocusEvent e) {
                ModuleDetailPane.this.getViewSite().setSelectionProvider(null);
                ModuleDetailPane.this.setGlobalAction(IDebugView.SELECT_ALL_ACTION, null);
                ModuleDetailPane.this.setGlobalAction(IDebugView.CUT_ACTION, null);
                ModuleDetailPane.this.setGlobalAction(IDebugView.COPY_ACTION, null);
                ModuleDetailPane.this.setGlobalAction(IDebugView.PASTE_ACTION, null);
                ModuleDetailPane.this.setGlobalAction(IDebugView.FIND_ACTION, null);
                ModuleDetailPane.this.getViewSite().getActionBars().updateActionBars();
            }
        });
        this.createDetailContextMenu((Control)this.fSourceViewer.getTextWidget());
    }

    private void createActions() {
        TextViewerAction textAction = new TextViewerAction((ITextViewer)this.fSourceViewer, 7);
        textAction.configureAction("Select &All", "", "");
        textAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)textAction, ICDebugHelpContextIds.MODULE_DETAIL_PANE_SELECT_ALL_ACTION);
        this.setAction(DETAIL_SELECT_ALL_ACTION, (IAction)textAction);
        textAction = new TextViewerAction((ITextViewer)this.fSourceViewer, 4);
        textAction.configureAction("&Copy", "", "");
        textAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)textAction, ICDebugHelpContextIds.MODULE_DETAIL_PANE_COPY_ACTION);
        this.setAction(DETAIL_COPY_ACTION, (IAction)textAction);
        this.setSelectionDependantAction(DETAIL_COPY_ACTION);
        this.updateSelectionDependentActions();
    }

    protected void createDetailContextMenu(Control menuControl) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ModuleDetailPane.this.fillDetailContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(menuControl);
        menuControl.setMenu(menu);
        this.getViewSite().registerContextMenu(ICDebugUIConstants.MODULES_VIEW_DETAIL_ID, menuMgr, this.fSourceViewer.getSelectionProvider());
    }

    protected void fillDetailContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("modulesGroup"));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getAction(DETAIL_COPY_ACTION));
        menu.add(this.getAction(DETAIL_SELECT_ALL_ACTION));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(IStructuredSelection selection) {
        Object object;
        if (selection == null) {
            this.clearSourceViewer();
            return;
        }
        if (this.isInView()) {
            this.fSourceViewer.setEditable(true);
        }
        if (selection.isEmpty()) {
            this.clearSourceViewer();
            return;
        }
        Object firstElement = selection.getFirstElement();
        if (firstElement != null && firstElement instanceof IDebugElement) {
            object = ((IDebugElement)firstElement).getModelIdentifier();
        }
        object = this;
        synchronized (object) {
            if (this.fDetailJob != null) {
                this.fDetailJob.cancel();
            }
            this.fDetailJob = new DetailJob(selection.getFirstElement());
            this.fDetailJob.schedule();
        }
    }

    public boolean setFocus() {
        if (this.fSourceViewer != null) {
            this.fSourceViewer.getTextWidget().setFocus();
            return true;
        }
        return false;
    }

    public void dispose() {
        super.dispose();
        if (this.fDetailJob != null) {
            this.fDetailJob.cancel();
        }
        if (this.fSourceViewer != null && this.fSourceViewer.getControl() != null) {
            this.fSourceViewer.getControl().dispose();
        }
        if (this.isInView()) {
            CDebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
            JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        }
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getID() {
        return ID;
    }

    public String getName() {
        return NAME;
    }

    public <T> T getAdapter(Class<T> required) {
        if (ITextViewer.class.equals(required)) {
            return (T)this.fSourceViewer;
        }
        return null;
    }

    protected IDocument getDetailDocument() {
        if (this.fDetailDocument == null) {
            this.fDetailDocument = new Document();
        }
        return this.fDetailDocument;
    }

    protected void clearSourceViewer() {
        if (this.fDetailJob != null) {
            this.fDetailJob.cancel();
        }
        this.fDetailDocument.set("");
        this.fSourceViewer.setEditable(false);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getProperty();
        if (propertyName.equals(IInternalCDebugUIConstants.DETAIL_PANE_FONT)) {
            this.fSourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)IInternalCDebugUIConstants.DETAIL_PANE_FONT));
        }
    }

    class DetailJob
    extends Job {
        private Object fElement;
        private IProgressMonitor fMonitor;

        public DetailJob(Object element) {
            super("compute module details");
            this.setSystem(true);
            this.fElement = element;
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.fMonitor = monitor;
            String detail = "";
            if (this.fElement instanceof ICModule) {
                detail = ModuleDetailPane.this.getModuleDetail((ICModule)this.fElement);
            }
            if (this.fElement instanceof ICElement) {
                detail = this.fElement.toString();
            }
            this.detailComputed(detail);
            return Status.OK_STATUS;
        }

        private void detailComputed(final String result) {
            if (!this.fMonitor.isCanceled()) {
                WorkbenchJob setDetail = new WorkbenchJob("set details"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (!DetailJob.this.fMonitor.isCanceled()) {
                            ModuleDetailPane.this.getDetailDocument().set(result);
                        }
                        return Status.OK_STATUS;
                    }
                };
                setDetail.setSystem(true);
                setDetail.schedule();
            }
        }
    }

    class FindReplaceTargetWrapper
    implements IFindReplaceTarget {
        private IFindReplaceTarget fTarget;

        public FindReplaceTargetWrapper(IFindReplaceTarget target) {
            this.fTarget = target;
        }

        public boolean canPerformFind() {
            return this.fTarget.canPerformFind();
        }

        public int findAndSelect(int widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
            StyledText text;
            int position = this.fTarget.findAndSelect(widgetOffset, findString, searchForward, caseSensitive, wholeWord);
            if (ModuleDetailPane.this.fSourceViewer != null && (text = ModuleDetailPane.this.fSourceViewer.getTextWidget()) != null && !text.isDisposed()) {
                text.showSelection();
            }
            return position;
        }

        public Point getSelection() {
            return this.fTarget.getSelection();
        }

        public String getSelectionText() {
            return this.fTarget.getSelectionText();
        }

        public boolean isEditable() {
            return this.fTarget.isEditable();
        }

        public void replaceSelection(String text) {
            this.fTarget.replaceSelection(text);
        }
    }
}

