/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.app.DBPPlatformLanguage;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.registry.language.PlatformLanguageDescriptor;
import org.jkiss.dbeaver.registry.language.PlatformLanguageRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageDatabaseGeneral
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.common";
    private static final String NOTIFICATIONS_PAGE_ID = "org.eclipse.mylyn.commons.notifications.preferencePages.Notifications";
    private Button automaticUpdateCheck;
    private Combo workspaceLanguage;
    private Button longOperationsCheck;
    private Spinner longOperationsTimeout;
    private Button notificationsEnabled;
    private Spinner notificationsCloseDelay;

    public PrefPageDatabaseGeneral() {
        this.setPreferenceStore((IPreferenceStore)new PreferenceStoreDelegate(DBWorkbench.getPlatform().getPreferenceStore()));
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        Group groupObjects = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_ui_general_group_general, (int)2, (int)2, (int)0);
        this.automaticUpdateCheck = UIUtils.createCheckbox((Composite)groupObjects, (String)CoreMessages.pref_page_ui_general_checkbox_automatic_updates, null, (boolean)false, (int)2);
        Group groupLanguage = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_ui_general_group_language, (int)2, (int)2, (int)0);
        this.workspaceLanguage = UIUtils.createLabelCombo((Composite)groupLanguage, (String)CoreMessages.pref_page_ui_general_combo_language, (String)CoreMessages.pref_page_ui_general_combo_language_tip, (int)12);
        this.workspaceLanguage.setLayoutData((Object)new GridData(32));
        List languages = PlatformLanguageRegistry.getInstance().getLanguages();
        DBPPlatformLanguage pLanguage = DBeaverCore.getInstance().getLanguage();
        int i = 0;
        while (i < languages.size()) {
            PlatformLanguageDescriptor lang = (PlatformLanguageDescriptor)languages.get(i);
            this.workspaceLanguage.add(lang.getLabel());
            if (CommonUtils.equalObjects((Object)pLanguage, (Object)lang)) {
                this.workspaceLanguage.select(i);
            }
            ++i;
        }
        if (this.workspaceLanguage.getSelectionIndex() < 0) {
            this.workspaceLanguage.select(0);
        }
        Label tipLabel = UIUtils.createLabel((Composite)groupLanguage, (String)CoreMessages.pref_page_ui_general_label_options_take_effect_after_restart);
        tipLabel.setLayoutData((Object)new GridData(32, 2, false, false, 2, 1));
        Group notificationsGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_ui_general_group_notifications, (int)2, (int)770, (int)0);
        this.notificationsEnabled = UIUtils.createCheckbox((Composite)notificationsGroup, (String)CoreMessages.pref_page_ui_general_label_enable_notifications, (String)CoreMessages.pref_page_ui_general_label_enable_notifications_tip, (boolean)false, (int)2);
        this.notificationsCloseDelay = UIUtils.createLabelSpinner((Composite)notificationsGroup, (String)CoreMessages.pref_page_ui_general_label_notifications_close_delay, (int)0, (int)0, (int)Integer.MAX_VALUE);
        new PreferenceLinkArea((Composite)notificationsGroup, 0, NOTIFICATIONS_PAGE_ID, "<a>''{0}''</a> " + CoreMessages.pref_page_ui_general_label_settings, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        Group agentGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_ui_general_group_task_bar, (int)2, (int)770, (int)0);
        this.longOperationsCheck = UIUtils.createCheckbox((Composite)agentGroup, (String)CoreMessages.pref_page_ui_general_label_enable_long_operations, (String)CoreMessages.pref_page_ui_general_label_enable_long_operations_tip, (boolean)false, (int)2);
        this.longOperationsTimeout = UIUtils.createLabelSpinner((Composite)agentGroup, (String)CoreMessages.pref_page_ui_general_label_long_operation_timeout, (int)0, (int)0, (int)Integer.MAX_VALUE);
        if (RuntimeUtils.isPlatformMacOS()) {
            ControlEnableState.disable((Control)agentGroup);
        }
        new PreferenceLinkArea(composite, 0, "org.jkiss.dbeaver.preferences.main.entityeditor", "<a>''{0}''</a> " + CoreMessages.pref_page_ui_general_label_settings, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        new PreferenceLinkArea(composite, 0, "org.jkiss.dbeaver.preferences.main.sqleditor", "<a>''{0}''</a>" + CoreMessages.pref_page_ui_general_label_settings, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        this.performDefaults();
        return composite;
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.automaticUpdateCheck.setSelection(store.getBoolean("ui.auto.update.check"));
        this.notificationsEnabled.setSelection(store.getBoolean("notifications.enabled"));
        this.notificationsCloseDelay.setSelection(store.getInt("notifications.closeDelay"));
        this.longOperationsCheck.setSelection(store.getBoolean("agent.long.operation.notify"));
        this.longOperationsTimeout.setSelection(store.getInt("agent.long.operation.timeout"));
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setValue("ui.auto.update.check", this.automaticUpdateCheck.getSelection());
        store.setValue("notifications.enabled", this.notificationsEnabled.getSelection());
        store.setValue("notifications.closeDelay", this.notificationsCloseDelay.getSelection());
        store.setValue("agent.long.operation.notify", this.longOperationsCheck.getSelection());
        store.setValue("agent.long.operation.timeout", this.longOperationsTimeout.getSelection());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        if (this.workspaceLanguage.getSelectionIndex() >= 0) {
            PlatformLanguageDescriptor language = (PlatformLanguageDescriptor)PlatformLanguageRegistry.getInstance().getLanguages().get(this.workspaceLanguage.getSelectionIndex());
            try {
                DBPPlatformLanguage curLanguage = DBeaverCore.getInstance().getLanguage();
                if (curLanguage != language) {
                    DBeaverCore.getInstance().setPlatformLanguage((DBPPlatformLanguage)language);
                    if (UIUtils.confirmAction((Shell)this.getShell(), (String)("Restart " + GeneralUtils.getProductName()), (String)("You need to restart " + GeneralUtils.getProductName() + " to perform actual language change.\nDo you want to restart?"))) {
                        UIUtils.asyncExec(() -> {
                            boolean bl = PlatformUI.getWorkbench().restart();
                        });
                    }
                }
            }
            catch (DBException e) {
                DBeaverUI.getInstance().showError("Change language", "Can't switch language to " + language, e);
            }
        }
        return true;
    }

    @Nullable
    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable element) {
    }
}

