/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.services.IDisposable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.core.WorkbenchContextListener;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAAuthInfo;
import org.jkiss.dbeaver.model.access.DBAPasswordChangeInfo;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverDependencies;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProcessDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProcessListener;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.TrayIconHandler;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceInvalidateHandler;
import org.jkiss.dbeaver.ui.dialogs.AcceptLicenseDialog;
import org.jkiss.dbeaver.ui.dialogs.StandardErrorDialog;
import org.jkiss.dbeaver.ui.dialogs.connection.BaseAuthDialog;
import org.jkiss.dbeaver.ui.dialogs.connection.PasswordChangeDialog;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverDownloadDialog;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverEditDialog;
import org.jkiss.dbeaver.ui.dialogs.exec.ExecutionQueueErrorJob;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectOpen;
import org.jkiss.dbeaver.ui.navigator.dialogs.BrowseObjectDialog;
import org.jkiss.dbeaver.ui.views.process.ProcessPropertyTester;
import org.jkiss.dbeaver.ui.views.process.ShellProcessView;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class DBeaverUI
implements DBPPlatformUI {
    private static final Log log = Log.getLog(DBeaverUI.class);
    private static DBeaverUI instance;
    private TrayIconHandler trayItem;
    private final List<IDisposable> globalDisposables = new ArrayList<IDisposable>();
    private WorkbenchContextListener contextListener;

    public static DBeaverUI getInstance() {
        if (instance == null) {
            instance = new DBeaverUI();
            instance.initialize();
        }
        return instance;
    }

    static void disposeUI() {
        if (instance != null) {
            try {
                instance.dispose();
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
        }
    }

    private void dispose() {
        if (this.trayItem != null) {
            this.trayItem.hide();
        }
        ArrayList<IDisposable> dispList = new ArrayList<IDisposable>(this.globalDisposables);
        Collections.reverse(dispList);
        for (IDisposable disp : dispList) {
            try {
                disp.dispose();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            this.globalDisposables.remove(disp);
        }
    }

    private void initialize() {
        this.trayItem = new TrayIconHandler();
        DBeaverCore.isStandalone();
        UIUtils.asyncExec(() -> {
            WorkbenchContextListener workbenchContextListener = this.contextListener = WorkbenchContextListener.registerInWorkbench();
        });
    }

    public void refreshPartContexts(IWorkbenchPart part) {
        if (this.contextListener != null) {
            this.contextListener.deactivatePartContexts(part);
            this.contextListener.activatePartContexts(part);
        }
    }

    public void notifyAgent(String message, int status) {
        if (!ModelPreferences.getPreferences().getBoolean("agent.long.operation.notify")) {
            return;
        }
        DBeaverUI.getInstance().trayItem.notify(message, status);
    }

    public boolean acceptLicense(final String message, final String licenseText) {
        return (Boolean)new UITask<Boolean>(){

            protected Boolean runTask() {
                return AcceptLicenseDialog.acceptLicense((Shell)UIUtils.getActiveWorkbenchShell(), (String)message, (String)licenseText);
            }
        }.execute();
    }

    public boolean downloadDriverFiles(final DBPDriver driver, final DBPDriverDependencies dependencies) {
        return (Boolean)new UITask<Boolean>(){

            protected Boolean runTask() {
                return DriverDownloadDialog.downloadDriverFiles(null, driver, dependencies);
            }
        }.execute();
    }

    public DBPPlatformUI.UserResponse showError(@NotNull String title, @Nullable String message, @NotNull IStatus status) {
        IStatus s = status;
        while (s != null) {
            if (s.getException() instanceof DBException) {
                DBPPlatformUI.UserResponse dbErrorResp = DBeaverUI.showDatabaseError(message, (DBException)s.getException());
                if (dbErrorResp == null) break;
                return dbErrorResp;
            }
            if (s.getChildren() == null || s.getChildren().length <= 0) break;
            s = s.getChildren()[0];
        }
        Runnable runnable = () -> {
            StandardErrorDialog dialog = new StandardErrorDialog(UIUtils.getActiveWorkbenchShell(), title, message, status, 4);
            dialog.open();
        };
        UIUtils.syncExec((Runnable)runnable);
        return DBPPlatformUI.UserResponse.OK;
    }

    public DBPPlatformUI.UserResponse showError(@NotNull String title, @Nullable String message, @NotNull Throwable error) {
        log.error((Object)error);
        return this.showError(title, message, GeneralUtils.makeExceptionStatus((Throwable)error));
    }

    public DBPPlatformUI.UserResponse showError(@NotNull String title, @Nullable String message) {
        return this.showError(title, null, (IStatus)new Status(4, "org.jkiss.dbeaver.core", message));
    }

    public void showMessageBox(String title, String message, boolean error) {
        UIUtils.showMessageBox((Shell)UIUtils.getActiveWorkbenchShell(), (String)title, (String)message, (int)(error ? 1 : 2));
    }

    public DBPPlatformUI.UserResponse showErrorStopRetryIgnore(String task, Throwable error, boolean queue) {
        return ExecutionQueueErrorJob.showError((String)task, (Throwable)error, (boolean)queue);
    }

    public long getLongOperationTimeout() {
        return DBWorkbench.getPlatform().getPreferenceStore().getLong("agent.long.operation.timeout");
    }

    private static DBPPlatformUI.UserResponse showDatabaseError(String message, DBException error) {
        DBPDataSource dataSource = error.getDataSource();
        DBPErrorAssistant.ErrorType errorType = dataSource == null ? DBPErrorAssistant.ErrorType.NORMAL : DBUtils.discoverErrorType((DBPDataSource)dataSource, (Throwable)error);
        switch (errorType) {
            case CONNECTION_LOST: {
                if (dataSource.getContainer().getDataSource() == null) {
                    return null;
                }
                DataSourceInvalidateHandler.showConnectionLostDialog(null, message, error);
                return DBPPlatformUI.UserResponse.OK;
            }
            case DRIVER_CLASS_MISSING: {
                DriverEditDialog.showBadConfigDialog(null, message, error);
                return DBPPlatformUI.UserResponse.OK;
            }
        }
        return null;
    }

    public DBAAuthInfo promptUserCredentials(final String prompt, final String userName, final String userPassword, final boolean passwordOnly, final boolean showSavePassword) {
        return (DBAAuthInfo)new UITask<DBAAuthInfo>(){

            public DBAAuthInfo runTask() {
                Shell shell = UIUtils.getActiveWorkbenchShell();
                BaseAuthDialog authDialog = new BaseAuthDialog(shell, prompt, passwordOnly, showSavePassword);
                if (!passwordOnly) {
                    authDialog.setUserName(userName);
                }
                authDialog.setUserPassword(userPassword);
                if (authDialog.open() == 0) {
                    return authDialog.getAuthInfo();
                }
                return null;
            }
        }.execute();
    }

    public DBAPasswordChangeInfo promptUserPasswordChange(final String prompt, final String userName, final String oldPassword) {
        return (DBAPasswordChangeInfo)new UITask<DBAPasswordChangeInfo>(){

            public DBAPasswordChangeInfo runTask() {
                Shell shell = UIUtils.getActiveWorkbenchShell();
                PasswordChangeDialog passwordChangeDialog = new PasswordChangeDialog(shell, prompt, userName, oldPassword);
                if (passwordChangeDialog.open() == 0) {
                    return passwordChangeDialog.getPasswordInfo();
                }
                return null;
            }
        }.execute();
    }

    public DBNNode selectObject(Object parentShell, String title, DBNNode rootNode, DBNNode selectedNode, Class<?>[] allowedTypes, Class<?>[] resultTypes, Class<?>[] leafTypes) {
        Shell shell = parentShell instanceof Shell ? (Shell)parentShell : UIUtils.getActiveWorkbenchShell();
        return BrowseObjectDialog.selectObject((Shell)shell, (String)title, (DBNNode)rootNode, (DBNNode)selectedNode, (Class[])allowedTypes, (Class[])resultTypes, (Class[])leafTypes);
    }

    public void openEntityEditor(DBSObject object) {
        NavigatorHandlerObjectOpen.openEntityEditor((DBSObject)object);
    }

    public void openEntityEditor(DBNNode selectedNode, String defaultPageId) {
        NavigatorHandlerObjectOpen.openEntityEditor((DBNNode)selectedNode, (String)defaultPageId, (IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow());
    }

    public void openConnectionEditor(DBPDataSourceContainer dataSourceContainer) {
        UIUtils.syncExec(() -> NavigatorHandlerObjectOpen.openConnectionEditor((IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow(), (DBPDataSourceContainer)dataSourceContainer));
    }

    public void executeProcess(DBRProcessDescriptor processDescriptor) {
        processDescriptor.setProcessListener(new DBRProcessListener(){

            public void onProcessStarted() {
                ProcessPropertyTester.firePropertyChange("running");
            }

            public void onProcessTerminated(int resultCode) {
                ProcessPropertyTester.firePropertyChange("running");
            }
        });
        try {
            processDescriptor.execute();
        }
        catch (DBException e) {
            this.showError("Execute process", processDescriptor.getName(), e);
        }
        if (processDescriptor.getCommand().isShowProcessPanel()) {
            UIUtils.asyncExec(() -> {
                try {
                    ShellProcessView processView = (ShellProcessView)UIUtils.getActiveWorkbenchWindow().getActivePage().showView("org.jkiss.dbeaver.core.shellProcess", ShellProcessView.getNextId(), 2);
                    processView.initProcess(processDescriptor);
                }
                catch (PartInitException e) {
                    log.error((Object)e);
                }
            });
        }
    }

    public void executeInUI(Runnable runnable) {
        UIUtils.syncExec((Runnable)runnable);
    }

    public <RESULT> Job createLoadingService(ILoadService<RESULT> loadingService, ILoadVisualizer<RESULT> visualizer) {
        return LoadingJob.createService(loadingService, visualizer);
    }

    public void refreshPartState(Object part) {
        if (part instanceof IWorkbenchPart) {
            UIUtils.asyncExec(() -> DBeaverUI.getInstance().refreshPartContexts((IWorkbenchPart)part));
        }
    }
}

