/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;

public class DriverClassLoader
extends URLClassLoader {
    private final DriverDescriptor driver;

    public DriverClassLoader(DriverDescriptor driver, URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.driver = driver;
    }

    @Override
    protected String findLibrary(String libname) {
        String nativeName = System.mapLibraryName(libname);
        for (DBPDriverLibrary dBPDriverLibrary : this.driver.getDriverLibraries()) {
            String fileName;
            File localFile;
            if (dBPDriverLibrary.getType() != DBPDriverLibrary.FileType.lib || !dBPDriverLibrary.matchesCurrentPlatform() || (localFile = dBPDriverLibrary.getLocalFile()) == null || !localFile.exists() || !(fileName = localFile.getName()).equalsIgnoreCase(nativeName)) continue;
            return localFile.getAbsolutePath();
        }
        return super.findLibrary(libname);
    }
}

