/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValue;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public abstract class BaseValueHandler
implements DBDValueHandler {
    @Override
    @NotNull
    public String getValueContentType(@NotNull DBSTypedObject attribute) {
        return "text/plain";
    }

    @Override
    public Object createNewValueObject(DBCSession session, DBSTypedObject type) throws DBCException {
        throw new DBCException("New '" + type.getTypeName() + "' object create not supported");
    }

    @Override
    public void releaseValueObject(Object value) {
        if (value instanceof DBDValue) {
            ((DBDValue)value).release();
        }
    }

    @Override
    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        return DBValueFormatting.getDefaultValueDisplayString(value, format);
    }

    @Override
    @NotNull
    public DBCLogicalOperator[] getSupportedOperators(@NotNull DBSTypedObject attribute) {
        return DBUtils.getAttributeOperators(attribute);
    }
}

