/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.ArrayList;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreLanguage;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedureKind;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.object.struct.CreateProcedurePage;
import org.jkiss.utils.CommonUtils;

public class PostgreProcedureConfigurator
implements DBEObjectConfigurator<PostgreSchema, PostgreProcedure> {
    protected static final Log log = Log.getLog(PostgreProcedureConfigurator.class);

    public PostgreProcedure configureObject(final DBRProgressMonitor monitor, final PostgreSchema parent, final PostgreProcedure newProcedure) {
        return (PostgreProcedure)new UITask<PostgreProcedure>(){

            protected PostgreProcedure runTask() {
                CreateFunctionPage editPage = new CreateFunctionPage(parent, monitor);
                if (!editPage.edit()) {
                    return null;
                }
                if (editPage.getPredefinedProcedureType() == DBSProcedureType.FUNCTION) {
                    newProcedure.setKind(PostgreProcedureKind.f);
                    newProcedure.setReturnType(editPage.getReturnType());
                } else {
                    newProcedure.setKind(PostgreProcedureKind.p);
                }
                newProcedure.setName(editPage.getProcedureName());
                newProcedure.setLanguage(editPage.getLanguage());
                return newProcedure;
            }
        }.execute();
    }

    private static class CreateFunctionPage
    extends CreateProcedurePage {
        private final PostgreSchema parent;
        private final DBRProgressMonitor monitor;
        private PostgreLanguage language;
        private PostgreDataType returnType;
        private Combo returnTypeCombo;

        public CreateFunctionPage(PostgreSchema parent, DBRProgressMonitor monitor) {
            super((DBSObjectContainer)parent);
            this.parent = parent;
            this.monitor = monitor;
        }

        public DBSProcedureType getPredefinedProcedureType() {
            if (this.parent.getDataSource().isServerVersionAtLeast(11, 0)) {
                return null;
            }
            return DBSProcedureType.FUNCTION;
        }

        protected void updateProcedureType(DBSProcedureType type) {
            this.returnTypeCombo.setEnabled(type.hasReturnValue());
        }

        protected void createExtraControls(Composite group) {
            ArrayList languages = new ArrayList();
            try {
                languages.addAll(this.parent.getDatabase().getLanguages(this.monitor));
            }
            catch (DBException e2) {
                log.error((Object)e2);
            }
            Combo languageCombo = UIUtils.createLabelCombo((Composite)group, (String)"Language", (int)12);
            for (PostgreLanguage lang : languages) {
                languageCombo.add(lang.getName());
            }
            languageCombo.addModifyListener(e -> {
                this.language = (PostgreLanguage)languages.get(languageCombo.getSelectionIndex());
            });
            languageCombo.setText("sql");
            ArrayList dataTypes = new ArrayList(this.parent.getDatabase().getDataSource().getLocalDataTypes());
            this.returnTypeCombo = UIUtils.createLabelCombo((Composite)group, (String)"Return type", (int)4);
            for (PostgreDataType dt : dataTypes) {
                this.returnTypeCombo.add(dt.getName());
            }
            this.returnTypeCombo.addModifyListener(e -> {
                String dtName = this.returnTypeCombo.getText();
                this.returnType = !CommonUtils.isEmpty((String)dtName) ? this.parent.getDatabase().getDataSource().getLocalDataType(dtName) : null;
            });
            this.returnTypeCombo.setText("int4");
        }

        public PostgreLanguage getLanguage() {
            return this.language;
        }

        public PostgreDataType getReturnType() {
            return this.returnType;
        }
    }
}

