/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableParametrized;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.ui.TextUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLCommandHandlerDescriptor;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLCommandsRegistry;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLCommandCompletionProposal;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLCompletionAnalyzer;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLCompletionProposal;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLContext;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLTemplateCompletionProposal;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLTemplatesRegistry;
import org.jkiss.dbeaver.ui.editors.text.parser.SQLWordPartDetector;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SQLCompletionProcessor
implements IContentAssistProcessor {
    private static final Log log = Log.getLog(SQLCompletionProcessor.class);
    static final String ALL_COLUMNS_PATTERN = "*";
    private static IContextInformationValidator VALIDATOR = new Validator();
    private static boolean lookupTemplates = false;
    private static boolean simpleMode = false;
    private final SQLEditorBase editor;

    public static boolean isLookupTemplates() {
        return lookupTemplates;
    }

    public static void setLookupTemplates(boolean lookupTemplates) {
        SQLCompletionProcessor.lookupTemplates = lookupTemplates;
    }

    static void setSimpleMode(boolean simpleMode) {
        SQLCompletionProcessor.simpleMode = simpleMode;
    }

    public SQLCompletionProcessor(SQLEditorBase editor) {
        this.editor = editor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        SQLCompletionAnalyzer.CompletionRequest request = new SQLCompletionAnalyzer.CompletionRequest(this.editor, documentOffset, simpleMode);
        SQLWordPartDetector wordDetector = request.wordDetector = new SQLWordPartDetector(viewer.getDocument(), this.editor.getSyntaxManager(), documentOffset);
        request.wordPart = wordDetector.getWordPart();
        if (lookupTemplates) {
            return this.makeTemplateProposals(viewer, request);
        }
        try {
            String commandPrefix = this.editor.getSyntaxManager().getControlCommandPrefix();
            if (request.wordDetector.getStartOffset() >= commandPrefix.length() && viewer.getDocument().get(request.wordDetector.getStartOffset() - commandPrefix.length(), commandPrefix.length()).equals(commandPrefix)) {
                return this.makeCommandProposals(request, request.wordPart);
            }
        }
        catch (BadLocationException e) {
            log.debug((Object)e);
        }
        String searchPrefix = request.wordPart;
        request.queryType = null;
        String prevKeyWord = wordDetector.getPrevKeyWord();
        if (!CommonUtils.isEmpty((String)prevKeyWord)) {
            if (this.editor.getSyntaxManager().getDialect().isEntityQueryWord(prevKeyWord)) {
                request.queryType = "INTO".equals(prevKeyWord) && !CommonUtils.isEmpty((Collection)wordDetector.getPrevWords()) && ("(".equals(wordDetector.getPrevDelimiter()) || ",".equals(wordDetector.getPrevDelimiter())) ? QueryType.COLUMN : ("JOIN".equals(prevKeyWord) ? QueryType.JOIN : QueryType.TABLE);
            } else if (this.editor.getSyntaxManager().getDialect().isAttributeQueryWord(prevKeyWord)) {
                request.queryType = QueryType.COLUMN;
                if (!request.simpleMode && CommonUtils.isEmpty((String)request.wordPart) && wordDetector.getPrevDelimiter().equals(ALL_COLUMNS_PATTERN)) {
                    wordDetector.moveToDelimiter();
                    searchPrefix = ALL_COLUMNS_PATTERN;
                }
            } else if (SQLUtils.isExecQuery((SQLDialect)this.editor.getSyntaxManager().getDialect(), (String)prevKeyWord)) {
                request.queryType = QueryType.EXEC;
            }
        }
        request.wordPart = searchPrefix;
        DBPDataSource dataSource = this.editor.getDataSource();
        if (request.wordPart != null && dataSource != null) {
            ProposalSearchJob searchJob = new ProposalSearchJob(request);
            searchJob.schedule();
            UIUtils.waitJobCompletion((AbstractJob)searchJob);
        }
        if (!request.searchFinished && !CommonUtils.isEmpty((String)request.wordPart)) {
            List matchedKeywords = this.editor.getSyntaxManager().getDialect().getMatchedKeywords(request.wordPart);
            if (!request.simpleMode) {
                matchedKeywords.sort(Comparator.comparingInt(o -> TextUtils.fuzzyScore((CharSequence)o, (CharSequence)completionRequest.wordPart)));
            }
            for (String keyWord : matchedKeywords) {
                DBPKeywordType keywordType = this.editor.getSyntaxManager().getDialect().getKeywordType(keyWord);
                if (keywordType == null || keywordType == DBPKeywordType.TYPE || request.queryType == QueryType.COLUMN && keywordType != DBPKeywordType.FUNCTION && keywordType != DBPKeywordType.KEYWORD) continue;
                request.proposals.add(SQLCompletionAnalyzer.createCompletionProposal(request, keyWord, keyWord, keywordType, null, false, null));
            }
        }
        this.filterProposals(request, dataSource);
        return (ICompletionProposal[])ArrayUtils.toArray(ICompletionProposal.class, request.proposals);
    }

    private void filterProposals(SQLCompletionAnalyzer.CompletionRequest request, DBPDataSource dataSource) {
        boolean hideDups;
        HashSet<String> proposalMap = new HashSet<String>(request.proposals.size());
        int i = 0;
        while (i < request.proposals.size()) {
            SQLCompletionProposal proposal = request.proposals.get(i);
            if (proposalMap.contains(proposal.getDisplayString())) {
                request.proposals.remove(i);
                continue;
            }
            proposalMap.add(proposal.getDisplayString());
            ++i;
        }
        DBSObject selectedObject = dataSource == null ? null : DBUtils.getActiveInstanceObject((DBSInstance)dataSource.getDefaultInstance());
        boolean bl = hideDups = this.editor.getActivePreferenceStore().getBoolean("SQLEditor.ContentAssistant.hide.duplicates") && selectedObject != null;
        if (hideDups) {
            int i2 = 0;
            while (i2 < request.proposals.size()) {
                SQLCompletionProposal proposal = request.proposals.get(i2);
                int j = 0;
                while (j < request.proposals.size()) {
                    SQLCompletionProposal proposal2 = request.proposals.get(j);
                    if (i2 != j && proposal.hasStructObject() && proposal2.hasStructObject() && CommonUtils.equalObjects((Object)proposal.getObject().getName(), (Object)proposal2.getObject().getName()) && proposal.getObjectContainer() == selectedObject) {
                        request.proposals.remove(j);
                        continue;
                    }
                    ++j;
                }
                ++i2;
            }
        }
        if (hideDups) {
            boolean cfr_ignored_0 = selectedObject instanceof DBSObjectContainer;
        }
    }

    private ICompletionProposal[] makeCommandProposals(SQLCompletionAnalyzer.CompletionRequest request, String prefix) {
        String controlCommandPrefix = this.editor.getSyntaxManager().getControlCommandPrefix();
        if (prefix.startsWith(controlCommandPrefix)) {
            prefix = prefix.substring(controlCommandPrefix.length());
        }
        ArrayList<SQLCommandCompletionProposal> commandProposals = new ArrayList<SQLCommandCompletionProposal>();
        for (SQLCommandHandlerDescriptor command : SQLCommandsRegistry.getInstance().getCommandHandlers()) {
            if (!command.getId().startsWith(prefix)) continue;
            commandProposals.add(new SQLCommandCompletionProposal(request, command));
        }
        return commandProposals.toArray(new ICompletionProposal[commandProposals.size()]);
    }

    @NotNull
    private ICompletionProposal[] makeTemplateProposals(ITextViewer viewer, SQLCompletionAnalyzer.CompletionRequest request) {
        String wordPart = request.wordPart.toLowerCase();
        ArrayList<SQLTemplateCompletionProposal> templateProposals = new ArrayList<SQLTemplateCompletionProposal>();
        Template[] templateArray = this.editor.getTemplatesPage().getTemplateStore().getTemplates();
        int n = templateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Template template = templateArray[n2];
            if (template.getName().toLowerCase().startsWith(wordPart)) {
                templateProposals.add(new SQLTemplateCompletionProposal(template, (TemplateContext)new SQLContext(SQLTemplatesRegistry.getInstance().getTemplateContextRegistry().getContextType(template.getContextTypeId()), viewer.getDocument(), new Position(request.wordDetector.getStartOffset(), request.wordDetector.getLength()), this.editor), (IRegion)new Region(request.documentOffset, 0), null));
            }
            ++n2;
        }
        templateProposals.sort(Comparator.comparing(TemplateProposal::getDisplayString));
        return templateProposals.toArray(new ICompletionProposal[templateProposals.size()]);
    }

    @Nullable
    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        SQLScriptElement statementInfo = this.editor.extractQueryAtPos(documentOffset);
        if (statementInfo == null || CommonUtils.isEmpty((String)statementInfo.getText())) {
            return null;
        }
        IContextInformation[] result = new IContextInformation[]{new ContextInformation(statementInfo.getText(), statementInfo.getText())};
        return result;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        char[] cArray;
        boolean useKeystrokes = this.editor.getActivePreferenceStore().getBoolean("SQLEditor.ContentAssistant.auto.keystrokes.activation");
        if (useKeystrokes) {
            cArray = ".abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_$".toCharArray();
        } else {
            char[] cArray2 = new char[1];
            cArray = cArray2;
            cArray2[0] = 46;
        }
        return cArray;
    }

    @Nullable
    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    @Nullable
    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return VALIDATOR;
    }

    private class ProposalSearchJob
    extends AbstractJob {
        private final SQLCompletionAnalyzer.CompletionRequest request;

        ProposalSearchJob(SQLCompletionAnalyzer.CompletionRequest request) {
            super("Search proposals...");
            this.setSystem(false);
            this.request = request;
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            try {
                monitor.beginTask("Seeking for SQL completion proposals", 1);
                try {
                    monitor.subTask("Find proposals");
                    SQLCompletionAnalyzer analyzer = new SQLCompletionAnalyzer(this.request);
                    DBUtils.tryExecuteRecover((Object)monitor, (DBPDataSource)SQLCompletionProcessor.this.editor.getDataSource(), (DBRRunnableParametrized)analyzer);
                }
                finally {
                    monitor.done();
                }
                this.applyFilters();
                return Status.OK_STATUS;
            }
            catch (Throwable e) {
                log.error((Object)e);
                return Status.CANCEL_STATUS;
            }
        }

        private void applyFilters() {
            DBPDataSource dataSource = SQLCompletionProcessor.this.editor.getDataSource();
            if (dataSource == null) {
                return;
            }
            DBPDataSourceContainer dsContainer = dataSource.getContainer();
            HashMap<DBSObject, Map> containerMap = new HashMap<DBSObject, Map>();
            for (SQLCompletionProposal sQLCompletionProposal : this.request.proposals) {
                DBSObject container = sQLCompletionProposal.getObjectContainer();
                DBPNamedObject object = sQLCompletionProposal.getObject();
                if (object == null) continue;
                Map typeMap = containerMap.computeIfAbsent(container, k -> new HashMap());
                Class objectType = object instanceof DBSObjectReference ? ((DBSObjectReference)object).getObjectClass() : object.getClass();
                List list = typeMap.computeIfAbsent(objectType, k -> new ArrayList());
                list.add(sQLCompletionProposal);
            }
            for (Map.Entry entry : containerMap.entrySet()) {
                for (Map.Entry typeEntry : ((Map)entry.getValue()).entrySet()) {
                    DBSObjectFilter filter = dsContainer.getObjectFilter((Class)typeEntry.getKey(), (DBSObject)entry.getKey(), true);
                    if (filter == null || !filter.isEnabled()) continue;
                    for (SQLCompletionProposal proposal : (List)typeEntry.getValue()) {
                        if (filter.matches(proposal.getObject().getName())) continue;
                        this.request.proposals.remove(proposal);
                    }
                }
            }
        }
    }

    static enum QueryType {
        TABLE,
        JOIN,
        COLUMN,
        EXEC;

    }

    protected static class Validator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        int fInstallOffset;

        protected Validator() {
        }

        public boolean isContextInformationValid(int offset) {
            return Math.abs(this.fInstallOffset - offset) < 5;
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            this.fInstallOffset = offset;
        }

        public boolean updatePresentation(int documentPosition, TextPresentation presentation) {
            return false;
        }
    }
}

