/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.sql.format.SQLFormatter;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLFormatterConfigurator;
import org.jkiss.utils.CommonUtils;

public class SQLFormatterDescriptor
extends AbstractContextDescriptor {
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.sqlFormatter";
    private final String id;
    private final String label;
    private final String description;
    private final AbstractDescriptor.ObjectType formatterImplClass;
    private final AbstractDescriptor.ObjectType configurerImplClass;

    public SQLFormatterDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.formatterImplClass = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.configurerImplClass = !CommonUtils.isEmpty((String)config.getAttribute("configurerClass")) ? new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("configurerClass")) : null;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    @NotNull
    public SQLFormatter createFormatter() throws DBException {
        return (SQLFormatter)this.formatterImplClass.createInstance(SQLFormatter.class);
    }

    @Nullable
    public SQLFormatterConfigurator createConfigurer() throws DBException {
        if (this.configurerImplClass == null) {
            return null;
        }
        return (SQLFormatterConfigurator)this.configurerImplClass.createInstance(SQLFormatterConfigurator.class);
    }
}

